/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.Locale;
import java.util.UUID;
import java.util.stream.Stream;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Style;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;
import ovh.corail.tombstone.ModTombstone;
import ovh.corail.tombstone.command.TombstoneCommand;
import ovh.corail.tombstone.helper.BackupService;
import ovh.corail.tombstone.helper.InventoryHelper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.StorageHelper;
import ovh.corail.tombstone.helper.StyleType;
import ovh.corail.tombstone.registry.ModDataComponents;
import ovh.corail.tombstone.registry.ModItems;

public final class CommandTBReviveFamiliar
extends TombstoneCommand {
    private static final int MAX_SAVES = 20;

    @Override
    protected TombstoneCommand.CommandName getCommandName() {
        return TombstoneCommand.CommandName.REVIVE_FAMILIAR;
    }

    @Override
    LiteralArgumentBuilder<CommandSourceStack> getBuilder(LiteralArgumentBuilder<CommandSourceStack> builder, CommandBuildContext buildContext) {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)builder.executes(this::showUsage)).then(Commands.argument((String)"player", (ArgumentType)EntityArgument.player()).executes(this::reviveFamiliar));
    }

    private int reviveFamiliar(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        Style style;
        LangKey langKey;
        ItemStack receptacle;
        ServerPlayer player = EntityArgument.getPlayer(ctx, (String)"player");
        CommandTBReviveFamiliar.checkAlive((Entity)player);
        CommandTBReviveFamiliar.checkNotSpectator((Entity)player);
        CompoundTag petTag = CommandTBReviveFamiliar.getLastSave(((CommandSourceStack)ctx.getSource()).getServer(), (Player)player);
        if (petTag != null) {
            receptacle = new ItemStack((ItemLike)ModItems.receptacle_of_familiar);
            receptacle.set(ModDataComponents.ENTITY_TYPE, (Object)petTag.getString("id"));
            ModDataComponents.getCompoundTag(receptacle).put("dead_pet", (Tag)petTag);
        } else {
            receptacle = InventoryHelper.findFirstInInventory((Player)player, ModItems.receptacle_of_familiar::containSoul);
        }
        if (receptacle.isEmpty()) {
            throw LangKey.MESSAGE_NO_SAVE_TO_RESTORE.asCommandException(new Object[0]);
        }
        if (ModItems.receptacle_of_familiar.revive((Player)player, player.blockPosition(), receptacle, false)) {
            langKey = LangKey.MESSAGE_BRING_BACK_TO_LIFE;
            style = StyleType.MESSAGE_SPELL;
        } else {
            langKey = LangKey.MESSAGE_CANT_REVIVE_FAMILIAR;
            style = StyleType.COLOR_OFF;
        }
        langKey.sendMessage((Player)player, style, new Object[]{LangKey.MESSAGE_YOUR_FAMILIAR.getText(new Object[0])});
        if (!player.equals((Object)((CommandSourceStack)ctx.getSource()).getEntity())) {
            this.sendMessage((CommandSourceStack)ctx.getSource(), langKey.getText(style, new Object[]{LangKey.MESSAGE_FAMILIAR_OF.getText(player.getName())}), false);
        }
        receptacle.shrink(1);
        player.inventoryMenu.broadcastChanges();
        return 1;
    }

    @Nullable
    public static CompoundTag getLastSave(MinecraftServer server, Player player) {
        File saveFolder = new File(StorageHelper.getSavedFamiliarFolder(server), player.getGameProfile().getId().toString());
        if (!saveFolder.exists()) {
            return null;
        }
        File[] saveFiles = saveFolder.listFiles(p -> p.isFile() && p.getName().endsWith(".save"));
        if (saveFiles == null || saveFiles.length == 0) {
            return null;
        }
        File file = Stream.of(saveFiles).max(File::compareTo).orElse(null);
        CompoundTag nbt = StorageHelper.loadCompound(file);
        if (nbt.isEmpty()) {
            return null;
        }
        file.delete();
        return nbt;
    }

    public static void saveFamiliar(MinecraftServer server, UUID ownerId, CompoundTag tag, String saveName) {
        File saveFolder = new File(StorageHelper.getSavedFamiliarFolder(server), ownerId.toString());
        if (!saveFolder.exists() && !saveFolder.mkdirs()) {
            ModTombstone.LOGGER.info("The backup folder for familiars cannot be created");
            return;
        }
        String dateString = new SimpleDateFormat("yyyyMMdd-HHmmss", Locale.US).format(new Date());
        File accessedFile = new File(saveFolder, dateString + "_" + saveName + ".save");
        BackupService.get().execute(() -> {
            File[] matchingFiles;
            if (StorageHelper.save(accessedFile, tag) && (matchingFiles = saveFolder.listFiles((file, name) -> name.endsWith(".save"))) != null && matchingFiles.length > 20) {
                int diff = matchingFiles.length - 20;
                Arrays.sort(matchingFiles, Comparator.comparingLong(File::lastModified));
                int num = 0;
                for (File file2 : matchingFiles) {
                    if (num >= diff) break;
                    file2.delete();
                    ++num;
                }
            }
        });
    }
}

