/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import ovh.corail.tombstone.api.cooldown.CooldownType;
import ovh.corail.tombstone.capability.PlayerKnowledgeHandler;
import ovh.corail.tombstone.command.ISubCommand;
import ovh.corail.tombstone.command.TombstoneCommand;
import ovh.corail.tombstone.helper.CooldownHandler;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.PlayerPreference;
import ovh.corail.tombstone.helper.StyleType;

public final class CommandTBKnowledge
extends TombstoneCommand {
    private static final int MAX_KNOWLEDGE_VALUE = 255;
    private static final SuggestionProvider<CommandSourceStack> KNOWLEDGE_AMOUNT_SUGGESTION = (ctx, build) -> build.suggest(0, () -> "[0-255]").buildFuture();

    @Override
    protected TombstoneCommand.CommandName getCommandName() {
        return TombstoneCommand.CommandName.KNOWLEDGE;
    }

    @Override
    LiteralArgumentBuilder<CommandSourceStack> getBuilder(LiteralArgumentBuilder<CommandSourceStack> builder, CommandBuildContext buildContext) {
        builder.executes(this::showUsage);
        builder.then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument((String)"player", (ArgumentType)EntityArgument.player()).executes(this::showKnowledge)).then(SubCommand.SHOW.literal().executes(this::showKnowledge))).then(((LiteralArgumentBuilder)SubCommand.SET.literal().executes(this::showUsage)).then(Commands.argument((String)"amount", (ArgumentType)IntegerArgumentType.integer()).suggests(KNOWLEDGE_AMOUNT_SUGGESTION).executes(this::setKnowledge)))).then(((LiteralArgumentBuilder)SubCommand.INCREASE.literal().executes(this::showUsage)).then(Commands.argument((String)"amount", (ArgumentType)IntegerArgumentType.integer()).suggests(AMOUNT_SUGGESTION).executes(this::giveKnowledge)))).then(((LiteralArgumentBuilder)SubCommand.DECREASE.literal().executes(this::showUsage)).then(Commands.argument((String)"amount", (ArgumentType)IntegerArgumentType.integer()).suggests(AMOUNT_SUGGESTION).executes(this::removeKnowledge)))).then(SubCommand.RESET_ANKH.literal().executes(this::resetAnkhCooldown))).then(SubCommand.RESET_PERKS.literal().executes(this::resetPerks)));
        return builder;
    }

    private int showKnowledge(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ServerPlayer target = EntityArgument.getPlayer(ctx, (String)"player");
        this.sendMessage((CommandSourceStack)ctx.getSource(), LangKey.MESSAGE_SHOW_KNOWLEDGE.getText(StyleType.MESSAGE_SPELL, new Object[]{target.getName(), PlayerKnowledgeHandler.getTotalPerkPoints((Player)target), PlayerKnowledgeHandler.getKnowledge((Player)target)}), false);
        return 1;
    }

    private int setKnowledge(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        int oldKnowledge;
        ServerPlayer target = EntityArgument.getPlayer(ctx, (String)"player");
        int knowledgeLevel = IntegerArgumentType.getInteger(ctx, (String)"amount");
        if (knowledgeLevel < 0) {
            throw LangKey.MESSAGE_POSITIVE_INTEGER.asCommandException(new Object[0]);
        }
        if (knowledgeLevel > 255) {
            throw LangKey.MESSAGE_INVALID_VALUE.asCommandException(new Object[0]);
        }
        int newKnowledge = PlayerKnowledgeHandler.getKnowledgeForLevel(knowledgeLevel);
        int adjust = newKnowledge - (oldKnowledge = PlayerKnowledgeHandler.getKnowledge((Player)target));
        if (adjust >= 0) {
            this.increaseKnowledge((CommandSourceStack)ctx.getSource(), target, adjust);
        } else {
            this.decreaseKnowledge((CommandSourceStack)ctx.getSource(), target, Math.abs(adjust));
        }
        return 1;
    }

    private int giveKnowledge(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ServerPlayer target = EntityArgument.getPlayer(ctx, (String)"player");
        int amount = IntegerArgumentType.getInteger(ctx, (String)"amount");
        if (amount <= 0) {
            throw LangKey.MESSAGE_POSITIVE_INTEGER.asCommandException(new Object[0]);
        }
        this.increaseKnowledge((CommandSourceStack)ctx.getSource(), target, amount);
        return 1;
    }

    private int removeKnowledge(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ServerPlayer target = EntityArgument.getPlayer(ctx, (String)"player");
        int amount = IntegerArgumentType.getInteger(ctx, (String)"amount");
        if (amount <= 0) {
            throw LangKey.MESSAGE_POSITIVE_INTEGER.asCommandException(new Object[0]);
        }
        this.decreaseKnowledge((CommandSourceStack)ctx.getSource(), target, amount);
        return 1;
    }

    private void increaseKnowledge(CommandSourceStack source, ServerPlayer target, int amount) {
        PlayerKnowledgeHandler.rewardKnowledge(target, amount);
        if (!target.equals((Object)source.getEntity()) || !PlayerPreference.get(target).displayKnowledgeMessage()) {
            this.sendMessage(source, LangKey.MESSAGE_INCREASE_OF.getText(LangKey.MESSAGE_PLAYER_KNOWLEDGE.getText(target.getName()), amount), false);
        }
    }

    private void decreaseKnowledge(CommandSourceStack source, ServerPlayer target, int amount) {
        PlayerKnowledgeHandler.loseKnowledge(target, amount);
        if (!target.equals((Object)source.getEntity()) || !PlayerPreference.get(target).displayKnowledgeMessage()) {
            this.sendMessage(source, LangKey.MESSAGE_DECREASE_OF.getText(StyleType.MESSAGE_SPELL, new Object[]{LangKey.MESSAGE_PLAYER_KNOWLEDGE.getText(target.getName()), amount}), false);
        }
    }

    private int resetAnkhCooldown(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ServerPlayer player = EntityArgument.getPlayer(ctx, (String)"player");
        if (CooldownHandler.INSTANCE.hasCooldown((Player)player, CooldownType.NEXT_PRAY)) {
            CooldownHandler.INSTANCE.setCooldown(player, CooldownType.NEXT_PRAY, 0);
        }
        this.sendMessage((CommandSourceStack)ctx.getSource(), LangKey.MESSAGE_RESET_ANKH_SUCCESS.getText(StyleType.MESSAGE_SPELL, new Object[0]), false);
        return 1;
    }

    private int resetPerks(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ServerPlayer player = EntityArgument.getPlayer(ctx, (String)"player");
        PlayerKnowledgeHandler.resetPerks(player);
        this.sendMessage((CommandSourceStack)ctx.getSource(), LangKey.MESSAGE_PERK_RESET_SUCCESS.getText(StyleType.MESSAGE_SPELL, new Object[0]), false);
        return 1;
    }

    private static enum SubCommand implements ISubCommand
    {
        SHOW,
        SET,
        INCREASE,
        DECREASE,
        RESET_ANKH,
        RESET_PERKS;

    }
}

