/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.capability;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.Nullable;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.NBTStackHelper;
import ovh.corail.tombstone.helper.PlayerPreference;
import ovh.corail.tombstone.helper.StyleType;
import ovh.corail.tombstone.network.CMessageLevelUp;
import ovh.corail.tombstone.network.CMessagePlayerCapSyncKnowledge;
import ovh.corail.tombstone.network.PacketHandler;
import ovh.corail.tombstone.perk.Perk;
import ovh.corail.tombstone.registry.ModTriggers;

public class PlayerKnowledgeHandler {
    private static final String KNOWLEDGE = "knowledge";

    public static int getKnowledge(Player player) {
        return EntityHelper.getTombstoneTag(player).getInt(KNOWLEDGE);
    }

    public static void setKnowledge(Player player, int points) {
        EntityHelper.getTombstoneTag(player).putInt(KNOWLEDGE, Math.max(0, points));
    }

    public static void rewardKnowledge(ServerPlayer player, int knowledge) {
        if (EntityHelper.isValidServerPlayer(player) && knowledge > 0) {
            int newPerkPoints;
            int earnedPerkPoints;
            int oldPerkPoints = PlayerKnowledgeHandler.getTotalPerkPoints((Player)player);
            PlayerKnowledgeHandler.setKnowledge((Player)player, PlayerKnowledgeHandler.getKnowledge((Player)player) + knowledge);
            if (PlayerPreference.get(player).displayKnowledgeMessage()) {
                LangKey.MESSAGE_INCREASE_OF.sendMessage((Player)player, StyleType.MESSAGE_SPELL, new Object[]{LangKey.MESSAGE_YOUR_KNOWLEDGE.getText(new Object[0]), knowledge});
            }
            if ((earnedPerkPoints = (newPerkPoints = PlayerKnowledgeHandler.getTotalPerkPoints((Player)player)) - oldPerkPoints) > 0) {
                PacketHandler.sendToPlayer(new CMessageLevelUp(earnedPerkPoints), player);
                if (oldPerkPoints == 0) {
                    ModTriggers.first_knowledge.trigger(player);
                }
                if (oldPerkPoints < 10 && newPerkPoints >= 10) {
                    ModTriggers.mastery_1.trigger(player);
                }
                if (oldPerkPoints < 20 && newPerkPoints >= 20) {
                    ModTriggers.mastery_2.trigger(player);
                }
            }
            PacketHandler.sendToPlayer(new CMessagePlayerCapSyncKnowledge(PlayerKnowledgeHandler.getKnowledge((Player)player)), player);
        }
    }

    public static void loseKnowledge(ServerPlayer player, int points) {
        if (EntityHelper.isValidServerPlayer(player)) {
            int oldPerkPoints = PlayerKnowledgeHandler.getTotalPerkPoints((Player)player);
            PlayerKnowledgeHandler.setKnowledge((Player)player, PlayerKnowledgeHandler.getKnowledge((Player)player) - points);
            int lostPerkPoints = oldPerkPoints - PlayerKnowledgeHandler.getTotalPerkPoints((Player)player);
            if (lostPerkPoints > 0) {
                Map<Perk, Integer> perks = PlayerKnowledgeHandler.getPerks((Player)player);
                Iterator<Map.Entry<Perk, Integer>> it = perks.entrySet().iterator();
                while (it.hasNext() && lostPerkPoints > 0) {
                    Map.Entry<Perk, Integer> entry = it.next();
                    if (Helper.isDisabledPerk(entry.getKey(), (Player)player)) {
                        it.remove();
                    }
                    for (int i = entry.getValue().intValue(); i >= 1 && lostPerkPoints > 0; --i) {
                        int cost = entry.getKey().getCost(i);
                        lostPerkPoints -= cost;
                        if (i == 1) {
                            it.remove();
                            continue;
                        }
                        entry.setValue(i - 1);
                    }
                }
                PlayerKnowledgeHandler.setPerks((Player)player, perks);
                EntityHelper.syncPlayerCapability(player);
            } else {
                PacketHandler.sendToPlayer(new CMessagePlayerCapSyncKnowledge(PlayerKnowledgeHandler.getKnowledge((Player)player)), player);
            }
            if (PlayerPreference.get(player).displayKnowledgeMessage()) {
                LangKey.MESSAGE_DECREASE_OF.sendMessage((Player)player, StyleType.MESSAGE_SPELL, new Object[]{LangKey.MESSAGE_YOUR_KNOWLEDGE.getText(new Object[0]), points});
            }
        }
    }

    public static int getKnowledgeForLevel(int level) {
        return level <= 0 ? 0 : level * level + 1;
    }

    public static int getUsedPerkPoints(Player player) {
        int perkPoints = 0;
        Iterator<Map.Entry<Perk, Integer>> it = PlayerKnowledgeHandler.getPerks(player).entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Perk, Integer> entry = it.next();
            if (Helper.isDisabledPerk(entry.getKey(), player)) {
                it.remove();
                continue;
            }
            for (int i = entry.getValue().intValue(); i >= 1; --i) {
                perkPoints += entry.getKey().getCost(i);
            }
        }
        return perkPoints;
    }

    public static int getTotalPerkPoints(Player player) {
        return (int)Mth.sqrt((float)(PlayerKnowledgeHandler.getKnowledge(player) - 1));
    }

    public static Map<Perk, Integer> getPerks(Player player) {
        HashMap<Perk, Integer> perks = new HashMap<Perk, Integer>();
        NBTStackHelper.readPerks(perks, EntityHelper.getTombstoneTag(player));
        return perks;
    }

    public static void setPerks(Player player, Map<Perk, Integer> perks) {
        NBTStackHelper.writePerks(perks, EntityHelper.getTombstoneTag(player));
    }

    public static void setPerk(Player player, Perk perk, int level) {
        Map<Perk, Integer> perks = PlayerKnowledgeHandler.getPerks(player);
        perks.put(perk, level);
        PlayerKnowledgeHandler.setPerks(player, perks);
    }

    public static void removePerk(Player player, Perk perk) {
        Map<Perk, Integer> perks = PlayerKnowledgeHandler.getPerks(player);
        perks.remove(perk);
        PlayerKnowledgeHandler.setPerks(player, perks);
    }

    public static int getPerkLevel(Player player, Perk perk) {
        return perk.isDisabled(player) ? 0 : PlayerKnowledgeHandler.getPerks(player).getOrDefault(perk, 0);
    }

    public static int getPerkLevelWithBonus(Player player, @Nullable Perk perk) {
        if (EntityHelper.isValidPlayer(player) && perk != null && !perk.isDisabled(player)) {
            return Math.min(PlayerKnowledgeHandler.getPerkLevel(player, perk) + perk.getLevelBonus(player), perk.getLevelMax());
        }
        return 0;
    }

    public static void resetPerks(ServerPlayer player) {
        PlayerKnowledgeHandler.setPerks((Player)player, new HashMap<Perk, Integer>());
        EntityHelper.syncPlayerCapability(player);
    }
}

