/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.capability;

import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.PlayerPreference;
import ovh.corail.tombstone.helper.StyleType;
import ovh.corail.tombstone.network.CMessagePlayerCapSyncAlignment;
import ovh.corail.tombstone.network.PacketHandler;

public class PlayerAlignmentHandler {
    private static final String ALIGNMENT = "alignment";

    public static int getAlignmentValue(Player player) {
        return EntityHelper.getTombstoneTag(player).getShort(ALIGNMENT);
    }

    public static int getAlignmentMinValue() {
        return -5000;
    }

    public static int getAlignmentMaxValue() {
        return 5000;
    }

    public static void setAlignment(Player player, int value) {
        EntityHelper.getTombstoneTag(player).putShort(ALIGNMENT, (short)value);
    }

    public static int getAlignmentLevel(Player player) {
        int alignment = PlayerAlignmentHandler.getAlignmentValue(player);
        if (alignment <= PlayerAlignmentHandler.getAlignmentMinValue()) {
            return -4;
        }
        if (alignment <= -3000) {
            return -3;
        }
        if (alignment <= -1500) {
            return -2;
        }
        if (alignment <= -500) {
            return -1;
        }
        if (alignment < 500) {
            return 0;
        }
        if (alignment < 1500) {
            return 1;
        }
        if (alignment < 3000) {
            return 2;
        }
        if (alignment < PlayerAlignmentHandler.getAlignmentMaxValue()) {
            return 3;
        }
        return 4;
    }

    public static void rewardAlignment(ServerPlayer player, int alignment) {
        if (EntityHelper.isValidServerPlayer(player) && alignment != 0) {
            if (PlayerPreference.get(player).displayAlignmentMessage()) {
                (alignment > 0 ? LangKey.MESSAGE_INCREASE_OF : LangKey.MESSAGE_DECREASE_OF).sendMessage((Player)player, StyleType.MESSAGE_SPELL, new Object[]{LangKey.MESSAGE_YOUR_ALIGNMENT.getText(new Object[0]), Math.abs(alignment)});
            }
            int oldAlignment = PlayerAlignmentHandler.getAlignmentLevel((Player)player);
            if (alignment > 0 && oldAlignment < 0 || alignment < 0 && oldAlignment > 0) {
                alignment *= 2;
            }
            PlayerAlignmentHandler.setAlignment((Player)player, PlayerAlignmentHandler.getAlignmentValue((Player)player) + alignment);
            PacketHandler.sendToPlayer(new CMessagePlayerCapSyncAlignment(PlayerAlignmentHandler.getAlignmentValue((Player)player)), player);
        }
    }
}

