/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.stream.IntStream;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Containers;
import net.minecraft.world.Difficulty;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.neoforge.common.ItemAbility;
import org.jetbrains.annotations.Nullable;
import ovh.corail.tombstone.block.BlockGraveBase;
import ovh.corail.tombstone.block.GraveModel;
import ovh.corail.tombstone.blockEntity.BlockEntityPlayerGrave;
import ovh.corail.tombstone.capability.PlayerAlignmentHandler;
import ovh.corail.tombstone.config.ConfigTombstone;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.PlayerPreference;
import ovh.corail.tombstone.helper.RegistryHelper;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.registry.ModBlocks;
import ovh.corail.tombstone.registry.ModItems;
import ovh.corail.tombstone.registry.ModTriggers;

public final class BlockGrave
extends BlockGraveBase
implements EntityBlock {
    public static final MapCodec<BlockGrave> CODEC = RecordCodecBuilder.mapCodec(c -> c.group((App)Codec.INT.fieldOf("grave_model").forGetter(a -> a.graveModel.ordinal())).apply((Applicative)c, modelId -> new BlockGrave(GraveModel.byId(modelId))));

    public BlockGrave(GraveModel graveModel) {
        super(BlockGrave.getBuilder(), graveModel);
    }

    protected MapCodec<BlockGrave> codec() {
        return CODEC;
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        if (!level.isClientSide()) {
            return this.activatePlayerGrave(level, pos, state, (ServerPlayer)player) ? InteractionResult.SUCCESS : InteractionResult.FAIL;
        }
        return InteractionResult.SUCCESS;
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        this.useWithoutItem(state, level, pos, player, hitResult);
        return ItemInteractionResult.SUCCESS;
    }

    private boolean activatePlayerGrave(Level level, BlockPos pos, BlockState state, ServerPlayer player) {
        if (level.isClientSide()) {
            return true;
        }
        BlockEntityPlayerGrave grave = Helper.getPlayerGrave(level, pos).orElse(null);
        if (grave == null || grave.countTicks < 30 || !player.isAlive()) {
            return false;
        }
        boolean hasKey = ModItems.grave_key.removeKeyForGraveInInventory((Player)player, grave);
        boolean isOwner = grave.isOwner((Player)player);
        if (!hasKey && isOwner) {
            ModTriggers.easy_opening.trigger(player);
        }
        boolean isTombRaiding = false;
        if (hasKey || isOwner || (isTombRaiding = !grave.getNeedAccess())) {
            grave.giveInventory(player);
            if (level.getLevelData().getDifficulty() != Difficulty.PEACEFUL && (Integer)ConfigTombstone.player_death.chanceMobOnGraveRecovery.get() > 0 && Helper.RANDOM.nextInt(100) < (Integer)ConfigTombstone.player_death.chanceMobOnGraveRecovery.get()) {
                IntStream.range(0, Helper.RANDOM.nextInt(3) + 1).forEach(i -> Helper.spawnRandomMob((ServerLevel)level, pos));
            }
            if (isTombRaiding) {
                ModTriggers.tomb_raiding.trigger(player);
                PlayerAlignmentHandler.rewardAlignment(player, (Integer)ConfigTombstone.alignment.pointsPlunderPlayerGrave.get());
                LangKey.MESSAGE_TOMB_RAIDER_SUCCESS.sendMessage((Player)player, new Object[0]);
            }
        } else {
            LangKey.MESSAGE_OPEN_GRAVE_NEED_KEY.sendMessage((Player)player, new Object[0]);
        }
        return true;
    }

    public void entityInside(BlockState state, Level level, BlockPos pos, Entity entity) {
        ServerPlayer player;
        if (!level.isClientSide() && entity.isShiftKeyDown() && entity.isAlive() && TimeHelper.atInterval(entity, 20) && EntityHelper.isValidPlayer(entity) && PlayerPreference.get(player = (ServerPlayer)entity).activateGraveBySneaking() && this.activatePlayerGrave(level, pos, state, player)) {
            ModTriggers.sneak_grave.trigger(player);
        }
    }

    public boolean canHarvestBlock(BlockState state, BlockGetter blockGetter, BlockPos pos, Player player) {
        return false;
    }

    public float getDestroyProgress(BlockState state, Player player, BlockGetter blockGetter, BlockPos pos) {
        return 0.0f;
    }

    @Nullable
    public BlockState getToolModifiedState(BlockState state, UseOnContext context, ItemAbility toolAction, boolean simulate) {
        return null;
    }

    @Override
    protected void onDrop(Level level, BlockPos pos, BlockState oldState) {
        Helper.getPlayerGrave(level, pos).ifPresent(grave -> {
            for (int i = 0; i < grave.getInventory().getSlots(); ++i) {
                ItemStack stack = grave.getInventory().getStackInSlot(i);
                if (stack.isEmpty()) continue;
                Containers.dropItemStack((Level)level, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (ItemStack)grave.getInventory().extractItem(i, stack.getCount(), false));
            }
        });
    }

    public ItemStack asDecorativeStack() {
        Item item;
        ResourceLocation registryName = RegistryHelper.getRegistryName((Block)this);
        if (registryName != null && (item = RegistryHelper.getItem(ResourceLocation.fromNamespaceAndPath((String)registryName.getNamespace(), (String)("decorative_" + registryName.getPath())))) != null) {
            return new ItemStack((ItemLike)item);
        }
        return ItemStack.EMPTY;
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new BlockEntityPlayerGrave(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> entityType) {
        return BlockGrave.createTickerHelper(entityType, ModBlocks.tile_grave, level.isClientSide() ? BlockEntityPlayerGrave::clientTick : BlockEntityPlayerGrave::serverTick);
    }

    private static BlockBehaviour.Properties getBuilder() {
        return BlockBehaviour.Properties.of().mapColor(MapColor.STONE).strength(-1.0f, 1.8E7f).sound(SoundType.STONE);
    }
}

