/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.titanium.util;

import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.level.Level;

public class RecipeUtil {
    public static <T extends Recipe<?>> List<T> getRecipes(Level world, RecipeType<T> recipeType) {
        Multimap recipes = world.getRecipeManager().byType;
        if (recipes != null) {
            Collection typedRecipes = recipes.get(recipeType);
            return typedRecipes.stream().map(h -> h.value()).collect(Collectors.toList());
        }
        return new ArrayList();
    }

    public static Collection<SmeltingRecipe> getCookingRecipes(Level world) {
        return RecipeUtil.getRecipes(world, RecipeType.SMELTING);
    }

    @Nullable
    public static SmeltingRecipe getSmelingRecipeFor(Level world, ItemStack stack) {
        return RecipeUtil.getCookingRecipes(world).stream().filter(furnaceRecipe -> ((Ingredient)furnaceRecipe.getIngredients().get(0)).test(stack)).findFirst().orElse(null);
    }
}

