/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.titanium.recipe.serializer;

import com.mojang.serialization.MapCodec;
import java.util.function.Supplier;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;

public class CodecRecipeSerializer<T extends Recipe<?>>
implements RecipeSerializer<T> {
    private final Class<T> recipeClass;
    private final Supplier<RecipeType<?>> recipeTypeSupplier;
    private final MapCodec<T> codec;
    private final StreamCodec<RegistryFriendlyByteBuf, T> streamCodec;

    public CodecRecipeSerializer(Class<T> recipeClass, Supplier<RecipeType<?>> recipeTypeSupplier, MapCodec<T> codec) {
        this.recipeClass = recipeClass;
        this.recipeTypeSupplier = recipeTypeSupplier;
        this.codec = codec;
        this.streamCodec = StreamCodec.ofMember((value, buff) -> buff.writeJsonWithCodec(this.codec().codec(), value), registryFriendlyByteBuf -> (Recipe)registryFriendlyByteBuf.readJsonWithCodec(this.codec.codec()));
    }

    public StreamCodec<RegistryFriendlyByteBuf, T> streamCodec() {
        return this.streamCodec;
    }

    public MapCodec<T> codec() {
        return this.codec;
    }
}

