/*
 * Decompiled with CFR 0.152.
 */
package org.mangorage.tiab.common.integration.jei;

import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IIngredientAcceptor;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.mangorage.tiab.common.api.ICommonTimeInABottleAPI;
import org.mangorage.tiab.common.integration.TiabCategoryInfo;

public class TiabCategory
implements IRecipeCategory<TiabCategoryInfo> {
    public static final RecipeType<TiabCategoryInfo> RECIPE_TYPE = RecipeType.create((String)"tiab", (String)"resource_generator", TiabCategoryInfo.class);
    private final IDrawable backrgound;
    private final IDrawable icon;
    private final IDrawable slotBackground;

    public TiabCategory(IJeiHelpers helper) {
        IGuiHelper gui = helper.getGuiHelper();
        this.backrgound = gui.createBlankDrawable(160, 125);
        this.icon = gui.createDrawableItemStack(ICommonTimeInABottleAPI.COMMON_API.get().getRegistration().getTiabItem().asItem().getDefaultInstance());
        this.slotBackground = gui.getSlotDrawable();
    }

    public RecipeType<TiabCategoryInfo> getRecipeType() {
        return RECIPE_TYPE;
    }

    public Component getTitle() {
        return Component.translatable((String)"emi.category.tiab.test");
    }

    public IDrawable getBackground() {
        return this.backrgound;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, TiabCategoryInfo recipe, IFocusGroup focuses) {
        int xPos = 72;
        int startPosWidth = 0;
        int startPosHeight = 20;
        IRecipeSlotBuilder inputSlotBuilder = builder.addSlot(RecipeIngredientRole.CATALYST, xPos, 1).setBackground(this.slotBackground, -1, -1);
        TiabCategory.addIngredient(VanillaTypes.ITEM_STACK, ICommonTimeInABottleAPI.COMMON_API.get().getRegistration().getTiabItem().asItem().getDefaultInstance(), inputSlotBuilder);
        for (Item item : recipe.getItems()) {
            builder.addSlot(RecipeIngredientRole.OUTPUT, startPosWidth, startPosHeight).setBackground(this.slotBackground, -1, -1).addIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)item));
            if ((startPosWidth += 18) <= 161) continue;
            startPosHeight += 18;
            startPosWidth = 0;
        }
    }

    private static <T> void addIngredient(IIngredientType<T> type, T ingredient, IIngredientAcceptor<?> slotBuilder) {
        slotBuilder.addIngredient(type, ingredient);
    }
}

