/*
 * Decompiled with CFR 0.152.
 */
package org.mangorage.tiab.common.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import org.mangorage.tiab.common.client.renderer.BlockFaceTextRenderer;
import org.mangorage.tiab.common.entities.TimeAcceleratorEntity;

public class TimeAcceleratorEntityRenderer
extends EntityRenderer<TimeAcceleratorEntity> {
    private static final BlockFaceTextRenderer textRenderer = BlockFaceTextRenderer.create();

    public TimeAcceleratorEntityRenderer(EntityRendererProvider.Context erp) {
        super(erp);
    }

    public void render(TimeAcceleratorEntity entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, int packedLightIn) {
        String timeRate = "x" + 2 * entity.getTimeRate();
        float paddingLeftRight = 2 * entity.getTimeRate() < 10 ? 0.11f : 0.19f;
        int remainingTimeSeconds = entity.getRemainingTime() / 20;
        String timeRemaining = remainingTimeSeconds + "s";
        BlockFaceTextRenderer.IDrawText rendererText = textRenderer.of(poseStack, bufferSource);
        rendererText.render(BlockFaceTextRenderer.Face.valuesList(), timeRate, packedLightIn, 0xFFFFFF, paddingLeftRight, 0.064f, 0.51f);
        rendererText.render(BlockFaceTextRenderer.Face.valuesList(), timeRemaining, packedLightIn, remainingTimeSeconds > 10 ? 0xFFFFFF : 0xFF0000, paddingLeftRight, 0.264f, 0.51f);
    }

    public ResourceLocation getTextureLocation(TimeAcceleratorEntity entity) {
        return ResourceLocation.fromNamespaceAndPath((String)"tiab", (String)"accelerate");
    }
}

