/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.integration.emi;

import com.klikli_dev.theurgy.content.recipe.FermentationRecipe;
import com.klikli_dev.theurgy.integration.emi.EmiPlugin;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.render.EmiTexture;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.material.Fluid;
import org.jetbrains.annotations.Nullable;

public class FermentationEmiRecipe
implements EmiRecipe {
    private final RecipeHolder<FermentationRecipe> recipe;

    public FermentationEmiRecipe(RecipeHolder<FermentationRecipe> recipe) {
        this.recipe = recipe;
    }

    public EmiRecipeCategory getCategory() {
        return EmiPlugin.FERMENTATION_CATEGORY;
    }

    @Nullable
    public ResourceLocation getId() {
        return this.recipe.id();
    }

    public List<EmiIngredient> getInputs() {
        ArrayList<EmiIngredient> inputs = new ArrayList<EmiIngredient>();
        ((FermentationRecipe)this.recipe.value()).getIngredients().forEach(ingredient -> inputs.add(EmiIngredient.of((Ingredient)ingredient)));
        inputs.add(EmiIngredient.of(Arrays.stream(((FermentationRecipe)this.recipe.value()).getFluid().getFluids()).map(f -> EmiStack.of((Fluid)f.getFluid(), (long)((FermentationRecipe)this.recipe.value()).getFluidAmount())).toList()));
        return inputs;
    }

    public List<EmiStack> getOutputs() {
        return List.of(EmiStack.of((ItemStack)((FermentationRecipe)this.recipe.value()).getResultItem((HolderLookup.Provider)RegistryAccess.EMPTY)));
    }

    public int getDisplayWidth() {
        return 102;
    }

    public int getDisplayHeight() {
        return 43;
    }

    public void addWidgets(WidgetHolder widgets) {
        widgets.addTexture(EmiTexture.EMPTY_ARROW, 45, 8);
        int index = 0;
        for (Ingredient ingredient : ((FermentationRecipe)this.recipe.value()).getIngredients()) {
            int x = 1 + index % 2 * 18;
            int y = 1 + index / 2 * 18;
            widgets.addSlot(EmiIngredient.of((Ingredient)ingredient), x, y);
            ++index;
        }
        widgets.addSlot(EmiIngredient.of(Arrays.stream(((FermentationRecipe)this.recipe.value()).getFluid().getFluids()).map(f -> EmiStack.of((Fluid)f.getFluid(), (long)((FermentationRecipe)this.recipe.value()).getFluidAmount())).toList()), 19, 19);
        widgets.addSlot((EmiIngredient)EmiStack.of((ItemStack)((FermentationRecipe)this.recipe.value()).getResultItem((HolderLookup.Provider)RegistryAccess.EMPTY)), 81, 9).recipeContext((EmiRecipe)this);
        int cookTime = ((FermentationRecipe)this.recipe.value()).getTime();
        if (cookTime > 0) {
            int cookTimeSeconds = cookTime / 20;
            MutableComponent timeString = Component.translatable((String)"theurgy.gui.category.smelting.time.seconds", (Object[])new Object[]{cookTimeSeconds});
            Minecraft minecraft = Minecraft.getInstance();
            Font font = minecraft.font;
            int stringWidth = font.width((FormattedText)timeString);
            widgets.addText((Component)timeString, this.getDisplayWidth() - stringWidth, 34, -8355712, false);
        }
    }
}

