/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.datagen.recipe;

import com.google.gson.JsonObject;
import com.klikli_dev.theurgy.content.recipe.result.RecipeResult;
import com.klikli_dev.theurgy.datagen.recipe.JsonRecipeProvider;
import com.klikli_dev.theurgy.registry.FluidRegistry;
import com.klikli_dev.theurgy.registry.ItemRegistry;
import com.klikli_dev.theurgy.registry.ItemTagRegistry;
import com.klikli_dev.theurgy.registry.RecipeTypeRegistry;
import com.klikli_dev.theurgy.registry.SulfurRegistry;
import java.util.function.BiConsumer;
import net.minecraft.core.Holder;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.common.Tags;

public class LiquefactionRecipeProvider
extends JsonRecipeProvider {
    public static final int TIME = 100;

    public LiquefactionRecipeProvider(PackOutput packOutput) {
        super(packOutput, "theurgy", "liquefaction");
    }

    @Override
    public void buildRecipes(BiConsumer<ResourceLocation, JsonObject> recipeConsumer) {
        Fluid salAmmoniac = (Fluid)FluidRegistry.SAL_AMMONIAC.get();
        this.makeRecipe((Item)SulfurRegistry.OAK_LOG.get(), (TagKey<Item>)ItemTags.OAK_LOGS, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.SPRUCE_LOG.get(), Items.SPRUCE_LOG, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.BIRCH_LOG.get(), Items.BIRCH_LOG, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.JUNGLE_LOG.get(), Items.JUNGLE_LOG, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.ACACIA_LOG.get(), Items.ACACIA_LOG, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.CHERRY_LOG.get(), Items.CHERRY_LOG, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.DARK_OAK_LOG.get(), Items.DARK_OAK_LOG, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.MANGROVE_LOG.get(), Items.MANGROVE_LOG, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.CRIMSON_STEM.get(), Items.CRIMSON_STEM, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.WARPED_STEM.get(), Items.WARPED_STEM, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.ROWAN_LOG.get(), ItemTagRegistry.LOGS_ROWAN, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.FIR_LOG.get(), ItemTagRegistry.LOGS_FIR, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.REDWOOD_LOG.get(), ItemTagRegistry.LOGS_REDWOOD, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.MAHOGANY_LOG.get(), ItemTagRegistry.LOGS_MAHOGANY, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.JACARANDA_LOG.get(), ItemTagRegistry.LOGS_JACARANDA, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.PALM_LOG.get(), ItemTagRegistry.LOGS_PALM, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.WILLOW_LOG.get(), ItemTagRegistry.LOGS_WILLOW, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.DEAD_LOG.get(), ItemTagRegistry.LOGS_DEAD, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.MAGIC_LOG.get(), ItemTagRegistry.LOGS_MAGIC, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.UMBRAN_LOG.get(), ItemTagRegistry.LOGS_UMBRAN, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.HELLBARK_LOG.get(), ItemTagRegistry.LOGS_HELLBARK, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.CINNAMON_LOG.get(), ItemTagRegistry.LOGS_CINNAMON, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.GLACIAN_LOG.get(), ItemTagRegistry.LOGS_GLACIAN, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.ARCHWOOD_LOG.get(), ItemTagRegistry.LOGS_ARCHWOOD, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.BLUEBRIGHT_LOG.get(), ItemTagRegistry.LOGS_BLUEBRIGHT, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.STARLIT_LOG.get(), ItemTagRegistry.LOGS_STARLIT, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.FROSTBRIGHT_LOG.get(), ItemTagRegistry.LOGS_FROSTBRIGHT, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.COMET_LOG.get(), ItemTagRegistry.LOGS_COMET, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.LUNAR_LOG.get(), ItemTagRegistry.LOGS_LUNAR, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.DUSK_LOG.get(), ItemTagRegistry.LOGS_DUSK, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.MAPLE_LOG.get(), ItemTagRegistry.LOGS_MAPLE, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.CRYSTALLIZED_LOG.get(), ItemTagRegistry.LOGS_CRYSTALLIZED, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.LIVINGWOOD_LOG.get(), ItemTagRegistry.LOGS_LIVINGWOOD, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.GLIMMERING_LIVINGWOOD_LOG.get(), ItemTagRegistry.LOGS_GLIMMERING_LIVINGWOOD, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.DREAMWOOD_LOG.get(), ItemTagRegistry.LOGS_DREAMWOOD, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.GLIMMERING_DREAMWOOD_LOG.get(), ItemTagRegistry.LOGS_DREAMWOOD_GLIMMERING, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.WALNUT_LOG.get(), ItemTagRegistry.LOGS_WALNUT, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.FIG_LOG.get(), ItemTagRegistry.LOGS_FIG, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.WOLFBERRY_LOG.get(), ItemTagRegistry.LOGS_WOLFBERRY, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.ECHO_LOG.get(), ItemTagRegistry.LOGS_ECHO, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.ILLWOOD_LOG.get(), ItemTagRegistry.LOGS_ILLWOOD, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.UNDEAD_LOG.get(), ItemTagRegistry.LOGS_UNDEAD, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.AURUM_LOG.get(), ItemTagRegistry.LOGS_AURUM, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.MENRIL_LOG.get(), ItemTagRegistry.LOGS_MENRIL, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.ASHEN_LOG.get(), ItemTagRegistry.LOGS_ASHEN, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.AZALEA_LOG.get(), ItemTagRegistry.LOGS_AZALEA, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.TRUMPET_LOG.get(), ItemTagRegistry.LOGS_TRUMPET, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.NETHERWOOD_LOG.get(), ItemTagRegistry.LOGS_NETHERWOOD, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.SKYROOT_LOG.get(), ItemTagRegistry.LOGS_SKYROOT, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.GOLDEN_OAK_LOG.get(), ItemTagRegistry.LOGS_GOLDEN_OAK, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.TWILIGHT_OAK_LOG.get(), ItemTagRegistry.LOGS_TWILIGHT_OAK, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.CANOPY_TREE_LOG.get(), ItemTagRegistry.LOGS_CANOPY_TREE, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.DARKWOOD_LOG.get(), ItemTagRegistry.LOGS_DARKWOOD, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.TIMEWOOD_LOG.get(), ItemTagRegistry.LOGS_TIMEWOOD, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.TRANSWOOD_LOG.get(), ItemTagRegistry.LOGS_TRANSWOOD, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.SORTINGWOOD_LOG.get(), ItemTagRegistry.LOGS_SORTINGWOOD, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.MINEWOOD_LOG.get(), ItemTagRegistry.LOGS_MINEWOOD, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.SMOGSTEM_LOG.get(), ItemTagRegistry.LOGS_SMOGSTEM, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.WIGGLEWOOD_LOG.get(), ItemTagRegistry.LOGS_WIGGLEWOOD, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.GRONGLE_LOG.get(), ItemTagRegistry.LOGS_GRONGLE, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.RUBBERWOOD_LOG.get(), ItemTagRegistry.LOGS_RUBBERWOOD, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.OTHERWORLD_LOG.get(), ItemTagRegistry.LOGS_OTHERWORLD, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.BEETROOT.get(), Items.BEETROOT, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.CARROT.get(), Items.CARROT, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.POTATO.get(), Items.POTATO, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.WHEAT.get(), Items.WHEAT, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.APPLE.get(), Items.APPLE, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.COCOA.get(), Items.COCOA_BEANS, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.NETHER_WART.get(), Items.NETHER_WART, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.ARTICHOKE.get(), ItemTagRegistry.CROPS_ARTICHOKE, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.ASPARAGUS.get(), ItemTagRegistry.CROPS_ASPARAGUS, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.BARLEY.get(), ItemTagRegistry.CROPS_BARLEY, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.BASIL.get(), ItemTagRegistry.CROPS_BASIL, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.BELLPEPPER.get(), ItemTagRegistry.CROPS_BELLPEPPER, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.BLACKBEAN.get(), ItemTagRegistry.CROPS_BLACKBEAN, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.BLACKBERRY.get(), ItemTagRegistry.CROPS_BLACKBERRY, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.BLUEBERRY.get(), ItemTagRegistry.CROPS_BLUEBERRY, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.BROCCOLI.get(), ItemTagRegistry.CROPS_BROCCOLI, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.CABBAGE.get(), ItemTagRegistry.CROPS_CABBAGE, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.CANTALOUPE.get(), ItemTagRegistry.CROPS_CANTALOUPE, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.CAULIFLOWER.get(), ItemTagRegistry.CROPS_CAULIFLOWER, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.CELERY.get(), ItemTagRegistry.CROPS_CELERY, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.CHILE_PEPPER.get(), ItemTagRegistry.CROPS_CHILE_PEPPER, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.COFFEE_BEANS.get(), ItemTagRegistry.CROPS_COFFEE_BEANS, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.CORN.get(), ItemTagRegistry.CROPS_CORN, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.CRANBERRY.get(), ItemTagRegistry.CROPS_CRANBERRY, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.CUCUMBER.get(), ItemTagRegistry.CROPS_CUCUMBER, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.CURRANT.get(), ItemTagRegistry.CROPS_CURRANT, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.EGGPLANT.get(), ItemTagRegistry.CROPS_EGGPLANT, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.ELDERBERRY.get(), ItemTagRegistry.CROPS_ELDERBERRY, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.GARLIC.get(), ItemTagRegistry.CROPS_GARLIC, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.GINGER.get(), ItemTagRegistry.CROPS_GINGER, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.GRAPE.get(), ItemTagRegistry.CROPS_GRAPE, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.GREENBEAN.get(), ItemTagRegistry.CROPS_GREENBEAN, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.GREENONION.get(), ItemTagRegistry.CROPS_GREENONION, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.HONEYDEW.get(), ItemTagRegistry.CROPS_HONEYDEW, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.HOPS.get(), ItemTagRegistry.CROPS_HOPS, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.KALE.get(), ItemTagRegistry.CROPS_KALE, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.KIWI.get(), ItemTagRegistry.CROPS_KIWI, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.LEEK.get(), ItemTagRegistry.CROPS_LEEK, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.LETTUCE.get(), ItemTagRegistry.CROPS_LETTUCE, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.MUSTARD.get(), ItemTagRegistry.CROPS_MUSTARD, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.OAT.get(), ItemTagRegistry.CROPS_OAT, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.OLIVE.get(), ItemTagRegistry.CROPS_OLIVE, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.ONION.get(), ItemTagRegistry.CROPS_ONION, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.PEANUT.get(), ItemTagRegistry.CROPS_PEANUT, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.PEPPER.get(), ItemTagRegistry.CROPS_PEPPER, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.PINEAPPLE.get(), ItemTagRegistry.CROPS_PINEAPPLE, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.RADISH.get(), ItemTagRegistry.CROPS_RADISH, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.RASPBERRY.get(), ItemTagRegistry.CROPS_RASPBERRY, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.RHUBARB.get(), ItemTagRegistry.CROPS_RHUBARB, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.RICE.get(), ItemTagRegistry.CROPS_RICE, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.RUTABAGA.get(), ItemTagRegistry.CROPS_RUTABAGA, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.SAGUARO.get(), ItemTagRegistry.CROPS_SAGUARO, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.SOYBEAN.get(), ItemTagRegistry.CROPS_SOYBEAN, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.SPINACH.get(), ItemTagRegistry.CROPS_SPINACH, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.SQUASH.get(), ItemTagRegistry.CROPS_SQUASH, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.STRAWBERRY.get(), ItemTagRegistry.CROPS_STRAWBERRY, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.SWEETPOTATO.get(), ItemTagRegistry.CROPS_SWEETPOTATO, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.TEA_LEAVES.get(), ItemTagRegistry.CROPS_TEA_LEAVES, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.TOMATILLO.get(), ItemTagRegistry.CROPS_TOMATILLO, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.TOMATO.get(), ItemTagRegistry.CROPS_TOMATO, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.TURMERIC.get(), ItemTagRegistry.CROPS_TURMERIC, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.TURNIP.get(), ItemTagRegistry.CROPS_TURNIP, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.VANILLA.get(), ItemTagRegistry.CROPS_VANILLA, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.YAM.get(), ItemTagRegistry.CROPS_YAM, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.ZUCCHINI.get(), ItemTagRegistry.CROPS_ZUCCHINI, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.FLAX.get(), ItemTagRegistry.CROPS_FLAX, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.JUNIPERBERRY.get(), ItemTagRegistry.CROPS_JUNIPERBERRY, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.ALMOND.get(), ItemTagRegistry.CROPS_ALMOND, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.APRICOT.get(), ItemTagRegistry.CROPS_APRICOT, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.AVOCADO.get(), ItemTagRegistry.CROPS_AVOCADO, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.BANANA.get(), ItemTagRegistry.CROPS_BANANA, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.CASHEW.get(), ItemTagRegistry.CROPS_CASHEW, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.CHERRY.get(), ItemTagRegistry.CROPS_CHERRY, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.COCONUT.get(), ItemTagRegistry.CROPS_COCONUT, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.DATE.get(), ItemTagRegistry.CROPS_DATE, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.DRAGONFRUIT.get(), ItemTagRegistry.CROPS_DRAGONFRUIT, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.FIG.get(), ItemTagRegistry.CROPS_FIG, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.GRAPEFRUIT.get(), ItemTagRegistry.CROPS_GRAPEFRUIT, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.KUMQUAT.get(), ItemTagRegistry.CROPS_KUMQUAT, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.LEMON.get(), ItemTagRegistry.CROPS_LEMON, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.LIME.get(), ItemTagRegistry.CROPS_LIME, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.MANDARIN.get(), ItemTagRegistry.CROPS_MANDARIN, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.MANGO.get(), ItemTagRegistry.CROPS_MANGO, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.NECTARINE.get(), ItemTagRegistry.CROPS_NECTARINE, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.NUTMEG.get(), ItemTagRegistry.CROPS_NUTMEG, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.ORANGE.get(), ItemTagRegistry.CROPS_ORANGE, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.PEACH.get(), ItemTagRegistry.CROPS_PEACH, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.PEAR.get(), ItemTagRegistry.CROPS_PEAR, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.PECAN.get(), ItemTagRegistry.CROPS_PECAN, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.PERSIMMON.get(), ItemTagRegistry.CROPS_PERSIMMON, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.PLUM.get(), ItemTagRegistry.CROPS_PLUM, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.ROTTEN_FLESH.get(), Items.ROTTEN_FLESH, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.SPIDER_EYE.get(), Items.SPIDER_EYE, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.STRING.get(), Items.STRING, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.GUNPOWDER.get(), Items.GUNPOWDER, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.BONE.get(), Items.BONE, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.ARROW.get(), Items.ARROW, salAmmoniac, 15);
        this.makeRecipe((Item)SulfurRegistry.SLIMEBALL.get(), Items.SLIME_BALL, salAmmoniac, 15);
        this.makeRecipe((Item)SulfurRegistry.ENDER_PEARL.get(), Items.ENDER_PEARL, salAmmoniac, 15);
        this.makeRecipe((Item)SulfurRegistry.BLAZE_ROD.get(), Items.BLAZE_ROD, salAmmoniac, 15);
        this.makeRecipe((Item)SulfurRegistry.PRISMARINE_SHARD.get(), Items.PRISMARINE_SHARD, salAmmoniac, 15);
        this.makeRecipe((Item)SulfurRegistry.PHANTOM_MEMBRANE.get(), Items.PHANTOM_MEMBRANE, salAmmoniac, 15);
        this.makeRecipe((Item)SulfurRegistry.MAGMA_CREAM.get(), Items.MAGMA_CREAM, salAmmoniac, 15);
        this.makeRecipe((Item)SulfurRegistry.SKELETON_SKULL.get(), Items.SKELETON_SKULL, salAmmoniac, 15);
        this.makeRecipe((Item)SulfurRegistry.WITHER_SKELETON_SKULL.get(), Items.WITHER_SKELETON_SKULL, salAmmoniac, 20);
        this.makeRecipe((Item)SulfurRegistry.GHAST_TEAR.get(), Items.GHAST_TEAR, salAmmoniac, 20);
        this.makeRecipe((Item)SulfurRegistry.SHULKER_SHELL.get(), Items.SHULKER_SHELL, salAmmoniac, 20);
        this.makeRecipe((Item)SulfurRegistry.ELYTRA.get(), Items.ELYTRA, salAmmoniac, 20);
        this.makeRecipe((Item)SulfurRegistry.NETHER_STAR.get(), Items.NETHER_STAR, salAmmoniac, 100);
        this.makeRecipe((Item)SulfurRegistry.DRAGON_EGG.get(), Items.DRAGON_EGG, salAmmoniac, 100);
        this.makeRecipe((Item)SulfurRegistry.HEART_OF_THE_SEA.get(), Items.HEART_OF_THE_SEA, salAmmoniac, 100);
        this.makeRecipe((Item)SulfurRegistry.PORKCHOP.get(), Items.PORKCHOP, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.BEEF.get(), Items.BEEF, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.MUTTON.get(), Items.MUTTON, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.CHICKEN.get(), Items.CHICKEN, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.EGG.get(), Items.EGG, salAmmoniac, 15);
        this.makeRecipe((Item)SulfurRegistry.INK_SAC.get(), Items.INK_SAC, salAmmoniac, 15);
        this.makeRecipe((Item)SulfurRegistry.GLOW_INK_SAC.get(), Items.GLOW_INK_SAC, salAmmoniac, 15);
        this.makeRecipe((Item)SulfurRegistry.RABBIT.get(), Items.RABBIT, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.RABBIT_HIDE.get(), Items.RABBIT_HIDE, salAmmoniac, 15);
        this.makeRecipe((Item)SulfurRegistry.RABBIT_FOOT.get(), Items.RABBIT_FOOT, salAmmoniac, 20);
        this.makeRecipe((Item)SulfurRegistry.LEATHER.get(), Items.LEATHER, salAmmoniac, 15);
        this.makeRecipe((Item)SulfurRegistry.FEATHER.get(), Items.FEATHER, salAmmoniac, 15);
        this.makeRecipe((Item)SulfurRegistry.WOOL.get(), (TagKey<Item>)ItemTags.WOOL, salAmmoniac, 15);
        this.makeRecipe((Item)SulfurRegistry.COD.get(), Items.COD, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.SALMON.get(), Items.SALMON, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.TROPICAL_FISH.get(), Items.TROPICAL_FISH, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.PUFFERFISH.get(), Items.PUFFERFISH, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.TURTLE_SCUTE.get(), Items.TURTLE_SCUTE, salAmmoniac, 20);
        this.makeRecipe((Item)SulfurRegistry.ARMADILLO_SCUTE.get(), Items.ARMADILLO_SCUTE, salAmmoniac, 15);
        this.makeRecipe((Item)SulfurRegistry.DIRT.get(), Items.DIRT, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.COARSE_DIRT.get(), Items.COARSE_DIRT, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.PODZOL.get(), Items.PODZOL, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.GRASS_BLOCK.get(), Items.GRASS_BLOCK, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.ROOTED_DIRT.get(), Items.ROOTED_DIRT, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.MOSS_BLOCK.get(), Items.MOSS_BLOCK, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.MUD.get(), Items.MUD, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.MUDDY_MANGROVE_ROOTS.get(), Items.MUDDY_MANGROVE_ROOTS, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.SAND.get(), (TagKey<Item>)Tags.Items.SANDS_COLORLESS, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.RED_SAND.get(), (TagKey<Item>)Tags.Items.SANDS_RED, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.GRAVEL.get(), Items.GRAVEL, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.NETHERRACK.get(), (TagKey<Item>)Tags.Items.NETHERRACKS, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.SOUL_SAND.get(), Items.SOUL_SAND, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.SOUL_SOIL.get(), Items.SOUL_SOIL, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.STONE.get(), Items.STONE, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.INFESTED_STONE.get(), Items.INFESTED_STONE, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.COBBLESTONE.get(), (TagKey<Item>)Tags.Items.COBBLESTONES_NORMAL, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.COBBLESTONE_MOSSY.get(), (TagKey<Item>)Tags.Items.COBBLESTONES_INFESTED, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.COBBLESTONES_INFESTED.get(), (TagKey<Item>)Tags.Items.COBBLESTONES_MOSSY, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.DEEPSLATE.get(), Items.DEEPSLATE, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.COBBLESTONE_DEEPSLATE.get(), (TagKey<Item>)Tags.Items.COBBLESTONES_DEEPSLATE, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.GRANITE.get(), Items.GRANITE, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.DIORITE.get(), Items.DIORITE, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.ANDESITE.get(), Items.ANDESITE, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.BLACKSTONE.get(), Items.BLACKSTONE, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.BASALT.get(), Items.BASALT, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.SANDSTONE.get(), Items.SANDSTONE, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.RED_SANDSTONE.get(), Items.RED_SANDSTONE, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.CLAY.get(), Items.CLAY_BALL, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.TERRACOTTA.get(), (TagKey<Item>)ItemTags.TERRACOTTA, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.CRIMSON_NYLIUM.get(), Items.CRIMSON_NYLIUM, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.WARPED_NYLIUM.get(), Items.WARPED_NYLIUM, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.END_STONE.get(), (TagKey<Item>)Tags.Items.END_STONES, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.PURPUR_BLOCK.get(), Items.PURPUR_BLOCK, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.MYCELIUM.get(), Items.MYCELIUM, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.OBSIDIAN.get(), Items.OBSIDIAN, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.CRYING_OBSIDIAN.get(), Items.CRYING_OBSIDIAN, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.SNOW.get(), Items.SNOW, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.ICE.get(), Items.ICE, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.ICE.get(), 9, Items.PACKED_ICE, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.ICE.get(), 64, Items.BLUE_ICE, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.MAGMA.get(), 1, Items.MAGMA_BLOCK, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.WATER.get(), 1, (Item)ItemRegistry.CRYSTALLIZED_WATER.get(), salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.LAVA.get(), 1, (Item)ItemRegistry.CRYSTALLIZED_LAVA.get(), salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.IRON.get(), 5, (TagKey<Item>)Tags.Items.ORES_IRON, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.COPPER.get(), 5, (TagKey<Item>)Tags.Items.ORES_COPPER, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.GOLD.get(), 5, (TagKey<Item>)Tags.Items.ORES_GOLD, salAmmoniac, 15);
        this.makeRecipe((Item)SulfurRegistry.NETHERITE.get(), 1, (TagKey<Item>)Tags.Items.ORES_NETHERITE_SCRAP, salAmmoniac, 100);
        this.makeRecipe((Item)SulfurRegistry.URANIUM.get(), 5, ItemTagRegistry.ORES_URANIUM, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.URANINITE.get(), 5, ItemTagRegistry.ORES_URANINITE_POOR, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.URANINITE.get(), 7, ItemTagRegistry.ORES_URANINITE_REGULAR, salAmmoniac, 15);
        this.makeRecipe((Item)SulfurRegistry.URANINITE.get(), 13, ItemTagRegistry.ORES_URANINITE_DENSE, salAmmoniac, 20);
        this.makeRecipe((Item)SulfurRegistry.SILVER.get(), 5, ItemTagRegistry.ORES_SILVER, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.AZURE_SILVER.get(), 5, ItemTagRegistry.ORES_AZURE_SILVER, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.ZINC.get(), 5, ItemTagRegistry.ORES_ZINC, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.OSMIUM.get(), 5, ItemTagRegistry.ORES_OSMIUM, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.NICKEL.get(), 5, ItemTagRegistry.ORES_NICKEL, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.LEAD.get(), 5, ItemTagRegistry.ORES_LEAD, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.ALLTHEMODIUM.get(), 5, ItemTagRegistry.ORES_ALLTHEMODIUM, salAmmoniac, 100);
        this.makeRecipe((Item)SulfurRegistry.UNOBTAINIUM.get(), 5, ItemTagRegistry.ORES_UNOBTAINIUM, salAmmoniac, 100);
        this.makeRecipe((Item)SulfurRegistry.IRIDIUM.get(), 5, ItemTagRegistry.ORES_IRIDIUM, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.TIN.get(), 5, ItemTagRegistry.ORES_TIN, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.ALUMINUM.get(), 5, ItemTagRegistry.ORES_ALUMINUM, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.CINNABAR.get(), 5, ItemTagRegistry.ORES_CINNABAR, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.CRIMSON_IRON.get(), 5, ItemTagRegistry.ORES_CRIMSON_IRON, salAmmoniac, 20);
        this.makeRecipe((Item)SulfurRegistry.PLATINUM.get(), 5, ItemTagRegistry.ORES_PLATINUM, salAmmoniac, 20);
        this.makeRecipe((Item)SulfurRegistry.VIBRANIUM.get(), 5, ItemTagRegistry.ORES_VIBRANIUM, salAmmoniac, 20);
        this.makeRecipe((Item)SulfurRegistry.DESH.get(), 5, ItemTagRegistry.ORES_DESH, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.OSTRUM.get(), 5, ItemTagRegistry.ORES_OSTRUM, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.CALORITE.get(), 5, ItemTagRegistry.ORES_CALORITE, salAmmoniac, 50);
        this.makeRecipe((Item)SulfurRegistry.IESNIUM.get(), 5, ItemTagRegistry.ORES_IESNIUM, salAmmoniac, 50);
        this.makeRecipe((Item)SulfurRegistry.DIAMOND.get(), 4, (TagKey<Item>)Tags.Items.ORES_DIAMOND, salAmmoniac, 100);
        this.makeRecipe((Item)SulfurRegistry.EMERALD.get(), 4, (TagKey<Item>)Tags.Items.ORES_EMERALD, salAmmoniac, 100);
        this.makeRecipe((Item)SulfurRegistry.LAPIS.get(), 12, (TagKey<Item>)Tags.Items.ORES_LAPIS, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.QUARTZ.get(), 10, (TagKey<Item>)Tags.Items.ORES_QUARTZ, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.RUBY.get(), 8, ItemTagRegistry.ORES_RUBY, salAmmoniac, 15);
        this.makeRecipe((Item)SulfurRegistry.APATITE.get(), 9, ItemTagRegistry.ORES_APATITE, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.PERIDOT.get(), 8, ItemTagRegistry.ORES_PERIDOT, salAmmoniac, 15);
        this.makeRecipe((Item)SulfurRegistry.FLUORITE.get(), 8, ItemTagRegistry.ORES_FLUORITE, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.SAPPHIRE.get(), 8, ItemTagRegistry.ORES_SAPPHIRE, salAmmoniac, 15);
        this.makeRecipe((Item)SulfurRegistry.DARK_GEM.get(), 6, ItemTagRegistry.ORES_DARK_GEM, salAmmoniac, 15);
        this.makeRecipe((Item)SulfurRegistry.SAL_AMMONIAC.get(), 6, ItemTagRegistry.ORES_SAL_AMMONIAC, salAmmoniac, 15);
        this.makeRecipe((Item)SulfurRegistry.CERTUS_QUARTZ.get(), 6, ItemTagRegistry.ORES_CERTUS_QUARTZ, salAmmoniac, 15);
        this.makeRecipe((Item)SulfurRegistry.NITER.get(), 6, ItemTagRegistry.ORES_NITER, salAmmoniac, 15);
        this.makeRecipe((Item)SulfurRegistry.REDSTONE.get(), 9, (TagKey<Item>)Tags.Items.ORES_REDSTONE, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.COAL.get(), 4, Items.COAL_ORE, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.COAL.get(), 4, Items.DEEPSLATE_COAL_ORE, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.SULFUR.get(), 6, ItemTagRegistry.ORES_SULFUR, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.BAUXITE.get(), 1, ItemTagRegistry.ORES_BAUXITE, salAmmoniac, 15);
        this.makeRecipe((Item)SulfurRegistry.MONAZITE.get(), 1, ItemTagRegistry.ORES_MONAZITE, salAmmoniac, 20);
        this.makeRecipe((Item)SulfurRegistry.IRON.get(), 3, (TagKey<Item>)Tags.Items.RAW_MATERIALS_IRON, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.COPPER.get(), 3, (TagKey<Item>)Tags.Items.RAW_MATERIALS_COPPER, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.GOLD.get(), 3, (TagKey<Item>)Tags.Items.RAW_MATERIALS_GOLD, salAmmoniac, 15);
        this.makeRecipe((Item)SulfurRegistry.URANIUM.get(), 3, ItemTagRegistry.RAW_MATERIALS_URANIUM, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.URANINITE.get(), 3, ItemTagRegistry.RAW_MATERIALS_URANINITE, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.AZURE_SILVER.get(), 3, ItemTagRegistry.RAW_MATERIALS_AZURE_SILVER, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.SILVER.get(), 3, ItemTagRegistry.RAW_MATERIALS_SILVER, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.ZINC.get(), 3, ItemTagRegistry.RAW_MATERIALS_ZINC, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.OSMIUM.get(), 3, ItemTagRegistry.RAW_MATERIALS_OSMIUM, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.NICKEL.get(), 3, ItemTagRegistry.RAW_MATERIALS_NICKEL, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.LEAD.get(), 3, ItemTagRegistry.RAW_MATERIALS_LEAD, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.ALLTHEMODIUM.get(), 3, ItemTagRegistry.RAW_MATERIALS_ALLTHEMODIUM, salAmmoniac, 100);
        this.makeRecipe((Item)SulfurRegistry.UNOBTAINIUM.get(), 3, ItemTagRegistry.RAW_MATERIALS_UNOBTAINIUM, salAmmoniac, 100);
        this.makeRecipe((Item)SulfurRegistry.IRIDIUM.get(), 3, ItemTagRegistry.RAW_MATERIALS_IRIDIUM, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.TIN.get(), 3, ItemTagRegistry.RAW_MATERIALS_TIN, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.ALUMINUM.get(), 3, ItemTagRegistry.RAW_MATERIALS_ALUMINUM, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.CINNABAR.get(), 3, ItemTagRegistry.RAW_MATERIALS_CINNABAR, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.CRIMSON_IRON.get(), 3, ItemTagRegistry.RAW_MATERIALS_CRIMSON_IRON, salAmmoniac, 20);
        this.makeRecipe((Item)SulfurRegistry.PLATINUM.get(), 3, ItemTagRegistry.RAW_MATERIALS_PLATINUM, salAmmoniac, 20);
        this.makeRecipe((Item)SulfurRegistry.VIBRANIUM.get(), 3, ItemTagRegistry.RAW_MATERIALS_VIBRANIUM, salAmmoniac, 20);
        this.makeRecipe((Item)SulfurRegistry.DESH.get(), 5, ItemTagRegistry.RAW_MATERIALS_DESH, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.OSTRUM.get(), 5, ItemTagRegistry.RAW_MATERIALS_OSTRUM, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.CALORITE.get(), 5, ItemTagRegistry.RAW_MATERIALS_CALORITE, salAmmoniac, 50);
        this.makeRecipe((Item)SulfurRegistry.IESNIUM.get(), 5, ItemTagRegistry.RAW_MATERIALS_IESNIUM, salAmmoniac, 50);
        this.makeRecipe((Item)SulfurRegistry.DEMONITE.get(), 3, ItemTagRegistry.RAW_MATERIALS_DEMONITE, salAmmoniac, 50);
        this.makeRecipe((Item)SulfurRegistry.IRON.get(), 1, (TagKey<Item>)Tags.Items.INGOTS_IRON, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.COPPER.get(), 1, (TagKey<Item>)Tags.Items.INGOTS_COPPER, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.GOLD.get(), 1, (TagKey<Item>)Tags.Items.INGOTS_GOLD, salAmmoniac, 15);
        this.makeRecipe((Item)SulfurRegistry.NETHERITE.get(), 1, (TagKey<Item>)Tags.Items.INGOTS_NETHERITE, salAmmoniac, 100);
        this.makeRecipe((Item)SulfurRegistry.URANIUM.get(), 1, ItemTagRegistry.INGOTS_URANIUM, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.URANINITE.get(), 1, ItemTagRegistry.INGOTS_URANINITE, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.SILVER.get(), 1, ItemTagRegistry.INGOTS_SILVER, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.AZURE_SILVER.get(), 1, ItemTagRegistry.INGOTS_AZURE_SILVER, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.ZINC.get(), 1, ItemTagRegistry.INGOTS_ZINC, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.OSMIUM.get(), 1, ItemTagRegistry.INGOTS_OSMIUM, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.NICKEL.get(), 1, ItemTagRegistry.INGOTS_NICKEL, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.LEAD.get(), 1, ItemTagRegistry.INGOTS_LEAD, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.ALLTHEMODIUM.get(), 1, ItemTagRegistry.INGOTS_ALLTHEMODIUM, salAmmoniac, 100);
        this.makeRecipe((Item)SulfurRegistry.UNOBTAINIUM.get(), 1, ItemTagRegistry.INGOTS_UNOBTAINIUM, salAmmoniac, 100);
        this.makeRecipe((Item)SulfurRegistry.IRIDIUM.get(), 1, ItemTagRegistry.INGOTS_IRIDIUM, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.TIN.get(), 1, ItemTagRegistry.INGOTS_TIN, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.ALUMINUM.get(), 1, ItemTagRegistry.INGOTS_ALUMINUM, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.CINNABAR.get(), 1, ItemTagRegistry.INGOTS_CINNABAR, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.CRIMSON_IRON.get(), 1, ItemTagRegistry.INGOTS_CRIMSON_IRON, salAmmoniac, 20);
        this.makeRecipe((Item)SulfurRegistry.PLATINUM.get(), 1, ItemTagRegistry.INGOTS_PLATINUM, salAmmoniac, 20);
        this.makeRecipe((Item)SulfurRegistry.VIBRANIUM.get(), 1, ItemTagRegistry.INGOTS_VIBRANIUM, salAmmoniac, 20);
        this.makeRecipe((Item)SulfurRegistry.DESH.get(), 1, ItemTagRegistry.INGOTS_DESH, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.OSTRUM.get(), 1, ItemTagRegistry.INGOTS_OSTRUM, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.CALORITE.get(), 1, ItemTagRegistry.INGOTS_CALORITE, salAmmoniac, 50);
        this.makeRecipe((Item)SulfurRegistry.IESNIUM.get(), 1, ItemTagRegistry.INGOTS_IESNIUM, salAmmoniac, 50);
        this.makeRecipe((Item)SulfurRegistry.DEMONITE.get(), 1, ItemTagRegistry.INGOTS_DEMONITE, salAmmoniac, 50);
        this.makeRecipe((Item)SulfurRegistry.DIAMOND.get(), 1, (TagKey<Item>)Tags.Items.GEMS_DIAMOND, salAmmoniac, 100);
        this.makeRecipe((Item)SulfurRegistry.EMERALD.get(), 1, (TagKey<Item>)Tags.Items.GEMS_EMERALD, salAmmoniac, 100);
        this.makeRecipe((Item)SulfurRegistry.LAPIS.get(), 1, (TagKey<Item>)Tags.Items.GEMS_LAPIS, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.QUARTZ.get(), 1, (TagKey<Item>)Tags.Items.GEMS_QUARTZ, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.AMETHYST.get(), 1, (TagKey<Item>)Tags.Items.GEMS_AMETHYST, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.PRISMARINE.get(), 1, (TagKey<Item>)Tags.Items.GEMS_PRISMARINE, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.RUBY.get(), 1, ItemTagRegistry.GEMS_RUBY, salAmmoniac, 15);
        this.makeRecipe((Item)SulfurRegistry.APATITE.get(), 1, ItemTagRegistry.GEMS_APATITE, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.PERIDOT.get(), 1, ItemTagRegistry.GEMS_PERIDOT, salAmmoniac, 15);
        this.makeRecipe((Item)SulfurRegistry.FLUORITE.get(), 1, ItemTagRegistry.GEMS_FLUORITE, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.SAPPHIRE.get(), 1, ItemTagRegistry.GEMS_SAPPHIRE, salAmmoniac, 15);
        this.makeRecipe((Item)SulfurRegistry.DARK_GEM.get(), 1, ItemTagRegistry.GEMS_DARK, salAmmoniac, 15);
        this.makeRecipe((Item)SulfurRegistry.SAL_AMMONIAC.get(), 1, ItemTagRegistry.GEMS_SAL_AMMONIAC, salAmmoniac, 15);
        this.makeRecipe((Item)SulfurRegistry.CERTUS_QUARTZ.get(), 1, ItemTagRegistry.GEMS_CERTUS_QUARTZ, salAmmoniac, 15);
        this.makeRecipe((Item)SulfurRegistry.FLUIX.get(), 1, ItemTagRegistry.GEMS_FLUIX, salAmmoniac, 15);
        this.makeRecipe((Item)SulfurRegistry.NITER.get(), 1, ItemTagRegistry.GEMS_NITER, salAmmoniac, 15);
        this.makeRecipe((Item)SulfurRegistry.CHIMERITE.get(), 1, ItemTagRegistry.GEMS_CHIMERITE, salAmmoniac, 100);
        this.makeRecipe((Item)SulfurRegistry.REDSTONE.get(), 1, (TagKey<Item>)Tags.Items.DUSTS_REDSTONE, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.COAL.get(), 1, Items.COAL, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.COAL.get(), 1, Items.CHARCOAL, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.SULFUR.get(), 1, ItemTagRegistry.GEMS_SULFUR, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.GLOWSTONE.get(), 1, (TagKey<Item>)Tags.Items.DUSTS_GLOWSTONE, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.LIGNITE_COAL.get(), 1, ItemTagRegistry.GEMS_LIGNITE_COAL, salAmmoniac, 10);
        this.makeRecipe((Item)SulfurRegistry.MONAZITE.get(), 1, ItemTagRegistry.DUSTS_MONAZITE, salAmmoniac, 20);
        this.makeRecipe((Item)SulfurRegistry.BAUXITE.get(), 1, ItemTagRegistry.DUSTS_BAUXITE, salAmmoniac, 15);
    }

    public void makeRecipe(Item sulfurName, Item ingredient, Fluid solvent, int solventAmount) {
        this.makeRecipe(sulfurName, 1, ingredient, solvent, solventAmount, 100);
    }

    public void makeRecipe(Item sulfur, Item ingredient, Fluid solvent, int solventAmount, int liquefactionTime) {
        this.makeRecipe(sulfur, 1, ingredient, solvent, solventAmount, liquefactionTime);
    }

    public void makeRecipe(Item sulfur, int resultCount, Item ingredient, Fluid solvent, int solventAmount) {
        this.makeRecipe(sulfur, resultCount, ingredient, solvent, solventAmount, 100);
    }

    public void makeRecipe(Item sulfur, int resultCount, Item ingredient, Fluid solvent, int solventAmount, int liquefactionTime) {
        String name = this.name((ItemLike)sulfur) + "_from_" + this.name((ItemLike)ingredient);
        JsonObject recipe = ((Builder)((Builder)new Builder(RecipeResult.of(new ItemStack((ItemLike)sulfur, resultCount))).solvent(solvent, solventAmount).ingredient((ItemLike)ingredient)).time(liquefactionTime)).build();
        this.recipeConsumer.accept(this.modLoc(name), recipe);
    }

    public void makeRecipe(Item sulfurName, TagKey<Item> ingredient, Fluid solvent, int solventAmount) {
        this.makeRecipe(sulfurName, 1, ingredient, solvent, solventAmount, 100);
    }

    public void makeRecipe(Item sulfurName, TagKey<Item> ingredient, Fluid solvent, int solventAmount, int liquefactionTime) {
        this.makeRecipe(sulfurName, 1, ingredient, solvent, solventAmount, liquefactionTime);
    }

    public void makeRecipe(Item sulfur, int resultCount, TagKey<Item> ingredient, Fluid solvent, int solventAmount) {
        this.makeRecipe(sulfur, resultCount, ingredient, solvent, solventAmount, 100);
    }

    public void makeRecipe(Item sulfur, int resultCount, TagKey<Item> ingredient, Fluid solvent, int solventAmount, int liquefactionTime) {
        String name = this.name((ItemLike)sulfur) + "_from_" + this.name(ingredient);
        JsonObject recipe = ((Builder)((Builder)new Builder(RecipeResult.of(new ItemStack((ItemLike)sulfur, resultCount))).solvent(solvent, solventAmount).ingredient(ingredient)).time(liquefactionTime)).build();
        this.recipeConsumer.accept(this.modLoc(name), recipe);
    }

    public String getName() {
        return "Liquefaction Recipes";
    }

    protected static class Builder
    extends JsonRecipeProvider.RecipeBuilder<Builder> {
        protected Builder(RecipeResult result) {
            super((Holder<RecipeType<?>>)RecipeTypeRegistry.LIQUEFACTION);
            this.result(result);
            this.time(100);
        }

        public Builder solvent(Fluid fluid, int amount) {
            return (Builder)this.sizedFluidIngredient("solvent", fluid, amount);
        }
    }
}

