/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.datagen.book.logistics;

import com.klikli_dev.modonomicon.api.datagen.CategoryProvider;
import com.klikli_dev.modonomicon.api.datagen.CategoryProviderBase;
import com.klikli_dev.modonomicon.api.datagen.EntryBackground;
import com.klikli_dev.modonomicon.api.datagen.EntryProvider;
import com.klikli_dev.modonomicon.api.datagen.book.BookIconModel;
import com.klikli_dev.modonomicon.api.datagen.book.page.BookTextPageModel;
import com.klikli_dev.theurgy.registry.ItemRegistry;
import com.mojang.datafixers.util.Pair;
import net.minecraft.world.level.ItemLike;

public class FrequencyEntry
extends EntryProvider {
    public static final String ENTRY_ID = "frequency";

    public FrequencyEntry(CategoryProvider parent) {
        super((CategoryProviderBase)parent);
    }

    protected void generatePages() {
        this.page("intro", () -> BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText()));
        this.pageTitle("Node Frequency");
        this.pageText("Leaf Nodes in the same network, such as inserter and extractor nodes, by default are all connected. Every extractor will attempt to insert into every inserter.\n\\\n\\\nThis can be counteracted using filters, but sometimes it is desirable to have multiple *logical* sub-networks without having to physically separate them. This is where node frequencies come in.\n");
        this.page("subnetworks", () -> BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText()));
        this.pageTitle("Sub-Networks");
        this.pageText("By setting the frequency on an inserter or extractor, it will only interact with other nodes that have the same frequency.\n\\\n\\\nThis means, you could theoretically connect all the blocks in your base into a single network, but by using different frequencies you can decide which blocks actually interact with each other.\n");
        this.page("select", () -> BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText()));
        this.pageTitle("Select a Frequency");
        this.pageText("First, you need to select a frequency in your {0}.\n1. Equip your {0}.\n2. Sneak+Scroll until you are in the \"Select Frequency\" mode.\n3. Right and Left click to increase/decrease the selected frequency.\n", new Object[]{this.itemLink((ItemLike)ItemRegistry.MERCURIAL_WAND.get())});
        this.page("set", () -> BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText()));
        this.pageTitle("Set a Frequency");
        this.pageText("Then you can apply the frequency to a leaf node.\n1. Equip your {0}.\n2. Right-Click an inserter or extractor to set its frequency.\n3. Repeat for all blocks that should be in the same sub-network.\n4. Right-Click any of the blocks with an empty hand to show all the blocks in the same sub-network.\n", new Object[]{this.itemLink((ItemLike)ItemRegistry.MERCURIAL_WAND.get())});
    }

    protected String entryName() {
        return "Node Frequency";
    }

    protected String entryDescription() {
        return "Creating sub-networks by setting node frequencies";
    }

    protected Pair<Integer, Integer> entryBackground() {
        return EntryBackground.DEFAULT;
    }

    protected BookIconModel entryIcon() {
        return BookIconModel.create((ItemLike)((ItemLike)ItemRegistry.MERCURIAL_WAND.get()));
    }

    protected String entryId() {
        return ENTRY_ID;
    }
}

