/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.datagen.book.gettingstarted.reformation;

import com.klikli_dev.modonomicon.api.datagen.CategoryProvider;
import com.klikli_dev.modonomicon.api.datagen.CategoryProviderBase;
import com.klikli_dev.modonomicon.api.datagen.EntryBackground;
import com.klikli_dev.modonomicon.api.datagen.EntryProvider;
import com.klikli_dev.modonomicon.api.datagen.book.BookIconModel;
import com.klikli_dev.modonomicon.api.datagen.book.page.BookTextPageModel;
import com.klikli_dev.theurgy.registry.ItemRegistry;
import com.mojang.datafixers.util.Pair;
import net.minecraft.world.level.ItemLike;

public class SulfuricFluxEmitterEntry
extends EntryProvider {
    public static final String ENTRY_ID = "sulfuric_flux_emitter";

    public SulfuricFluxEmitterEntry(CategoryProvider parent) {
        super((CategoryProviderBase)parent);
    }

    protected void generatePages() {
        this.page("target", () -> BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText()));
        this.add(this.context().pageTitle(), "Supplying Sulfuric Flux");
        this.add(this.context().pageText(), "Make sure the Sulfuric Flux Emitter is supplied with mercury flux, e.g. from a Mercury Catalyst.\\\nThe replication process will start automatically, once a target and sufficient source sulfur are present in the pedestals, and enough mercury flux is supplied to the emitter.\n");
        this.page("visuals", () -> BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText()));
        this.add(this.context().pageTitle(), "Visuals");
        this.add(this.context().pageText(), "If the process is working you will see particles fly from the emitter to the pedestals.\n\\\n\\\nFurther, you should see glowing orbs above the target and source pedestals, indicating that sulfur is present.\n");
        this.page("problems", () -> BookTextPageModel.create().withTitle(this.context().pageTitle()).withText(this.context().pageText()));
        this.add(this.context().pageTitle(), "Problem Resolution");
        this.add(this.context().pageText(), "If that is not the case, double check the recipe in JEI, and visit {0} to review your knowledge of the reformation array setup.\n", new Object[]{this.entryLink("Reformation Array", "apparatus", "reformation_array")});
    }

    protected String entryName() {
        return "Supplying Sulfuric Mercury Flux";
    }

    protected String entryDescription() {
        return "Starting the Replication Process";
    }

    protected Pair<Integer, Integer> entryBackground() {
        return EntryBackground.DEFAULT;
    }

    protected BookIconModel entryIcon() {
        return BookIconModel.create((ItemLike)((ItemLike)ItemRegistry.SULFURIC_FLUX_EMITTER.get()));
    }

    protected String entryId() {
        return ENTRY_ID;
    }
}

