/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.datagen.book;

import com.klikli_dev.modonomicon.api.datagen.CategoryProvider;
import com.klikli_dev.modonomicon.api.datagen.ModonomiconProviderBase;
import com.klikli_dev.modonomicon.api.datagen.book.BookCategoryModel;
import com.klikli_dev.modonomicon.api.datagen.book.BookEntryModel;
import com.klikli_dev.modonomicon.api.datagen.book.BookIconModel;
import com.klikli_dev.modonomicon.api.datagen.book.condition.BookConditionModel;
import com.klikli_dev.modonomicon.api.datagen.book.condition.BookTrueConditionModel;
import com.klikli_dev.theurgy.Theurgy;
import com.klikli_dev.theurgy.datagen.book.TheurgyBookProvider;
import com.klikli_dev.theurgy.datagen.book.apparatus.HowToEntry;
import com.klikli_dev.theurgy.datagen.book.apparatus.IntroEntry;
import com.klikli_dev.theurgy.datagen.book.apparatus.mercuryflux.CaloricFluxEmitterEntry;
import com.klikli_dev.theurgy.datagen.book.apparatus.mercuryflux.MercuryCatalystEntry;
import com.klikli_dev.theurgy.datagen.book.apparatus.mercuryflux.MercuryFluxEntry;
import com.klikli_dev.theurgy.datagen.book.apparatus.mercuryflux.SulfuricFluxEmitterEntry;
import com.klikli_dev.theurgy.datagen.book.apparatus.reformation.ReformationArrayEntry;
import com.klikli_dev.theurgy.datagen.book.apparatus.reformation.ResultPedestalEntry;
import com.klikli_dev.theurgy.datagen.book.apparatus.reformation.SourcePedestalEntry;
import com.klikli_dev.theurgy.datagen.book.apparatus.reformation.SulfuricFluxEmitterReferenceEntry;
import com.klikli_dev.theurgy.datagen.book.apparatus.reformation.TargetPedestalEntry;
import com.klikli_dev.theurgy.datagen.book.apparatus.spagyrics.CalcinationOvenEntry;
import com.klikli_dev.theurgy.datagen.book.apparatus.spagyrics.DistillerEntry;
import com.klikli_dev.theurgy.datagen.book.apparatus.spagyrics.IncubatorEntry;
import com.klikli_dev.theurgy.datagen.book.apparatus.spagyrics.LiquefactionCauldronEntry;
import com.klikli_dev.theurgy.datagen.book.apparatus.spagyrics.PyromanticBrazierEntry;
import com.klikli_dev.theurgy.datagen.book.apparatus.spagyrics.SalAmmoniacAccumulatorEntry;
import com.klikli_dev.theurgy.datagen.book.apparatus.spagyrics.SalAmmoniacTankEntry;
import com.klikli_dev.theurgy.datagen.book.apparatus.spagyrics.SpagyricsEntry;
import com.klikli_dev.theurgy.datagen.book.apparatus.transmutationandexaltation.BasicVatAutomationEntry;
import com.klikli_dev.theurgy.datagen.book.apparatus.transmutationandexaltation.DigestionVatEntry;
import com.klikli_dev.theurgy.datagen.book.apparatus.transmutationandexaltation.FermentationVatEntry;
import com.klikli_dev.theurgy.datagen.book.apparatus.transmutationandexaltation.TransmutationAndExaltationEntry;
import com.klikli_dev.theurgy.datagen.book.apparatus.transmutationandexaltation.VatRedstoneEntry;
import com.klikli_dev.theurgy.registry.ItemRegistry;
import net.minecraft.world.level.ItemLike;

public class ApparatusCategory
extends CategoryProvider {
    public static final String CATEGORY_ID = "apparatus";

    public ApparatusCategory(TheurgyBookProvider parent) {
        super((ModonomiconProviderBase)parent);
    }

    protected String[] generateEntryMap() {
        return new String[]{"______________a_\u00ef_\u010d___\u021b___________", "__________________________________", "______________t_\u00e7_d_\u0282_r_\u0155_________", "__________________________________", "____________\u0107_l___b_____\u015f_________", "__________________________________", "__________m_\u00ec___i_________________", "__________________________________", "____________\u0219___h_________________", "__________________________________", "____________________f_\u00e9_\u010f_________", "__________________________________", "______________________\u1e5f___________", "_________________________________", "______________________\u1e5b___________"};
    }

    protected void generateEntries() {
        BookEntryModel introEntry = new IntroEntry(this).generate('i');
        BookEntryModel howToEntry = new HowToEntry(this).generate('h');
        howToEntry.addParent(this.parent(introEntry));
        this.spagyricsEntries(introEntry);
        this.mercuryFluxEntries(introEntry);
        this.reformationEntries(introEntry);
        this.exaltationEntries(introEntry);
    }

    protected String categoryName() {
        return "About Apparatus";
    }

    protected BookIconModel categoryIcon() {
        return BookIconModel.create((ItemLike)((ItemLike)ItemRegistry.CALCINATION_OVEN.get()));
    }

    public String categoryId() {
        return CATEGORY_ID;
    }

    protected BookCategoryModel additionalSetup(BookCategoryModel category) {
        return super.additionalSetup(category).withBackground(Theurgy.loc("textures/gui/book/bg_nightsky2.png"));
    }

    private void exaltationEntries(BookEntryModel parent) {
        BookEntryModel transmutationAndExaltation = new TransmutationAndExaltationEntry(this).generate('\u00e9');
        transmutationAndExaltation.addParent(this.parent(parent));
        transmutationAndExaltation.withCondition((BookConditionModel)BookTrueConditionModel.create());
        BookEntryModel fermentationVatEntry = new FermentationVatEntry(this).generate('f');
        fermentationVatEntry.addParent(this.parent(transmutationAndExaltation));
        BookEntryModel digestionVatEntry = new DigestionVatEntry(this).generate('\u010f');
        digestionVatEntry.addParent(this.parent(transmutationAndExaltation));
        BookEntryModel vatRedstoneEntry = new VatRedstoneEntry(this).generate('\u1e5f');
        vatRedstoneEntry.addParent(this.parent(digestionVatEntry).withLineReversed(true));
        vatRedstoneEntry.addParent(this.parent(fermentationVatEntry).withLineReversed(true));
        vatRedstoneEntry.withCondition((BookConditionModel)this.condition().or(new BookConditionModel[]{this.condition().entryRead(digestionVatEntry), this.condition().entryRead(fermentationVatEntry)}));
        BookEntryModel basicVatAutomationEntry = new BasicVatAutomationEntry(this).generate('\u1e5b');
        basicVatAutomationEntry.addParent(this.parent(vatRedstoneEntry));
    }

    private void reformationEntries(BookEntryModel parent) {
        BookEntryModel reformationArrayEntry = new ReformationArrayEntry(this).generate('r');
        reformationArrayEntry.addParent(this.parent(parent));
        reformationArrayEntry.withCondition((BookConditionModel)BookTrueConditionModel.create());
        BookEntryModel sulfuricFluxEmitterEntry = new SulfuricFluxEmitterReferenceEntry(this).generate('\u015f');
        sulfuricFluxEmitterEntry.addParent(this.parent(reformationArrayEntry));
        BookEntryModel targetPedestalEntry = new TargetPedestalEntry(this).generate('\u021b');
        targetPedestalEntry.addParent(this.parent(reformationArrayEntry));
        BookEntryModel sourcePedestalEntry = new SourcePedestalEntry(this).generate('\u0282');
        sourcePedestalEntry.addParent(this.parent(reformationArrayEntry));
        BookEntryModel resultPedestalEntry = new ResultPedestalEntry(this).generate('\u0155');
        resultPedestalEntry.addParent(this.parent(reformationArrayEntry));
    }

    private void mercuryFluxEntries(BookEntryModel parent) {
        BookEntryModel mercuryFluxEntry = new MercuryFluxEntry(this).generate('\u00ec');
        mercuryFluxEntry.addParent(this.parent(parent));
        mercuryFluxEntry.withCondition((BookConditionModel)BookTrueConditionModel.create());
        BookEntryModel mercuryCatalystEntry = new MercuryCatalystEntry(this).generate('m');
        mercuryCatalystEntry.addParent(this.parent(mercuryFluxEntry));
        BookEntryModel caloricFluxEmitterEntry = new CaloricFluxEmitterEntry(this).generate('\u0107');
        caloricFluxEmitterEntry.addParent(this.parent(mercuryFluxEntry));
        BookEntryModel sulfuricFluxEmitterEntry = new SulfuricFluxEmitterEntry(this).generate('\u0219');
        sulfuricFluxEmitterEntry.addParent(this.parent(mercuryFluxEntry));
    }

    private void spagyricsEntries(BookEntryModel parent) {
        BookEntryModel spagyricsEntry = new SpagyricsEntry(this).generate('\u00e7');
        spagyricsEntry.addParent(this.parent(parent));
        spagyricsEntry.withCondition((BookConditionModel)BookTrueConditionModel.create());
        BookEntryModel pyromanticBrazierEntry = new PyromanticBrazierEntry(this).generate('b');
        pyromanticBrazierEntry.addParent(this.parent(spagyricsEntry));
        BookEntryModel salAmmoniacTankEntry = new SalAmmoniacTankEntry(this).generate('t');
        salAmmoniacTankEntry.addParent(this.parent(spagyricsEntry));
        BookEntryModel salAmmoniacAccumulatorEntry = new SalAmmoniacAccumulatorEntry(this).generate('a');
        salAmmoniacAccumulatorEntry.addParent(this.parent(salAmmoniacTankEntry));
        BookEntryModel liquefactionCauldronEntry = new LiquefactionCauldronEntry(this).generate('l');
        liquefactionCauldronEntry.addParent(this.parent(spagyricsEntry));
        BookEntryModel calcinationOvenEntry = new CalcinationOvenEntry(this).generate('\u010d');
        calcinationOvenEntry.addParent(this.parent(spagyricsEntry));
        BookEntryModel distillerEntry = new DistillerEntry(this).generate('d');
        distillerEntry.addParent(this.parent(spagyricsEntry));
        BookEntryModel incubatorEntry = new IncubatorEntry(this).generate('\u00ef');
        incubatorEntry.addParent(this.parent(spagyricsEntry));
    }
}

