/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.content.item.filter;

import com.klikli_dev.theurgy.content.behaviour.filter.FilterMode;
import com.klikli_dev.theurgy.content.behaviour.filter.attribute.ItemAttribute;
import com.klikli_dev.theurgy.content.gui.GuiIcons;
import com.klikli_dev.theurgy.content.gui.GuiTextures;
import com.klikli_dev.theurgy.content.gui.IconButton;
import com.klikli_dev.theurgy.content.gui.Indicator;
import com.klikli_dev.theurgy.content.gui.Label;
import com.klikli_dev.theurgy.content.gui.SelectionScrollInput;
import com.klikli_dev.theurgy.content.item.filter.AbstractFilterScreen;
import com.klikli_dev.theurgy.content.item.filter.AttributeFilterMenu;
import com.klikli_dev.theurgy.network.Networking;
import com.klikli_dev.theurgy.network.messages.MessageSetListFilterScreenOption;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class AttributeFilterScreen
extends AbstractFilterScreen<AttributeFilterMenu> {
    private static final Component ADD_REFERENCE_ITEM = Component.translatable((String)"theurgy.gui.attribute_filter.add_reference_item");
    private static final Component NO_SELECTED_ATTRIBUTES = Component.translatable((String)"theurgy.gui.attribute_filter.no_selected_attributes");
    private static final Component SELECTED_ATTRIBUTES = Component.translatable((String)"theurgy.gui.attribute_filter.selected_attributes");
    private final List<ItemAttribute> attributesOfItem = new ArrayList<ItemAttribute>();
    private final List<Component> selectedAttributes = new ArrayList<Component>();
    protected IconButton acceptListOrButton;
    protected IconButton acceptListAndButton;
    protected IconButton denyListButton;
    protected Indicator acceptListOrIndicator;
    protected Indicator acceptListAndIndicator;
    protected Indicator denyListIndicator;
    protected IconButton addButton;
    protected IconButton addInvertedButton;
    protected SelectionScrollInput attributeSelector;
    protected Label attributeSelectorLabel;
    private ItemStack lastItemScanned = ItemStack.EMPTY;

    public AttributeFilterScreen(AttributeFilterMenu pMenu, Inventory pPlayerInventory, Component pTitle) {
        super(pMenu, pPlayerInventory, pTitle, GuiTextures.ATTRIBUTE_FILTER);
    }

    @Override
    protected int getScreenTitleColor() {
        return 5841956;
    }

    @Override
    protected boolean isButtonActive(IconButton button) {
        if (button == this.denyListButton) {
            return ((AttributeFilterMenu)this.menu).filterMode != FilterMode.DENY_LIST;
        }
        if (button == this.acceptListOrButton) {
            return ((AttributeFilterMenu)this.menu).filterMode != FilterMode.ACCEPT_LIST_OR;
        }
        if (button == this.acceptListAndButton) {
            return ((AttributeFilterMenu)this.menu).filterMode != FilterMode.ACCEPT_LIST_AND;
        }
        return true;
    }

    @Override
    protected boolean isIndicatorOn(Indicator indicator) {
        if (indicator == this.denyListIndicator) {
            return ((AttributeFilterMenu)this.menu).filterMode == FilterMode.DENY_LIST;
        }
        if (indicator == this.acceptListOrIndicator) {
            return ((AttributeFilterMenu)this.menu).filterMode == FilterMode.ACCEPT_LIST_OR;
        }
        if (indicator == this.acceptListAndIndicator) {
            return ((AttributeFilterMenu)this.menu).filterMode == FilterMode.ACCEPT_LIST_AND;
        }
        return false;
    }

    @Override
    protected List<IconButton> getButtons() {
        return Arrays.asList(this.denyListButton, this.acceptListAndButton, this.acceptListOrButton);
    }

    @Override
    protected List<Indicator> getIndicators() {
        return Arrays.asList(this.denyListIndicator, this.acceptListAndIndicator, this.acceptListOrIndicator);
    }

    @Override
    protected void init() {
        super.init();
        int x = this.leftPos;
        int y = this.topPos;
        this.acceptListOrButton = new IconButton(x + 47, y + 61, GuiIcons.ACCEPT_LIST_OR);
        this.acceptListOrButton.withOnClick(() -> {
            ((AttributeFilterMenu)this.menu).filterMode = FilterMode.ACCEPT_LIST_OR;
            this.sendOptionUpdate(MessageSetListFilterScreenOption.Option.ACCEPT_LIST);
        });
        this.acceptListOrButton.withTooltip("theurgy.gui.attribute_filter.accept_list_or_button.tooltip", "theurgy.gui.attribute_filter.accept_list_or_button.tooltip.shift");
        this.addRenderableWidget((GuiEventListener)this.acceptListOrButton);
        this.acceptListAndButton = new IconButton(x + 65, y + 61, GuiIcons.ACCEPT_LIST_AND);
        this.acceptListAndButton.withOnClick(() -> {
            ((AttributeFilterMenu)this.menu).filterMode = FilterMode.ACCEPT_LIST_AND;
            this.sendOptionUpdate(MessageSetListFilterScreenOption.Option.ACCEPT_LIST2);
        });
        this.acceptListAndButton.withTooltip("theurgy.gui.attribute_filter.accept_list_and_button.tooltip", "theurgy.gui.attribute_filter.accept_list_and_button.tooltip.shift");
        this.addRenderableWidget((GuiEventListener)this.acceptListAndButton);
        this.denyListButton = new IconButton(x + 83, y + 61, GuiIcons.DENY_LIST_ALT);
        this.denyListButton.withOnClick(() -> {
            ((AttributeFilterMenu)this.menu).filterMode = FilterMode.DENY_LIST;
            this.sendOptionUpdate(MessageSetListFilterScreenOption.Option.DENY_LIST);
        });
        this.denyListButton.withTooltip("theurgy.gui.attribute_filter.deny_list_button.tooltip", "theurgy.gui.attribute_filter.deny_list_button.tooltip.shift");
        this.addRenderableWidget((GuiEventListener)this.denyListButton);
        this.acceptListOrIndicator = new Indicator(x + 47, y + 55, (Component)Component.empty());
        this.addRenderableWidget((GuiEventListener)this.acceptListOrIndicator);
        this.acceptListAndIndicator = new Indicator(x + 65, y + 55, (Component)Component.empty());
        this.addRenderableWidget((GuiEventListener)this.acceptListAndIndicator);
        this.denyListIndicator = new Indicator(x + 83, y + 55, (Component)Component.empty());
        this.addRenderableWidget((GuiEventListener)this.denyListIndicator);
        this.addButton = new IconButton(x + 182, y + 23, GuiIcons.ADD);
        this.addButton.withOnClick(() -> this.handleAddedAttibute(false));
        this.addButton.withTooltip("theurgy.gui.attribute_filter.add_button.tooltip");
        this.addRenderableWidget((GuiEventListener)this.addButton);
        this.addInvertedButton = new IconButton(x + 200, y + 23, GuiIcons.ADD_INVERTED);
        this.addInvertedButton.withOnClick(() -> this.handleAddedAttibute(true));
        this.addInvertedButton.withTooltip("theurgy.gui.attribute_filter.add_inverted.tooltip");
        this.addRenderableWidget((GuiEventListener)this.addInvertedButton);
        this.updateIndicatorState();
        this.attributeSelectorLabel = new Label(x + 43, y + 28, (Component)Component.empty()).colored(15985630).withShadow();
        this.addRenderableWidget((GuiEventListener)this.attributeSelectorLabel);
        this.attributeSelector = new SelectionScrollInput(x + 39, y + 23, 137, 18);
        this.attributeSelector.forOptions(List.of(Component.empty()));
        this.attributeSelector.updateTooltip();
        this.attributeSelector.removeCallback();
        this.addRenderableWidget(this.attributeSelector);
        this.referenceItemChanged(((AttributeFilterMenu)this.menu).ghostInventory.getStackInSlot(0));
        this.selectedAttributes.clear();
        this.selectedAttributes.add((Component)(((AttributeFilterMenu)this.menu).selectedAttributes.isEmpty() ? NO_SELECTED_ATTRIBUTES : SELECTED_ATTRIBUTES).plainCopy().withStyle(ChatFormatting.YELLOW));
        ((AttributeFilterMenu)this.menu).selectedAttributes.forEach(at -> this.selectedAttributes.add((Component)Component.literal((String)"- ").append((Component)((ItemAttribute)at.getFirst()).format((Boolean)at.getSecond())).withStyle(ChatFormatting.GRAY)));
    }

    @Override
    public void render(@NotNull GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        super.render(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
        ItemStack stack = ((AttributeFilterMenu)this.menu).ghostInventory.getStackInSlot(1);
        PoseStack matrixStack = pGuiGraphics.pose();
        matrixStack.pushPose();
        matrixStack.translate(0.0f, 0.0f, 150.0f);
        pGuiGraphics.renderItemDecorations(this.font, stack, this.leftPos + 22, this.topPos + 59, String.valueOf(this.selectedAttributes.size() - 1));
        matrixStack.popPose();
    }

    @Override
    protected void containerTick() {
        super.containerTick();
        ItemStack stackInSlot = ((AttributeFilterMenu)this.menu).ghostInventory.getStackInSlot(0);
        if (!ItemStack.isSameItemSameComponents((ItemStack)stackInSlot, (ItemStack)this.lastItemScanned)) {
            this.referenceItemChanged(stackInSlot);
        }
    }

    protected void renderTooltip(@NotNull GuiGraphics graphics, int mouseX, int mouseY) {
        if (((AttributeFilterMenu)this.menu).getCarried().isEmpty() && this.hoveredSlot != null && this.hoveredSlot.hasItem()) {
            if (this.hoveredSlot.index == 37) {
                graphics.renderComponentTooltip(this.font, this.selectedAttributes, mouseX, mouseY);
                return;
            }
            graphics.renderTooltip(this.font, this.hoveredSlot.getItem(), mouseX, mouseY);
        }
        super.renderTooltip(graphics, mouseX, mouseY);
    }

    @Override
    protected void clearContents() {
        this.selectedAttributes.clear();
        this.selectedAttributes.add((Component)NO_SELECTED_ATTRIBUTES.plainCopy().withStyle(ChatFormatting.YELLOW));
        if (!this.lastItemScanned.isEmpty()) {
            this.addButton.active = true;
            this.addInvertedButton.active = true;
        }
    }

    protected void sendOptionUpdate(MessageSetListFilterScreenOption.Option option) {
        Networking.sendToServer(new MessageSetListFilterScreenOption(option));
    }

    protected boolean handleAddedAttibute(boolean inverted) {
        int index = this.attributeSelector.getState();
        if (index >= this.attributesOfItem.size()) {
            return false;
        }
        this.addButton.active = false;
        this.addInvertedButton.active = false;
        CompoundTag tag = new CompoundTag();
        ItemAttribute itemAttribute = this.attributesOfItem.get(index);
        itemAttribute.serializeNBT((HolderLookup.Provider)Minecraft.getInstance().player.registryAccess(), tag);
        MessageSetListFilterScreenOption.Option option = inverted ? MessageSetListFilterScreenOption.Option.ADD_INVERTED_TAG : MessageSetListFilterScreenOption.Option.ADD_TAG;
        Networking.sendToServer(new MessageSetListFilterScreenOption(option, tag));
        ((AttributeFilterMenu)this.menu).selectedAttributes.add((Pair<ItemAttribute, Boolean>)Pair.of((Object)itemAttribute, (Object)inverted));
        if (((AttributeFilterMenu)this.menu).selectedAttributes.size() == 1) {
            this.selectedAttributes.set(0, (Component)SELECTED_ATTRIBUTES.plainCopy().withStyle(ChatFormatting.YELLOW));
        }
        this.selectedAttributes.add((Component)Component.literal((String)"- ").append((Component)itemAttribute.format(inverted)).withStyle(ChatFormatting.GRAY));
        return true;
    }

    private void referenceItemChanged(ItemStack stack) {
        this.lastItemScanned = stack;
        if (stack.isEmpty()) {
            this.attributeSelector.active = false;
            this.attributeSelector.visible = false;
            this.attributeSelectorLabel.text = ADD_REFERENCE_ITEM.plainCopy().withStyle(ChatFormatting.ITALIC);
            this.addButton.active = false;
            this.addInvertedButton.active = false;
            this.attributeSelector.calling(s -> {});
            return;
        }
        this.addButton.active = true;
        this.addInvertedButton.active = true;
        this.attributeSelector.titled(stack.getHoverName().plainCopy().append("..."));
        this.attributesOfItem.clear();
        for (ItemAttribute itemAttribute : ItemAttribute.types) {
            this.attributesOfItem.addAll(itemAttribute.listAttributesOf(stack, (Level)this.minecraft.level));
        }
        List options = this.attributesOfItem.stream().map(a -> a.format(false)).collect(Collectors.toList());
        this.attributeSelector.forOptions(options);
        this.attributeSelector.updateTooltip();
        this.attributeSelector.active = true;
        this.attributeSelector.visible = true;
        this.attributeSelector.setState(0);
        this.attributeSelector.calling(i -> {
            this.attributeSelectorLabel.setTextAndTrim((Component)options.get((int)i), true, 112);
            ItemAttribute selected = this.attributesOfItem.get((int)i);
            for (Pair<ItemAttribute, Boolean> existing : ((AttributeFilterMenu)this.menu).selectedAttributes) {
                CompoundTag testTag = new CompoundTag();
                CompoundTag testTag2 = new CompoundTag();
                ((ItemAttribute)existing.getFirst()).serializeNBT((HolderLookup.Provider)this.minecraft.player.registryAccess(), testTag);
                selected.serializeNBT((HolderLookup.Provider)this.minecraft.player.registryAccess(), testTag2);
                if (!testTag.equals((Object)testTag2)) continue;
                this.addButton.active = false;
                this.addInvertedButton.active = false;
                return;
            }
            this.addButton.active = true;
            this.addInvertedButton.active = true;
        });
        this.attributeSelector.onChanged();
    }
}

