/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.content.item.filter;

import com.klikli_dev.theurgy.content.behaviour.filter.FilterMode;
import com.klikli_dev.theurgy.content.behaviour.filter.attribute.ItemAttribute;
import com.klikli_dev.theurgy.content.item.filter.AttributeFilterMenu;
import com.klikli_dev.theurgy.content.item.filter.FilterItem;
import com.klikli_dev.theurgy.registry.DataComponentRegistry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AttributeFilterItem
extends FilterItem {
    public AttributeFilterItem(Item.Properties pProperties) {
        super(pProperties);
    }

    @Override
    protected List<Component> makeSummary(ItemStack filter, HolderLookup.Provider provider) {
        ArrayList<Component> list = new ArrayList<Component>();
        if (!filter.has(DataComponentRegistry.FILTER_ATTRIBUTES)) {
            return list;
        }
        FilterMode filterMode = (FilterMode)((Object)filter.getOrDefault(DataComponentRegistry.FILTER_MODE, (Object)FilterMode.ACCEPT_LIST_OR));
        list.add((Component)(filterMode == FilterMode.ACCEPT_LIST_AND ? Component.translatable((String)"theurgy.gui.attribute_filter.accept_list_and_button.tooltip") : (filterMode == FilterMode.ACCEPT_LIST_OR ? Component.translatable((String)"theurgy.gui.attribute_filter.accept_list_or_button.tooltip") : Component.translatable((String)"theurgy.gui.attribute_filter.deny_list_button.tooltip"))).withStyle(ChatFormatting.GOLD));
        int count = 0;
        CompoundTag tag = ((CustomData)filter.getOrDefault(DataComponentRegistry.FILTER_ATTRIBUTES, (Object)CustomData.EMPTY)).getUnsafe();
        ListTag attributes = tag.getList("MatchedAttributes", 10);
        for (Tag inbt : attributes) {
            CompoundTag compound = (CompoundTag)inbt;
            ItemAttribute attribute = ItemAttribute.of(provider, compound);
            if (attribute == null) continue;
            boolean inverted = compound.getBoolean("Inverted");
            if (count > 3) {
                list.add((Component)Component.literal((String)"- ...").withStyle(ChatFormatting.DARK_GRAY));
                break;
            }
            list.add((Component)Component.literal((String)"- ").append((Component)attribute.format(inverted)));
            ++count;
        }
        if (count == 0) {
            return Collections.emptyList();
        }
        return list;
    }

    @Nullable
    public AbstractContainerMenu createMenu(int pContainerId, @NotNull Inventory pPlayerInventory, @NotNull Player pPlayer) {
        return AttributeFilterMenu.create(pContainerId, pPlayerInventory, pPlayer.getMainHandItem());
    }
}

