/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.content.behaviour.redstone;

import com.klikli_dev.theurgy.content.behaviour.crafting.CraftingBehaviour;
import com.klikli_dev.theurgy.content.behaviour.crafting.HasCraftingBehaviour;
import com.klikli_dev.theurgy.util.RedstoneUtil;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;

public class VatRedstoneChangeOpenCloseLidBehaviour<R extends Recipe<?>> {
    public void neighborChanged(BlockState pState, Level pLevel, @NotNull BlockPos pPos, @NotNull Block pBlock, @NotNull BlockPos pFromPos, boolean pIsMoving) {
        boolean hasSignal = RedstoneUtil.hasNeighborSignal(pLevel, pPos, ((Direction)pState.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)).getOpposite());
        boolean wasOpen = (Boolean)pState.getValue((Property)BlockStateProperties.OPEN);
        if (hasSignal && wasOpen) {
            BlockEntity blockEntity = pLevel.getBlockEntity(pPos);
            if (!(blockEntity instanceof HasCraftingBehaviour)) {
                return;
            }
            HasCraftingBehaviour vat = (HasCraftingBehaviour)blockEntity;
            CraftingBehaviour craftingBehaviour = vat.craftingBehaviour();
            Optional recipe = craftingBehaviour.getRecipe();
            if (recipe.isPresent() && craftingBehaviour.canCraft(recipe.get())) {
                pLevel.setBlock(pPos, (BlockState)pState.setValue((Property)BlockStateProperties.OPEN, (Comparable)Boolean.valueOf(false)), 2);
            }
        } else if (!hasSignal && !wasOpen) {
            pLevel.setBlock(pPos, (BlockState)pState.setValue((Property)BlockStateProperties.OPEN, (Comparable)Boolean.valueOf(true)), 2);
        }
    }
}

