/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.content.behaviour.filter.attribute;

import com.klikli_dev.theurgy.content.behaviour.filter.attribute.AddedByAttribute;
import com.klikli_dev.theurgy.content.behaviour.filter.attribute.EnchantAttribute;
import com.klikli_dev.theurgy.content.behaviour.filter.attribute.FluidContentsAttribute;
import com.klikli_dev.theurgy.content.behaviour.filter.attribute.InTagAttribute;
import com.klikli_dev.theurgy.content.behaviour.filter.attribute.ItemNameAttribute;
import com.klikli_dev.theurgy.content.behaviour.filter.attribute.StandardAttributes;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public interface ItemAttribute {
    public static final List<ItemAttribute> types = new ArrayList<ItemAttribute>();
    public static final ItemAttribute standard = ItemAttribute.register(StandardAttributes.DUMMY);
    public static final ItemAttribute inTag = ItemAttribute.register(InTagAttribute.DUMMY);
    public static final ItemAttribute addedBy = ItemAttribute.register(new AddedByAttribute("dummy"));
    public static final ItemAttribute hasEnchant = ItemAttribute.register(EnchantAttribute.EMPTY);
    public static final ItemAttribute hasFluid = ItemAttribute.register(FluidContentsAttribute.EMPTY);
    public static final ItemAttribute hasName = ItemAttribute.register(ItemNameAttribute.DUMMY);

    public static ItemAttribute register(ItemAttribute attributeType) {
        types.add(attributeType);
        return attributeType;
    }

    @Nullable
    public static ItemAttribute of(HolderLookup.Provider pRegistries, CompoundTag nbt) {
        for (ItemAttribute itemAttribute : types) {
            if (!itemAttribute.canRead(nbt)) continue;
            return itemAttribute.readNBT(pRegistries, nbt.getCompound(itemAttribute.getNBTKey()));
        }
        return null;
    }

    default public boolean appliesTo(ItemStack stack, Level world) {
        return this.appliesTo(stack);
    }

    public boolean appliesTo(ItemStack var1);

    default public List<ItemAttribute> listAttributesOf(ItemStack stack, Level world) {
        return this.listAttributesOf(stack);
    }

    public List<ItemAttribute> listAttributesOf(ItemStack var1);

    public String getTranslationKey();

    public void writeNBT(HolderLookup.Provider var1, CompoundTag var2);

    public ItemAttribute readNBT(HolderLookup.Provider var1, CompoundTag var2);

    default public void serializeNBT(HolderLookup.Provider pRegistries, CompoundTag nbt) {
        CompoundTag compound = new CompoundTag();
        this.writeNBT(pRegistries, compound);
        nbt.put(this.getNBTKey(), (Tag)compound);
    }

    default public Object[] getTranslationParameters() {
        return new String[0];
    }

    default public boolean canRead(CompoundTag nbt) {
        return nbt.contains(this.getNBTKey());
    }

    default public String getNBTKey() {
        return this.getTranslationKey();
    }

    default public MutableComponent format(boolean inverted) {
        return Component.translatable((String)("item_attributes." + this.getTranslationKey() + (inverted ? ".inverted" : "")), (Object[])this.getTranslationParameters());
    }
}

