/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.content.apparatus.reformationarray;

import com.klikli_dev.theurgy.content.apparatus.reformationarray.SulfuricFluxEmitterSelectedPoint;
import com.klikli_dev.theurgy.content.behaviour.selection.SelectionBehaviour;
import com.klikli_dev.theurgy.network.Networking;
import com.klikli_dev.theurgy.network.messages.MessageSulfuricFluxEmitterSelection;
import com.klikli_dev.theurgy.registry.BlockTagRegistry;
import com.klikli_dev.theurgy.registry.ItemRegistry;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class SulfuricFluxEmitterSelectionBehaviour
extends SelectionBehaviour<SulfuricFluxEmitterSelectedPoint> {
    @Override
    protected void displaySummary(BlockPos pos, Player player) {
        if (this.selectedPoints.isEmpty()) {
            player.displayClientMessage((Component)Component.translatable((String)"theurgy.behaviour.selection.summary.sulfuric_flux_emitter.no_selection").withStyle(ChatFormatting.RED), true);
        } else {
            long sources = this.selectedPoints.stream().filter(s -> s.getType() == SulfuricFluxEmitterSelectedPoint.Type.SOURCE).count();
            long targets = this.selectedPoints.stream().filter(s -> s.getType() == SulfuricFluxEmitterSelectedPoint.Type.TARGET).count();
            long results = this.selectedPoints.stream().filter(s -> s.getType() == SulfuricFluxEmitterSelectedPoint.Type.RESULT).count();
            if (targets == 0L) {
                player.displayClientMessage((Component)Component.translatable((String)"theurgy.behaviour.selection.summary.sulfuric_flux_emitter.no_target").withStyle(ChatFormatting.RED), true);
            }
            if (sources == 0L) {
                player.displayClientMessage((Component)Component.translatable((String)"theurgy.behaviour.selection.summary.sulfuric_flux_emitter.no_sources").withStyle(ChatFormatting.RED), true);
            }
            if (results == 0L) {
                player.displayClientMessage((Component)Component.translatable((String)"theurgy.behaviour.selection.summary.sulfuric_flux_emitter.no_result").withStyle(ChatFormatting.RED), true);
            }
            if (sources > 0L && targets > 0L && results > 0L) {
                player.displayClientMessage((Component)Component.translatable((String)"theurgy.behaviour.selection.summary.sulfuric_flux_emitter", (Object[])new Object[]{Component.literal((String)String.valueOf(sources)).withStyle(ChatFormatting.DARK_PURPLE), Component.literal((String)String.valueOf(targets)).withStyle(ChatFormatting.BLUE), Component.literal((String)String.valueOf(results)).withStyle(ChatFormatting.GREEN)}).withStyle(ChatFormatting.WHITE), true);
            }
        }
    }

    @Override
    protected void sendPlacementPacket(BlockPos pos) {
        List<SulfuricFluxEmitterSelectedPoint> sources = this.selectedPoints.stream().filter(s -> s.getType() == SulfuricFluxEmitterSelectedPoint.Type.SOURCE).toList();
        SulfuricFluxEmitterSelectedPoint target = this.selectedPoints.stream().filter(s -> s.getType() == SulfuricFluxEmitterSelectedPoint.Type.TARGET).findFirst().orElse(null);
        SulfuricFluxEmitterSelectedPoint result = this.selectedPoints.stream().filter(s -> s.getType() == SulfuricFluxEmitterSelectedPoint.Type.RESULT).findFirst().orElse(null);
        Networking.sendToServer(new MessageSulfuricFluxEmitterSelection(pos, sources, target, result));
    }

    @Override
    public int getBlockRange() {
        return 16;
    }

    @Override
    public boolean canCreate(Level level, BlockPos pos, BlockState state) {
        if (!level.isLoaded(pos)) {
            return false;
        }
        return state.is(BlockTagRegistry.REFORMATION_PEDESTALS);
    }

    @Override
    protected SulfuricFluxEmitterSelectedPoint create(Level level, BlockPos pos, BlockState state) {
        if (!this.canCreate(level, pos, state)) {
            return null;
        }
        SulfuricFluxEmitterSelectedPoint.Type type = this.getType(state);
        this.makeSpaceForNewSelection(type);
        return new SulfuricFluxEmitterSelectedPoint(level, pos, state, type);
    }

    private void makeSpaceForNewSelection(SulfuricFluxEmitterSelectedPoint.Type type) {
        if (type != SulfuricFluxEmitterSelectedPoint.Type.SOURCE) {
            if (type == SulfuricFluxEmitterSelectedPoint.Type.TARGET) {
                this.selectedPoints.removeIf(point -> point.getType() == SulfuricFluxEmitterSelectedPoint.Type.TARGET);
            } else {
                this.selectedPoints.removeIf(point -> point.getType() == SulfuricFluxEmitterSelectedPoint.Type.RESULT);
            }
        }
    }

    private SulfuricFluxEmitterSelectedPoint.Type getType(BlockState state) {
        if (state.is(BlockTagRegistry.REFORMATION_SOURCE_PEDESTALS)) {
            return SulfuricFluxEmitterSelectedPoint.Type.SOURCE;
        }
        if (state.is(BlockTagRegistry.REFORMATION_TARGET_PEDESTALS)) {
            return SulfuricFluxEmitterSelectedPoint.Type.TARGET;
        }
        return SulfuricFluxEmitterSelectedPoint.Type.RESULT;
    }

    @Override
    protected boolean isSelectionItem(ItemStack stack) {
        return stack.is((Item)ItemRegistry.SULFURIC_FLUX_EMITTER.get());
    }
}

