/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.content.apparatus.reformationarray;

import com.klikli_dev.theurgy.content.apparatus.reformationarray.SulfuricFluxEmitterBlockEntity;
import com.klikli_dev.theurgy.content.particle.ParticleColor;
import com.klikli_dev.theurgy.content.particle.glow.GlowParticleProvider;
import com.klikli_dev.theurgy.content.storage.MonitoredItemStackHandler;
import com.klikli_dev.theurgy.content.storage.PreventInsertWrapper;
import com.klikli_dev.theurgy.registry.BlockEntityRegistry;
import java.lang.ref.WeakReference;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.Nullable;

public class ReformationResultPedestalBlockEntity
extends BlockEntity {
    public ItemStackHandler outputInventory = new OutputInventory();
    public PreventInsertWrapper outputInventoryTakeOnlyWrapper = new PreventInsertWrapper((IItemHandlerModifiable)this.outputInventory);
    public WeakReference<SulfuricFluxEmitterBlockEntity> sulfuricFluxEmitter;
    protected boolean showParticles;

    public ReformationResultPedestalBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super(BlockEntityRegistry.REFORMATION_RESULT_PEDESTAL.get(), pPos, pBlockState);
    }

    public void setSulfuricFluxEmitter(SulfuricFluxEmitterBlockEntity sulfuricFluxEmitter) {
        this.sulfuricFluxEmitter = new WeakReference<SulfuricFluxEmitterBlockEntity>(sulfuricFluxEmitter);
    }

    public void tickClient() {
        if (this.showParticles && this.level.getRandom().nextFloat() < 0.07f) {
            BlockPos pos = this.getBlockPos();
            this.level.addParticle(GlowParticleProvider.createOptions(ParticleColor.fromInt(32768), 0.5f, 0.75f, 200), (double)((float)pos.getX() + 0.5f), (double)((float)pos.getY() + 1.0f), (double)((float)pos.getZ() + 0.5f), 0.0, 0.0, 0.0);
        }
    }

    public void setRemoved() {
        if (this.sulfuricFluxEmitter != null && this.sulfuricFluxEmitter.get() != null) {
            ((SulfuricFluxEmitterBlockEntity)((Object)this.sulfuricFluxEmitter.get())).removeResultPedestal(this);
            this.sulfuricFluxEmitter.clear();
        }
        super.setRemoved();
    }

    protected void saveAdditional(CompoundTag pTag, HolderLookup.Provider pRegistries) {
        super.saveAdditional(pTag, pRegistries);
        this.writeNetwork(pTag, pRegistries);
    }

    public void loadAdditional(CompoundTag pTag, HolderLookup.Provider pRegistries) {
        super.loadAdditional(pTag, pRegistries);
        this.readNetwork(pTag, pRegistries);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider pRegistries) {
        CompoundTag tag = new CompoundTag();
        this.writeNetwork(tag, pRegistries);
        return tag;
    }

    public void handleUpdateTag(CompoundTag tag, HolderLookup.Provider pRegistries) {
        this.readNetwork(tag, pRegistries);
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void onDataPacket(Connection connection, ClientboundBlockEntityDataPacket packet, HolderLookup.Provider pRegistries) {
        CompoundTag tag = packet.getTag();
        if (tag != null) {
            this.readNetwork(tag, pRegistries);
        }
    }

    public void readNetwork(CompoundTag pTag, HolderLookup.Provider pRegistries) {
        if (pTag.contains("showParticles")) {
            this.showParticles = pTag.getBoolean("showParticles");
        }
        if (pTag.contains("outputInventory")) {
            this.outputInventory.deserializeNBT(pRegistries, pTag.getCompound("outputInventory"));
        }
    }

    public void writeNetwork(CompoundTag pTag, HolderLookup.Provider pRegistries) {
        this.showParticles = !this.outputInventory.getStackInSlot(0).isEmpty();
        pTag.putBoolean("showParticles", this.showParticles);
        pTag.put("outputInventory", (Tag)this.outputInventory.serializeNBT(pRegistries));
    }

    public void sendBlockUpdated() {
        if (this.level != null && !this.level.isClientSide) {
            this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 2);
        }
    }

    public class OutputInventory
    extends MonitoredItemStackHandler {
        public OutputInventory() {
            super(1);
        }

        @Override
        protected void onContentTypeChanged(int slot, ItemStack oldStack, ItemStack newStack) {
            ReformationResultPedestalBlockEntity.this.sendBlockUpdated();
        }

        protected void onContentsChanged(int slot) {
            ReformationResultPedestalBlockEntity.this.setChanged();
        }
    }
}

