/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.content.apparatus.mercurycatalyst;

import com.klikli_dev.theurgy.content.behaviour.crafting.CraftingBehaviour;
import com.klikli_dev.theurgy.content.capability.MercuryFluxStorage;
import com.klikli_dev.theurgy.content.recipe.CatalysationRecipe;
import com.klikli_dev.theurgy.content.recipe.input.ItemHandlerRecipeInput;
import com.klikli_dev.theurgy.registry.DataComponentRegistry;
import com.klikli_dev.theurgy.registry.RecipeTypeRegistry;
import java.util.function.Supplier;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.common.util.Lazy;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.Nullable;

public class MercuryCatalystCraftingBehaviour
extends CraftingBehaviour<ItemHandlerRecipeInput, CatalysationRecipe, RecipeManager.CachedCheck<ItemHandlerRecipeInput, CatalysationRecipe>> {
    private final Supplier<MercuryFluxStorage> mercuryFluxStorageSupplier;
    protected int mercuryFluxToConvert;
    protected int currentMercuryFluxPerTick;

    public MercuryCatalystCraftingBehaviour(BlockEntity blockEntity, Supplier<IItemHandlerModifiable> inputInventorySupplier, Supplier<IItemHandlerModifiable> outputInventorySupplier, Supplier<MercuryFluxStorage> mercuryFluxStorageSupplier) {
        super(blockEntity, Lazy.of(() -> new ItemHandlerRecipeInput((IItemHandlerModifiable)inputInventorySupplier.get())), inputInventorySupplier, outputInventorySupplier, RecipeManager.createCheck((RecipeType)((RecipeType)RecipeTypeRegistry.CATALYSATION.get())));
        this.mercuryFluxStorageSupplier = mercuryFluxStorageSupplier;
    }

    @Override
    public boolean isIngredient(ItemStack stack) {
        ItemStackHandler tempInv = new ItemStackHandler(NonNullList.of((Object)ItemStack.EMPTY, (Object[])new ItemStack[]{stack}));
        ItemHandlerRecipeInput tempRecipeWrapper = new ItemHandlerRecipeInput((IItemHandlerModifiable)tempInv);
        return this.recipeCachedCheck.getRecipeFor((RecipeInput)tempRecipeWrapper, this.blockEntity.getLevel()).isPresent();
    }

    @Override
    public void saveAdditional(CompoundTag pTag, HolderLookup.Provider pRegistries) {
        pTag.putInt("mercuryFluxToConvert", this.mercuryFluxToConvert);
        pTag.putInt("currentMercuryFluxPerTick", this.currentMercuryFluxPerTick);
    }

    @Override
    public void loadAdditional(CompoundTag pTag, HolderLookup.Provider pRegistries) {
        if (pTag.contains("mercuryFluxToConvert")) {
            this.mercuryFluxToConvert = pTag.getInt("mercuryFluxToConvert");
        }
        if (pTag.contains("currentMercuryFluxPerTick")) {
            this.currentMercuryFluxPerTick = pTag.getInt("currentMercuryFluxPerTick");
        }
    }

    @Override
    public void applyImplicitComponents(BlockEntity.DataComponentInput pComponentInput) {
        if (pComponentInput.get(DataComponentRegistry.MERCURY_FLUX_TO_CONVERT) != null) {
            this.mercuryFluxToConvert = (Integer)pComponentInput.get(DataComponentRegistry.MERCURY_FLUX_TO_CONVERT);
        }
        if (pComponentInput.get(DataComponentRegistry.CURRENT_MERCURY_FLUX_PER_TICK) != null) {
            this.currentMercuryFluxPerTick = (Integer)pComponentInput.get(DataComponentRegistry.CURRENT_MERCURY_FLUX_PER_TICK);
        }
    }

    @Override
    public void collectImplicitComponents(DataComponentMap.Builder pComponents) {
        pComponents.set(DataComponentRegistry.MERCURY_FLUX_TO_CONVERT, (Object)this.mercuryFluxToConvert);
        pComponents.set(DataComponentRegistry.CURRENT_MERCURY_FLUX_PER_TICK, (Object)this.currentMercuryFluxPerTick);
    }

    @Override
    protected int getIngredientCount(RecipeHolder<CatalysationRecipe> recipe) {
        return 1;
    }

    @Override
    protected int getCraftingTime(RecipeHolder<CatalysationRecipe> recipe) {
        return -1;
    }

    @Override
    protected int getDefaultCraftingTime() {
        return -1;
    }

    @Override
    public boolean canCraft(@Nullable RecipeHolder<CatalysationRecipe> pRecipe) {
        if (pRecipe == null) {
            return false;
        }
        MercuryFluxStorage storage = this.mercuryFluxStorageSupplier.get();
        int fluxAccepted = storage.receiveEnergy(((CatalysationRecipe)pRecipe.value()).getTotalMercuryFlux(), true);
        return fluxAccepted > 0;
    }

    @Override
    public void tickServer(boolean canProcess, boolean hasInput) {
        if (this.mercuryFluxToConvert > 0) {
            if (canProcess) {
                MercuryFluxStorage storage = this.mercuryFluxStorageSupplier.get();
                int maxFluxToConvert = Math.min(this.mercuryFluxToConvert, this.currentMercuryFluxPerTick);
                int fluxAccepted = storage.receiveEnergy(maxFluxToConvert, false);
                this.mercuryFluxToConvert -= fluxAccepted;
            }
        } else if (hasInput) {
            RecipeHolder recipe = this.recipeCachedCheck.getRecipeFor((RecipeInput)((ItemHandlerRecipeInput)this.recipeInputSupplier.get()), this.blockEntity.getLevel()).orElse(null);
            this.couldCraftLastTick = this.canCraft((RecipeHolder<CatalysationRecipe>)recipe);
            if (canProcess && this.couldCraftLastTick) {
                this.craft((RecipeHolder<CatalysationRecipe>)recipe);
            }
        }
    }

    @Override
    protected boolean craft(@Nullable RecipeHolder<CatalysationRecipe> pRecipe) {
        this.mercuryFluxToConvert = ((CatalysationRecipe)pRecipe.value()).getTotalMercuryFlux();
        this.currentMercuryFluxPerTick = ((CatalysationRecipe)pRecipe.value()).getMercuryFluxPerTick();
        ((IItemHandlerModifiable)this.inputInventorySupplier.get()).extractItem(0, this.getIngredientCount(pRecipe), false);
        return true;
    }
}

