/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.theurgy.content.apparatus.logisticsfluidconnector.extractor;

import com.klikli_dev.theurgy.content.behaviour.filter.Filter;
import com.klikli_dev.theurgy.content.behaviour.logistics.ExtractorNodeBehaviour;
import com.klikli_dev.theurgy.content.behaviour.logistics.InsertTarget;
import com.klikli_dev.theurgy.content.behaviour.logistics.LeafNodeBehaviour;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.capabilities.BlockCapabilityCache;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.Nullable;

public class LogisticsFluidExtractorBehaviour
extends ExtractorNodeBehaviour<IFluidHandler, Direction> {
    public static final int EXTRACTION_EVERY_N_TICKS = 20;
    public static final int MAX_EXTRACTION_AMOUNT = 5000;
    private final int slowTickRandomOffset = (int)(Math.random() * 20.0);
    private int extractionAmount = 5000;
    private Direction directionOverride = null;
    private boolean enabled = true;

    public LogisticsFluidExtractorBehaviour(BlockEntity blockEntity) {
        super(blockEntity, Capabilities.FluidHandler.BLOCK);
    }

    @Override
    protected boolean isValidInsertTarget(LeafNodeBehaviour<IFluidHandler, @Nullable Direction> leafNode, BlockCapabilityCache<IFluidHandler, @Nullable Direction> capability) {
        return true;
    }

    @Override
    @Nullable
    public Direction getTargetContext(BlockPos targetPos) {
        return this.directionOverride != null ? this.directionOverride : (Direction)this.blockEntity.getBlockState().getValue((Property)BlockStateProperties.FACING);
    }

    @Override
    public boolean enabled() {
        return this.enabled;
    }

    @Override
    public void enabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void directionOverride(Direction directionOverride) {
        this.directionOverride = directionOverride;
        this.rebuildExtractTargets();
    }

    public Direction directionOverride() {
        return this.directionOverride;
    }

    @Override
    public void saveAdditional(CompoundTag pTag, HolderLookup.Provider pRegistries) {
        super.saveAdditional(pTag, pRegistries);
        pTag.putInt("extractionAmount", this.extractionAmount);
    }

    @Override
    public void loadAdditional(CompoundTag pTag, HolderLookup.Provider pRegistries) {
        super.loadAdditional(pTag, pRegistries);
        if (pTag.contains("extractionAmount")) {
            this.extractionAmount = pTag.getInt("extractionAmount");
        }
    }

    @Override
    public void writeNetwork(CompoundTag pTag, HolderLookup.Provider pRegistries) {
        super.writeNetwork(pTag, pRegistries);
        pTag.putBoolean("enabled", this.enabled);
        if (this.directionOverride != null) {
            pTag.putInt("directionOverride", this.directionOverride.get3DDataValue());
        }
    }

    @Override
    public void readNetwork(CompoundTag pTag, HolderLookup.Provider pRegistries) {
        super.readNetwork(pTag, pRegistries);
        if (pTag.contains("directionOverride")) {
            this.directionOverride = Direction.from3DDataValue((int)pTag.getInt("directionOverride"));
        }
        if (pTag.contains("enabled")) {
            this.enabled = pTag.getBoolean("enabled");
        }
    }

    @Override
    public void tickServer() {
        if (!this.enabled) {
            return;
        }
        super.tickServer();
        if (((long)this.slowTickRandomOffset + this.blockEntity.getLevel().getGameTime()) % 20L != 0L) {
            return;
        }
        this.distributor.tick();
        InsertTarget insertTarget = this.distributor.target();
        if (insertTarget == null || !insertTarget.inserter().enabled()) {
            return;
        }
        BlockCapabilityCache extractTarget = (BlockCapabilityCache)this.extractTargets.getFirst();
        if (extractTarget == null) {
            return;
        }
        IFluidHandler insertCap = (IFluidHandler)insertTarget.capability().getCapability();
        if (insertCap == null) {
            return;
        }
        IFluidHandler extractCap = (IFluidHandler)extractTarget.getCapability();
        if (extractCap == null) {
            return;
        }
        this.performExtraction(extractCap, this.filter(), insertCap, insertTarget.inserter().filter());
    }

    protected void performExtraction(IFluidHandler extractCap, Filter extractFilter, IFluidHandler insertCap, Filter insertFilter) {
        FluidStack extractStack = extractCap.drain(this.extractionAmount, IFluidHandler.FluidAction.SIMULATE);
        if (extractStack.isEmpty()) {
            return;
        }
        if (!extractFilter.test(this.level(), extractStack) || !insertFilter.test(this.level(), extractStack)) {
            return;
        }
        int inserted = insertCap.fill(extractStack, IFluidHandler.FluidAction.SIMULATE);
        if (inserted > 0) {
            inserted = insertCap.fill(extractStack, IFluidHandler.FluidAction.EXECUTE);
            extractCap.drain(inserted, IFluidHandler.FluidAction.EXECUTE);
        }
    }
}

