/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.worldgen.processors;

import com.mojang.serialization.MapCodec;
import com.telepathicgrunt.the_bumblezone.modinit.BzProcessors;
import com.telepathicgrunt.the_bumblezone.utils.GeneralUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public class RemoveFloatingBlocksProcessor
extends StructureProcessor {
    public static final MapCodec<RemoveFloatingBlocksProcessor> CODEC = MapCodec.unit(RemoveFloatingBlocksProcessor::new);

    private RemoveFloatingBlocksProcessor() {
    }

    public StructureTemplate.StructureBlockInfo processBlock(LevelReader levelReader, BlockPos pos, BlockPos blockPos, StructureTemplate.StructureBlockInfo structureBlockInfoLocal, StructureTemplate.StructureBlockInfo structureBlockInfoWorld, StructurePlaceSettings settings) {
        if (GeneralUtils.isOutsideStructureAllowedBounds(settings, structureBlockInfoWorld.pos())) {
            return structureBlockInfoWorld;
        }
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos().set((Vec3i)structureBlockInfoWorld.pos());
        if (structureBlockInfoWorld.state().isAir() || !structureBlockInfoWorld.state().getFluidState().isEmpty()) {
            ChunkAccess cachedChunk = levelReader.getChunk((BlockPos)mutable);
            BlockState aboveWorldState = cachedChunk.getBlockState((BlockPos)mutable.move(Direction.UP));
            if (!aboveWorldState.isAir() && !aboveWorldState.canOcclude()) {
                if (aboveWorldState.hasBlockEntity()) {
                    cachedChunk.removeBlockEntity((BlockPos)mutable);
                }
                cachedChunk.setBlockState((BlockPos)mutable, structureBlockInfoWorld.state(), false);
                mutable.move(Direction.UP);
                aboveWorldState = cachedChunk.getBlockState((BlockPos)mutable);
                while (mutable.getY() < levelReader.getHeight() && !aboveWorldState.canSurvive(levelReader, (BlockPos)mutable)) {
                    if (aboveWorldState.hasBlockEntity()) {
                        cachedChunk.removeBlockEntity((BlockPos)mutable);
                    }
                    cachedChunk.setBlockState((BlockPos)mutable, structureBlockInfoWorld.state(), false);
                    mutable.move(Direction.UP);
                    aboveWorldState = cachedChunk.getBlockState((BlockPos)mutable);
                }
            }
        } else if (!structureBlockInfoWorld.state().canSurvive(levelReader, (BlockPos)mutable)) {
            return new StructureTemplate.StructureBlockInfo(structureBlockInfoWorld.pos(), Blocks.CAVE_AIR.defaultBlockState(), null);
        }
        return structureBlockInfoWorld;
    }

    protected StructureProcessorType<?> getType() {
        return (StructureProcessorType)BzProcessors.REMOVE_FLOATING_BLOCKS_PROCESSOR.get();
    }
}

