/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.worldgen.features;

import com.mojang.serialization.Codec;
import com.telepathicgrunt.the_bumblezone.modinit.BzBlocks;
import com.telepathicgrunt.the_bumblezone.modinit.BzTags;
import com.telepathicgrunt.the_bumblezone.utils.OpenSimplex2F;
import com.telepathicgrunt.the_bumblezone.worldgen.features.configs.TwoToneSpikeFeatureConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;

public class TwoToneSpikeFeature
extends Feature<TwoToneSpikeFeatureConfig> {
    protected long seed;
    protected static OpenSimplex2F noiseGen;

    public TwoToneSpikeFeature(Codec<TwoToneSpikeFeatureConfig> configFactory) {
        super(configFactory);
    }

    public void setSeed(long seed) {
        if (this.seed != seed || noiseGen == null) {
            noiseGen = new OpenSimplex2F(seed);
            this.seed = seed;
        }
    }

    public boolean place(FeaturePlaceContext<TwoToneSpikeFeatureConfig> context) {
        BlockState state;
        this.setSeed(context.level().getSeed());
        BlockPos.MutableBlockPos blockpos$Mutable = new BlockPos.MutableBlockPos();
        WorldGenLevel level = context.level();
        RandomSource random = context.random();
        BlockPos origin = context.origin();
        if (level.getBlockState(origin).canOcclude()) {
            return false;
        }
        boolean validSpot = false;
        BlockState attachedState = null;
        for (Direction direction : Direction.Plane.VERTICAL) {
            blockpos$Mutable.set((Vec3i)origin).move(direction, 5);
            state = level.getBlockState((BlockPos)blockpos$Mutable);
            if (!state.canOcclude()) continue;
            validSpot = true;
            attachedState = state;
            break;
        }
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            blockpos$Mutable.set((Vec3i)origin).move(direction, 1);
            state = level.getBlockState((BlockPos)blockpos$Mutable);
            if (!state.canOcclude()) continue;
            validSpot = true;
            attachedState = state;
        }
        if (!validSpot) {
            return false;
        }
        if (!attachedState.is(((TwoToneSpikeFeatureConfig)context.config()).allowedBaseBlockCopies)) {
            return false;
        }
        blockpos$Mutable.set((Vec3i)origin).move(Direction.UP, 5);
        int directionSign = level.getBlockState((BlockPos)blockpos$Mutable).canOcclude() ? -1 : 1;
        int currentY = origin.getY() - directionSign * 5;
        int thickness = random.nextInt(3) + 4;
        int height = ((TwoToneSpikeFeatureConfig)context.config()).heightRange.sample(context.random());
        int slantAmountX = (random.nextInt(6) + 5) * (random.nextBoolean() ? -1 : 1);
        int slantAmountZ = (random.nextInt(6) + 5) * (random.nextBoolean() ? -1 : 1);
        if (random.nextInt(4) == 0) {
            slantAmountX = 0;
        }
        if (random.nextInt(4) == 0) {
            slantAmountZ = 0;
        }
        BlockState tipBlock = ((TwoToneSpikeFeatureConfig)context.config()).tipBlocks.get(context.random().nextInt(((TwoToneSpikeFeatureConfig)context.config()).tipBlocks.size())).defaultBlockState();
        for (int layer = 0; layer < height; ++layer) {
            int currentZSlant;
            float currentThickness = thickness;
            int currentXSlant = slantAmountX == 0 ? 0 : layer / slantAmountX;
            int n = currentZSlant = slantAmountZ == 0 ? 0 : layer / slantAmountZ;
            if (layer == 0) {
                currentThickness -= 2.0f;
            } else if (layer == 1) {
                currentThickness -= 1.0f;
            } else if (layer == height - 1) {
                currentThickness = 0.5f;
                currentXSlant = slantAmountX == 0 ? 0 : (layer - 1) / slantAmountX;
                currentZSlant = slantAmountZ == 0 ? 0 : (layer - 1) / slantAmountZ;
            } else {
                currentThickness *= Math.max((float)(height - layer) / (float)height, 0.2f);
                currentThickness = Math.max(currentThickness, 1.1f);
            }
            int x = (int)(-currentThickness);
            while ((float)x <= currentThickness) {
                int z = (int)(-currentThickness);
                while ((float)z <= currentThickness) {
                    if ((float)(x * x + z * z) < currentThickness * currentThickness) {
                        blockpos$Mutable.set(origin.getX() + x + currentXSlant, currentY, origin.getZ() + z + currentZSlant);
                        BlockState state2 = level.getBlockState((BlockPos)blockpos$Mutable);
                        if (!(state2.canOcclude() || state2.is((Block)BzBlocks.CRYSTALLINE_FLOWER.get()) || state2.is(BzTags.AIR_LIKE))) {
                            BlockState newState = (double)layer > (double)((float)(height * 2) / 3.0f) + noiseGen.noise3_Classic(blockpos$Mutable.getX(), blockpos$Mutable.getY(), blockpos$Mutable.getZ()) * 2.0 ? tipBlock : attachedState;
                            level.setBlock((BlockPos)blockpos$Mutable, newState, 3);
                        }
                    }
                    ++z;
                }
                ++x;
            }
            currentY += directionSign;
        }
        return false;
    }
}

