/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.modcompat.neoforge;

import com.telepathicgrunt.the_bumblezone.blocks.HeavyAir;
import com.telepathicgrunt.the_bumblezone.modcompat.ModChecker;
import com.telepathicgrunt.the_bumblezone.modcompat.ModCompat;
import net.minecraft.ChatFormatting;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;

public class ReliquaryCompat
implements ModCompat {
    public static Item RENDING_GALE;

    public ReliquaryCompat() {
        RENDING_GALE = (Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"reliquary", (String)"rending_gale"));
        IEventBus eventBus = NeoForge.EVENT_BUS;
        eventBus.addListener(ReliquaryCompat::onRendingGaleItemUse);
        ModChecker.reliquaryPresent = true;
    }

    public static void onRendingGaleItemUse(PlayerInteractEvent.RightClickItem event) {
        Player entity;
        if (RENDING_GALE != null && event.getItemStack().is(RENDING_GALE) && (entity = event.getEntity()) != null && HeavyAir.isInHeavyAir(entity.level(), entity.getBoundingBox())) {
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                serverPlayer.displayClientMessage((Component)Component.translatable((String)"system.the_bumblezone.denied_magic").withStyle(ChatFormatting.ITALIC).withStyle(ChatFormatting.RED), true);
            }
            event.getEntity().swing(event.getHand());
            event.setCanceled(true);
        }
    }
}

