/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.modcompat.neoforge;

import com.telepathicgrunt.the_bumblezone.modcompat.ModChecker;
import com.telepathicgrunt.the_bumblezone.modcompat.ModCompat;
import com.telepathicgrunt.the_bumblezone.modinit.BzDimension;
import com.telepathicgrunt.the_bumblezone.modinit.BzTags;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingDropsEvent;

public class CorailTombstoneCompat
implements ModCompat {
    public CorailTombstoneCompat() {
        ModChecker.corailTombstonePresent = true;
    }

    @EventBusSubscriber(modid="the_bumblezone", bus=EventBusSubscriber.Bus.GAME)
    public static final class CorailCompatEvents {
        @SubscribeEvent(priority=EventPriority.LOW)
        public static void onDrops(LivingDropsEvent event) {
            StructureManager structureManager;
            StructureStart detectedStructure;
            ServerPlayer serverPlayer;
            LivingEntity livingEntity;
            if (ModChecker.corailTombstonePresent && !event.getDrops().isEmpty() && (livingEntity = event.getEntity()) instanceof ServerPlayer && !(serverPlayer = (ServerPlayer)livingEntity).isFakePlayer() && !event.getEntity().level().getGameRules().getBoolean(GameRules.RULE_KEEPINVENTORY) && serverPlayer.level().dimension().equals(BzDimension.BZ_WORLD_KEY) && (detectedStructure = (structureManager = ((ServerLevel)serverPlayer.level()).structureManager()).getStructureWithPieceAt(serverPlayer.blockPosition(), BzTags.SEMPITERNAL_SANCTUMS)).isValid()) {
                BlockPos structureCenter = detectedStructure.getBoundingBox().getCenter().below(20);
                if (!serverPlayer.level().getBlockState(structureCenter).is(BzTags.ESSENCE_BLOCKS) || !AABB.ofSize((Vec3)Vec3.atCenterOf((Vec3i)structureCenter), (double)40.0, (double)20.0, (double)40.0).contains(Vec3.atCenterOf((Vec3i)serverPlayer.blockPosition()))) {
                    return;
                }
                for (ItemEntity itemEntity : event.getDrops()) {
                    itemEntity.setUnlimitedLifetime();
                    itemEntity.setPickUpDelay(40);
                    itemEntity.setPos(serverPlayer.getEyePosition());
                    itemEntity.setDeltaMovement(itemEntity.getDeltaMovement().multiply(0.0, 1.0, 0.0));
                    serverPlayer.level().addFreshEntity((Entity)itemEntity);
                }
                serverPlayer.displayClientMessage((Component)Component.translatable((String)"system.the_bumblezone.corail_tombstone_drop_compat").withStyle(ChatFormatting.GOLD), false);
                event.getDrops().clear();
            }
        }
    }
}

