/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.modcompat;

import com.mojang.datafixers.util.Pair;
import com.telepathicgrunt.the_bumblezone.client.utils.GeneralUtilsClient;
import com.telepathicgrunt.the_bumblezone.configs.BzModCompatibilityConfigs;
import com.telepathicgrunt.the_bumblezone.entities.datamanagers.queentrades.QueensTradeManager;
import com.telepathicgrunt.the_bumblezone.entities.datamanagers.queentrades.WeightedTradeResult;
import com.telepathicgrunt.the_bumblezone.items.recipes.PotionCandleRecipe;
import com.telepathicgrunt.the_bumblezone.modcompat.FakePotionCandleRecipeCreator;
import com.telepathicgrunt.the_bumblezone.modcompat.recipecategories.MainTradeRowInput;
import com.telepathicgrunt.the_bumblezone.modcompat.recipecategories.RandomizeTradeRowInput;
import com.telepathicgrunt.the_bumblezone.modcompat.recipecategories.jei.JEIQueenRandomizerTradesInfo;
import com.telepathicgrunt.the_bumblezone.modcompat.recipecategories.jei.JEIQueenTradesInfo;
import com.telepathicgrunt.the_bumblezone.modcompat.recipecategories.jei.QueenRandomizeTradesJEICategory;
import com.telepathicgrunt.the_bumblezone.modcompat.recipecategories.jei.QueenTradesJEICategory;
import com.telepathicgrunt.the_bumblezone.modinit.BzCreativeTabs;
import com.telepathicgrunt.the_bumblezone.modinit.BzFluids;
import com.telepathicgrunt.the_bumblezone.modinit.BzItems;
import com.telepathicgrunt.the_bumblezone.modinit.BzTags;
import com.telepathicgrunt.the_bumblezone.utils.GeneralUtils;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.helpers.IPlatformFluidHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.random.WeightedRandomList;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import org.jetbrains.annotations.NotNull;

@JeiPlugin
public class JEIIntegration
implements IModPlugin {
    public static final RecipeType<JEIQueenTradesInfo> QUEEN_TRADES = RecipeType.create((String)"the_bumblezone", (String)"queen_trades", JEIQueenTradesInfo.class);
    public static final RecipeType<JEIQueenRandomizerTradesInfo> QUEEN_RANDOMIZE_TRADES = RecipeType.create((String)"the_bumblezone", (String)"queen_color_randomizer_trades", JEIQueenRandomizerTradesInfo.class);

    private static void addInfo(IRecipeRegistration registration, Item item) {
        registration.addIngredientInfo((Object)new ItemStack((ItemLike)item), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{Component.translatable((String)("the_bumblezone." + BuiltInRegistries.ITEM.getKey((Object)item).getPath() + ".description"))});
    }

    private static void addInfo(IRecipeRegistration registration, Fluid fluid) {
        JEIIntegration.addFluidData(registration, fluid, registration.getJeiHelpers().getPlatformFluidHelper());
    }

    private static <T> void addFluidData(IRecipeRegistration registration, Fluid fluid, IPlatformFluidHelper<T> platformFluidHelper) {
        registration.addIngredientInfo(platformFluidHelper.create((Holder)fluid.builtInRegistryHolder(), 1000L), (IIngredientType)platformFluidHelper.getFluidIngredientType(), new Component[]{Component.translatable((String)("the_bumblezone." + BuiltInRegistries.FLUID.getKey((Object)fluid).getPath() + ".description"))});
    }

    private static void registerExtraRecipes(RecipeHolder<?> baseRecipe, IRecipeRegistration registration, boolean oneRecipeOnly) {
        Recipe recipe = baseRecipe.value();
        if (recipe instanceof PotionCandleRecipe) {
            PotionCandleRecipe potionCandleRecipe = (PotionCandleRecipe)recipe;
            List<CraftingRecipe> extraRecipes = FakePotionCandleRecipeCreator.constructFakeRecipes(potionCandleRecipe, oneRecipeOnly);
            ArrayList<RecipeHolder> holders = new ArrayList<RecipeHolder>(extraRecipes.size());
            for (int i = 0; i < extraRecipes.size(); ++i) {
                holders.add(new RecipeHolder(ResourceLocation.fromNamespaceAndPath((String)baseRecipe.id().getNamespace(), (String)(baseRecipe.id().getPath() + "_" + i)), (Recipe)extraRecipes.get(i)));
            }
            registration.addRecipes(RecipeTypes.CRAFTING, holders);
        }
    }

    public ResourceLocation getPluginUid() {
        return ResourceLocation.fromNamespaceAndPath((String)"the_bumblezone", (String)"jei_plugin");
    }

    public void registerRecipes(@NotNull IRecipeRegistration registration) {
        Level level;
        BzCreativeTabs.CUSTOM_CREATIVE_TAB_ITEMS.forEach(item -> JEIIntegration.addInfo(registration, (Item)item.get()));
        JEIIntegration.addInfo(registration, (Fluid)BzFluids.SUGAR_WATER_FLUID.get());
        JEIIntegration.addInfo(registration, (Fluid)BzFluids.ROYAL_JELLY_FLUID.get());
        if (BzModCompatibilityConfigs.alternativeFluidToReplaceHoneyFluid.isEmpty()) {
            JEIIntegration.addInfo(registration, (Fluid)BzFluids.HONEY_FLUID.get());
        }
        if ((level = GeneralUtilsClient.getClientLevel()) == null) {
            return;
        }
        level.getRecipeManager().byKey(ResourceLocation.fromNamespaceAndPath((String)"the_bumblezone", (String)"potion_candle/from_super_candles")).ifPresent(recipe -> JEIIntegration.registerExtraRecipes(recipe, registration, true));
        level.getRecipeManager().byKey(ResourceLocation.fromNamespaceAndPath((String)"the_bumblezone", (String)"potion_candle/from_string_and_carvable_wax")).ifPresent(recipe -> JEIIntegration.registerExtraRecipes(recipe, registration, false));
        LinkedList<JEIQueenTradesInfo> trades = new LinkedList<JEIQueenTradesInfo>();
        if (!QueensTradeManager.QUEENS_TRADE_MANAGER.recipeViewerMainTrades.isEmpty()) {
            for (Pair<MainTradeRowInput, WeightedRandomList<WeightedTradeResult>> trade : QueensTradeManager.QUEENS_TRADE_MANAGER.recipeViewerMainTrades) {
                for (WeightedTradeResult weightedTradeResult : ((WeightedRandomList)trade.getSecond()).unwrap()) {
                    trades.add(new JEIQueenTradesInfo((MainTradeRowInput)trade.getFirst(), weightedTradeResult));
                }
            }
        }
        registration.addRecipes(QUEEN_TRADES, trades);
        LinkedList<JEIQueenRandomizerTradesInfo> randomizerTrades = new LinkedList<JEIQueenRandomizerTradesInfo>();
        if (!QueensTradeManager.QUEENS_TRADE_MANAGER.recipeViewerRandomizerTrades.isEmpty()) {
            Object2ObjectOpenHashMap cacheJeiData = new Object2ObjectOpenHashMap();
            for (RandomizeTradeRowInput tradeEntry : QueensTradeManager.QUEENS_TRADE_MANAGER.recipeViewerRandomizerTrades) {
                TagKey<Item> itemTagKey = tradeEntry.tagKey().get();
                TagData tagData = cacheJeiData.getOrDefault(itemTagKey, null);
                if (tagData == null) {
                    List<ItemStack> randomizeStack = tradeEntry.getWantItems().stream().map(e -> ((Item)e.value()).getDefaultInstance()).toList();
                    tagData = new TagData(randomizeStack.size(), randomizeStack, Ingredient.of(itemTagKey));
                    cacheJeiData.put(itemTagKey, tagData);
                }
                randomizerTrades.add(new JEIQueenRandomizerTradesInfo(itemTagKey, tagData.jeiIngredient(), tagData.listSize(), tagData.jeiItems()));
            }
        }
        registration.addRecipes(QUEEN_RANDOMIZE_TRADES, randomizerTrades);
        List<ItemStack> hangingGardensFlowers = GeneralUtils.convertBlockTagsToItemStacks(BzTags.HANGING_GARDEN_ALLOWED_FLOWERS_BLOCKS, BzTags.HANGING_GARDEN_FORCED_DISALLOWED_FLOWERS_BLOCKS);
        hangingGardensFlowers.addAll(GeneralUtils.convertBlockTagsToItemStacks(BzTags.HANGING_GARDEN_ALLOWED_TALL_FLOWERS_BLOCKS, BzTags.HANGING_GARDEN_FORCED_DISALLOWED_TALL_FLOWERS_BLOCKS));
        JEIIntegration.addComplexBlockTagInfo(registration, Pair.of((Object)".hanging_gardens_flowers.description", hangingGardensFlowers), Pair.of((Object)".crystalline_flower_can_be_placed_on.description", GeneralUtils.convertBlockTagsToItemStacks(BzTags.CRYSTALLINE_FLOWER_CAN_SURVIVE_ON, null)));
    }

    @SafeVarargs
    private static void addComplexBlockTagInfo(@NotNull IRecipeRegistration registration, Pair<String, List<ItemStack>> ... structureInfo) {
        for (Pair<String, List<ItemStack>> predicatePair : structureInfo) {
            registration.addIngredientInfo((List)predicatePair.getSecond(), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{Component.translatable((String)("the_bumblezone" + (String)predicatePair.getFirst()))});
        }
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        registration.addRecipeCategories(new IRecipeCategory[]{new QueenTradesJEICategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new QueenRandomizeTradesJEICategory(registration.getJeiHelpers().getGuiHelper())});
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(((Item)BzItems.BEE_QUEEN_SPAWN_EGG.get()).getDefaultInstance(), new RecipeType[]{QUEEN_TRADES});
        registration.addRecipeCatalyst(((Item)BzItems.BEE_QUEEN_SPAWN_EGG.get()).getDefaultInstance(), new RecipeType[]{QUEEN_RANDOMIZE_TRADES});
    }

    record TagData(int listSize, List<ItemStack> jeiItems, Ingredient jeiIngredient) {
    }
}

