/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.entities.nonliving;

import com.telepathicgrunt.the_bumblezone.blocks.EssenceBlockYellow;
import com.telepathicgrunt.the_bumblezone.blocks.blockentities.EssenceBlockEntity;
import com.telepathicgrunt.the_bumblezone.modinit.BzSounds;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.portal.DimensionTransition;
import net.minecraft.world.phys.Vec3;

public class ElectricRingEntity
extends Entity {
    private static final EntityDataAccessor<Boolean> DATA_ID_DISAPPEARING_SET = SynchedEntityData.defineId(ElectricRingEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final int DISAPPERING_TIMESPAN = 20;
    public static final int APPEARING_TIMESPAN = 20;
    public int disappearingTime = -1;
    private UUID essenceController = null;
    private BlockPos essenceControllerBlockPos = null;
    private ResourceKey<Level> essenceControllerDimension = null;

    public ElectricRingEntity(EntityType<? extends ElectricRingEntity> entityType, Level level) {
        super(entityType, level);
        this.refreshDimensions();
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(DATA_ID_DISAPPEARING_SET, (Object)(this.disappearingTime > 0 ? 1 : 0));
    }

    public UUID getEssenceController() {
        return this.essenceController;
    }

    public void setEssenceController(UUID essenceController) {
        this.essenceController = essenceController;
    }

    public BlockPos getEssenceControllerBlockPos() {
        return this.essenceControllerBlockPos;
    }

    public void setEssenceControllerBlockPos(BlockPos essenceControllerBlockPos) {
        this.essenceControllerBlockPos = essenceControllerBlockPos;
    }

    public ResourceKey<Level> getEssenceControllerDimension() {
        return this.essenceControllerDimension;
    }

    public void setEssenceControllerDimension(ResourceKey<Level> essenceControllerDimension) {
        this.essenceControllerDimension = essenceControllerDimension;
    }

    public boolean getDisappearingMarker() {
        return (Boolean)this.entityData.get(DATA_ID_DISAPPEARING_SET);
    }

    protected void setDisappearingMarker(boolean disappearingMarker) {
        this.entityData.set(DATA_ID_DISAPPEARING_SET, (Object)disappearingMarker);
    }

    public void tick() {
        super.tick();
        this.setRot(this.getYRot(), this.getXRot());
        if (this.level().isClientSide()) {
            if (this.tickCount % 2 == 0) {
                this.makeParticle(1);
            }
            if (this.getDisappearingMarker() && this.disappearingTime == -1) {
                this.disappearingTime = 20;
            }
        } else if (this.tickCount == 1) {
            this.makeServerParticle(50, (ServerLevel)this.level());
        }
        if (this.disappearingTime > 0) {
            --this.disappearingTime;
        }
        if (this.disappearingTime == 0) {
            this.discard();
        }
        if (!this.level().isClientSide() && this.tickCount % 20 == 0) {
            this.checkIfStillInEvent();
        }
    }

    private void checkIfStillInEvent() {
        UUID essenceUuid = this.getEssenceController();
        ResourceKey<Level> essenceDimension = this.getEssenceControllerDimension();
        BlockPos essenceBlockPos = this.getEssenceControllerBlockPos();
        if (essenceBlockPos == null || essenceUuid == null || essenceDimension == null) {
            return;
        }
        BlockPos blockPos = this.blockPosition();
        EssenceBlockEntity essenceBlockEntity = EssenceBlockEntity.getEssenceBlockAtLocation(this.level(), essenceDimension, essenceBlockPos, essenceUuid);
        if (essenceBlockEntity != null) {
            BlockPos arenaSize = essenceBlockEntity.getArenaSize();
            if (Math.abs(blockPos.getX() - essenceBlockPos.getX()) > arenaSize.getX() / 2 || Math.abs(blockPos.getY() - essenceBlockPos.getY()) > arenaSize.getY() / 2 || Math.abs(blockPos.getZ() - essenceBlockPos.getZ()) > arenaSize.getZ() / 2) {
                this.remove(Entity.RemovalReason.DISCARDED);
            }
        } else {
            this.remove(Entity.RemovalReason.DISCARDED);
        }
    }

    public void baseTick() {
        super.baseTick();
        this.yRotO = this.getYRot();
        this.xRotO = this.getXRot();
    }

    private void makeParticle(int particlesToSpawn) {
        if (particlesToSpawn > 0) {
            double size = this.getBoundingBox().getSize();
            double extraScale = 1.5;
            double x = this.getX() + (double)(this.random.nextFloat() - 0.5f) * size * extraScale;
            double y = this.getY() + size / 2.0 + (double)(this.random.nextFloat() - 0.5f) * size * extraScale;
            double z = this.getZ() + (double)(this.random.nextFloat() - 0.5f) * size * extraScale;
            for (int i = 0; i < particlesToSpawn; ++i) {
                this.level().addParticle((ParticleOptions)ParticleTypes.ELECTRIC_SPARK, x, y, z, (double)((this.random.nextFloat() - 0.5f) * 0.5f), (double)((this.random.nextFloat() - 0.5f) * 0.5f), (double)((this.random.nextFloat() - 0.5f) * 0.5f));
            }
        }
    }

    private void makeServerParticle(int particlesToSpawn, ServerLevel serverLevel) {
        if (particlesToSpawn > 0) {
            double xOffset = (double)this.random.nextFloat() * 0.3 - 0.15;
            double yOffset = (double)this.random.nextFloat() * 0.3 - 0.15;
            double zOffset = (double)this.random.nextFloat() * 0.3 - 0.15;
            serverLevel.sendParticles((ParticleOptions)ParticleTypes.CRIT, this.getX(), this.getEyeY(), this.getZ(), particlesToSpawn, this.random.nextGaussian() * xOffset, this.random.nextGaussian() * yOffset + (double)0.2f, this.random.nextGaussian() * zOffset, 1.5);
            serverLevel.sendParticles((ParticleOptions)ParticleTypes.ENCHANTED_HIT, this.getX(), this.getEyeY(), this.getZ(), particlesToSpawn, this.random.nextGaussian() * xOffset, this.random.nextGaussian() * yOffset + (double)0.2f, this.random.nextGaussian() * zOffset, 1.0);
            serverLevel.sendParticles((ParticleOptions)ParticleTypes.FIREWORK, this.getX(), this.getEyeY(), this.getZ(), particlesToSpawn, this.random.nextGaussian() * xOffset, this.random.nextGaussian() * yOffset + (double)0.2f, this.random.nextGaussian() * zOffset, (double)0.2f);
        }
    }

    public void playerTouch(Player player) {
        Vec3 centerOfRing;
        double ringRadiusSq;
        if (!(this.level().isClientSide() || this.isRemoved() || this.disappearingTime != -1 || this.intersectedPassed(player, ringRadiusSq = Math.pow(this.getBoundingBox().getSize() / 2.0 + 0.2, 2.0), centerOfRing = this.getEyePosition(), player.getEyePosition()) || this.intersectedPassed(player, ringRadiusSq, centerOfRing, player.getBoundingBox().getCenter()))) {
            this.intersectedPassed(player, ringRadiusSq, centerOfRing, player.getEyePosition().subtract(0.0, (double)player.getEyeHeight(), 0.0));
        }
        super.playerTouch(player);
    }

    private boolean intersectedPassed(Player player, double ringRadiusSq, Vec3 centerOfRing, Vec3 playerPosToCheck) {
        double playerSpeed;
        double rangeCheck;
        double divisor;
        Vec3 normalVector;
        double numerator;
        double distanceBetweenPlayerAndPlane;
        Vec3 playerPoint = playerPosToCheck.subtract(centerOfRing);
        if (playerPoint.x() * playerPoint.x() + playerPoint.y() * playerPoint.y() + playerPoint.z() * playerPoint.z() < ringRadiusSq && (distanceBetweenPlayerAndPlane = (numerator = Math.abs((normalVector = this.getLookAngle()).x() * playerPoint.x() + normalVector.y() * playerPoint.y() + normalVector.z() * playerPoint.z())) / (divisor = Math.sqrt(normalVector.x() * normalVector.x() + normalVector.y() * normalVector.y() + normalVector.z() * normalVector.z()))) < (rangeCheck = Math.max((double)0.2f, playerSpeed = (Math.pow(player.getSpeed() + 1.0f, 3.0) - 1.0) * 2.0))) {
            Block block;
            EssenceBlockEntity essenceBlockEntity = EssenceBlockEntity.getEssenceBlockAtLocation(this.level(), this.getEssenceControllerDimension(), this.getEssenceControllerBlockPos(), this.getEssenceController());
            if (essenceBlockEntity != null && (block = essenceBlockEntity.getBlockState().getBlock()) instanceof EssenceBlockYellow) {
                EssenceBlockYellow essenceBlockYellow = (EssenceBlockYellow)block;
                essenceBlockYellow.ringActivated(this, essenceBlockEntity, (ServerPlayer)player);
            }
            this.makeServerParticle(50, (ServerLevel)this.level());
            this.disappearingTime = 20;
            this.setDisappearingMarker(true);
            this.playSound((SoundEvent)BzSounds.ELECTRIC_RING_PASSED.get());
            return true;
        }
        return false;
    }

    public boolean displayFireAnimation() {
        return false;
    }

    public boolean canChangeDimensions(Level fromLevel, Level toLevel) {
        return false;
    }

    public Entity changeDimension(DimensionTransition dimensionTransition) {
        return this;
    }

    public int getPortalCooldown() {
        return Integer.MAX_VALUE;
    }

    public boolean shouldRender(double x, double y, double z) {
        return true;
    }

    protected void readAdditionalSaveData(CompoundTag compoundTag) {
        if (compoundTag.contains("disappearingTime")) {
            this.disappearingTime = compoundTag.getInt("disappearingTime");
        }
        this.setDisappearingMarker(compoundTag.getBoolean("disappearingMarker"));
        if (compoundTag.contains("essenceController")) {
            this.setEssenceController(compoundTag.getUUID("essenceController"));
        }
        if (compoundTag.contains("essenceControllerBlockPos")) {
            NbtUtils.readBlockPos((CompoundTag)compoundTag, (String)"essenceControllerBlockPos").ifPresent(this::setEssenceControllerBlockPos);
        }
        if (compoundTag.contains("essenceControllerDimension")) {
            this.setEssenceControllerDimension((ResourceKey<Level>)ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)ResourceLocation.tryParse((String)compoundTag.getString("essenceControllerDimension"))));
        }
    }

    protected void addAdditionalSaveData(CompoundTag compoundTag) {
        compoundTag.putInt("disappearingTime", this.disappearingTime);
        compoundTag.putBoolean("disappearingMarker", this.getDisappearingMarker());
        if (this.getEssenceController() != null) {
            compoundTag.putUUID("essenceController", this.getEssenceController());
        }
        if (this.getEssenceControllerBlockPos() != null) {
            compoundTag.put("essenceControllerBlockPos", NbtUtils.writeBlockPos((BlockPos)this.getEssenceControllerBlockPos()));
        }
        if (this.getEssenceControllerDimension() != null) {
            compoundTag.putString("essenceControllerDimension", this.getEssenceControllerDimension().location().toString());
        }
    }

    public void recreateFromPacket(ClientboundAddEntityPacket clientboundAddEntityPacket) {
        double d = clientboundAddEntityPacket.getX();
        double e = clientboundAddEntityPacket.getY();
        double f = clientboundAddEntityPacket.getZ();
        float g = clientboundAddEntityPacket.getYRot();
        float h = clientboundAddEntityPacket.getXRot();
        this.syncPacketPositionCodec(d, e, f);
        this.setId(clientboundAddEntityPacket.getId());
        this.setUUID(clientboundAddEntityPacket.getUUID());
        this.absMoveTo(d, e, f, g, h);
        this.setDeltaMovement(clientboundAddEntityPacket.getXa(), clientboundAddEntityPacket.getYa(), clientboundAddEntityPacket.getZa());
    }
}

