/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.entities.mobs;

import com.telepathicgrunt.the_bumblezone.advancements.GenericTrigger;
import com.telepathicgrunt.the_bumblezone.entities.BeeAggression;
import com.telepathicgrunt.the_bumblezone.entities.goals.RootminAngryGoal;
import com.telepathicgrunt.the_bumblezone.entities.goals.RootminAntiGoal;
import com.telepathicgrunt.the_bumblezone.entities.goals.RootminAvoidEntityGoal;
import com.telepathicgrunt.the_bumblezone.entities.goals.RootminCuriosityGoal;
import com.telepathicgrunt.the_bumblezone.entities.goals.RootminEmbarrassedCurseGoal;
import com.telepathicgrunt.the_bumblezone.entities.goals.RootminHiddenGoal;
import com.telepathicgrunt.the_bumblezone.entities.goals.RootminHideGoal;
import com.telepathicgrunt.the_bumblezone.entities.goals.RootminHurtByTargetGoal;
import com.telepathicgrunt.the_bumblezone.entities.goals.RootminNearestAttackableTargetGoal;
import com.telepathicgrunt.the_bumblezone.entities.goals.RootminRangedAttackGoal;
import com.telepathicgrunt.the_bumblezone.entities.mobs.RootminState;
import com.telepathicgrunt.the_bumblezone.entities.nonliving.DirtPelletEntity;
import com.telepathicgrunt.the_bumblezone.items.BeeArmor;
import com.telepathicgrunt.the_bumblezone.items.FlowerHeadwearHelmet;
import com.telepathicgrunt.the_bumblezone.items.essence.EssenceOfTheBees;
import com.telepathicgrunt.the_bumblezone.modinit.BzCriterias;
import com.telepathicgrunt.the_bumblezone.modinit.BzParticles;
import com.telepathicgrunt.the_bumblezone.modinit.BzSounds;
import com.telepathicgrunt.the_bumblezone.modinit.BzTags;
import com.telepathicgrunt.the_bumblezone.utils.EnchantmentUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.OldUsersConverter;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.level.portal.DimensionTransition;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.scores.PlayerTeam;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class RootminEntity
extends PathfinderMob
implements Enemy,
OwnableEntity {
    private static final EntityDataAccessor<Optional<BlockState>> FLOWER_BLOCK_STATE = SynchedEntityData.defineId(RootminEntity.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_BLOCK_STATE);
    public static final EntityDataSerializer<RootminState> ROOTMIN_POSE_SERIALIZER = EntityDataSerializer.forValueType(RootminState.STREAM_CODEC);
    private static final EntityDataAccessor<RootminState> ROOTMIN_POSE = SynchedEntityData.defineId(RootminEntity.class, ROOTMIN_POSE_SERIALIZER);
    private static final EntityDataAccessor<Boolean> ROOTMIN_SHIELD = SynchedEntityData.defineId(RootminEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    protected static final EntityDataAccessor<Optional<UUID>> OWNER_UUID = SynchedEntityData.defineId(RootminEntity.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_UUID);
    public final AnimationState idleAnimationState = new AnimationState();
    public final AnimationState angryAnimationState = new AnimationState();
    public final AnimationState curiousAnimationState = new AnimationState();
    public final AnimationState curseAnimationState = new AnimationState();
    public final AnimationState embarassedAnimationState = new AnimationState();
    public final AnimationState shockAnimationState = new AnimationState();
    public final AnimationState shootAnimationState = new AnimationState();
    public final AnimationState runAnimationState = new AnimationState();
    public final AnimationState walkAnimationState = new AnimationState();
    public final AnimationState blockToEntityAnimationState = new AnimationState();
    public final AnimationState entityToBlockAnimationState = new AnimationState();
    private boolean checkedDefaultFlowerTag = false;
    public boolean isHidden = false;
    public boolean disableAttackGoals = false;
    public RootminEntity rootminToLookAt = null;
    public LivingEntity attackerMemory = null;
    public UUID superHatedPlayer = null;
    private int delayTillIdle = -1;
    public boolean takePotShot = false;
    public int exposedTimer = 0;
    public int curiosityCooldown = 60;
    public int stayHidingTimer = 200;
    private UUID essenceController = null;
    private BlockPos essenceControllerBlockPos = null;
    private ResourceKey<Level> essenceControllerDimension = null;
    public int animationTimeBetweenHiding = 0;
    public static final Set<RootminState> POSES_THAT_CANT_BE_MOTION_INTERRUPTED = Set.of(RootminState.ANGRY, RootminState.CURIOUS, RootminState.CURSE, RootminState.EMBARRASSED, RootminState.SHOOT, RootminState.SHOCK, RootminState.BLOCK_TO_ENTITY, RootminState.ENTITY_TO_BLOCK);
    public static final Set<RootminState> POSES_THAT_CAN_BE_FEAR_INTERRUPTED = Set.of(RootminState.ANGRY, RootminState.CURIOUS, RootminState.CURSE, RootminState.EMBARRASSED, RootminState.SHOCK);

    public RootminEntity(EntityType<? extends RootminEntity> type, Level worldIn) {
        super(type, worldIn);
        this.getFlowerBlock();
        this.setAnimationState(this.getRootminPose(), RootminState.NONE, this.idleAnimationState);
        this.refreshDimensions();
    }

    public void setFlowerBlock(@Nullable BlockState blockState) {
        this.entityData.set(FLOWER_BLOCK_STATE, Optional.ofNullable(blockState));
    }

    @Nullable
    public BlockState getFlowerBlock() {
        return ((Optional)this.entityData.get(FLOWER_BLOCK_STATE)).orElse(null);
    }

    @Nullable
    private BlockState getFlowerOrSetIfMissing(LevelAccessor level, BlockState state) {
        if (state == null && !level.isClientSide() && !this.checkedDefaultFlowerTag) {
            TagKey<Block> blockTag = level.getBiomeManager().getNoiseBiomeAtPosition(this.blockPosition()).is(ResourceLocation.fromNamespaceAndPath((String)"the_bumblezone", (String)"floral_meadow")) ? BzTags.ROOTMIN_FLORAL_MEADOW_FLOWERS : BzTags.ROOTMIN_DEFAULT_FLOWERS;
            List blockList = BuiltInRegistries.BLOCK.getTag(blockTag).map(holders -> holders.stream().map(Holder::value).toList()).orElseGet(ArrayList::new);
            BlockState blockState = state = blockList.isEmpty() ? null : ((Block)blockList.get(this.getRandom().nextInt(blockList.size()))).defaultBlockState();
            if (state != null && state.isAir()) {
                state = null;
            }
            this.setFlowerBlock(state);
            this.checkedDefaultFlowerTag = true;
        }
        return state;
    }

    public UUID getEssenceController() {
        return this.essenceController;
    }

    public void setEssenceController(UUID essenceController) {
        this.essenceController = essenceController;
    }

    public BlockPos getEssenceControllerBlockPos() {
        return this.essenceControllerBlockPos;
    }

    public void setEssenceControllerBlockPos(BlockPos essenceControllerBlockPos) {
        this.essenceControllerBlockPos = essenceControllerBlockPos;
    }

    public ResourceKey<Level> getEssenceControllerDimension() {
        return this.essenceControllerDimension;
    }

    public void setEssenceControllerDimension(ResourceKey<Level> essenceControllerDimension) {
        this.essenceControllerDimension = essenceControllerDimension;
    }

    public void setRootminPose(RootminState rootminState) {
        this.entityData.set(ROOTMIN_POSE, (Object)rootminState);
    }

    public RootminState getRootminPose() {
        return (RootminState)((Object)this.entityData.get(ROOTMIN_POSE));
    }

    public void setRootminShield(boolean hasShield) {
        this.entityData.set(ROOTMIN_SHIELD, (Object)hasShield);
    }

    public boolean getRootminShield() {
        return (Boolean)this.entityData.get(ROOTMIN_SHIELD);
    }

    @Nullable
    public UUID getOwnerUUID() {
        return ((Optional)this.entityData.get(OWNER_UUID)).orElse(null);
    }

    public void setOwnerUUID(@Nullable UUID uUID) {
        this.entityData.set(OWNER_UUID, Optional.ofNullable(uUID));
    }

    public void runAngry() {
        if (this.getRootminPose() != RootminState.ANGRY) {
            this.playSound((SoundEvent)BzSounds.ROOTMIN_ANGRY.get(), 1.0f, this.getRandom().nextFloat() * 0.2f + 0.8f);
        }
        this.delayTillIdle = 80;
        this.setRootminPose(RootminState.ANGRY);
    }

    public void runCurious() {
        if (this.getRootminPose() != RootminState.CURIOUS) {
            this.playSound((SoundEvent)BzSounds.ROOTMIN_CURIOUS.get(), 1.0f, this.getRandom().nextFloat() * 0.2f + 0.8f);
        }
        this.delayTillIdle = 28;
        this.setRootminPose(RootminState.CURIOUS);
    }

    public void runCurse() {
        if (this.getRootminPose() != RootminState.CURSE) {
            this.playSound((SoundEvent)BzSounds.ROOTMIN_CURSING.get(), 1.0f, this.getRandom().nextFloat() * 0.2f + 0.8f);
        }
        this.delayTillIdle = 40;
        this.setRootminPose(RootminState.CURSE);
    }

    public void runEmbarrassed() {
        if (this.getRootminPose() != RootminState.EMBARRASSED) {
            this.playSound((SoundEvent)BzSounds.ROOTMIN_EMBARRASSED.get(), 1.0f, this.getRandom().nextFloat() * 0.2f + 0.8f);
        }
        this.delayTillIdle = 60;
        this.setRootminPose(RootminState.EMBARRASSED);
    }

    public void runShock() {
        if (this.getRootminPose() != RootminState.SHOCK) {
            this.playSound((SoundEvent)BzSounds.ROOTMIN_SHOCK.get(), 1.0f, this.getRandom().nextFloat() * 0.2f + 0.8f);
        }
        this.delayTillIdle = 10;
        this.setRootminPose(RootminState.SHOCK);
    }

    public void runShoot(@Nullable LivingEntity target, float speedMultiplier, boolean isHoming) {
        if (isHoming && target != null) {
            this.shootHomingDirt(target, speedMultiplier);
        } else {
            this.shootDirt(target, speedMultiplier);
        }
        this.delayTillIdle = 8;
        this.setRootminPose(RootminState.SHOOT);
    }

    public void runMultiShoot(@Nullable LivingEntity target, float speedMultiplier, int projectiles) {
        this.shootDirt(target, speedMultiplier, projectiles);
        this.delayTillIdle = 8;
        this.setRootminPose(RootminState.SHOOT);
    }

    public void exposeFromBlock() {
        this.isHidden = false;
        this.delayTillIdle = 20;
        this.animationTimeBetweenHiding = 20;
        this.setRootminPose(RootminState.BLOCK_TO_ENTITY);
    }

    public void hideAsBlock(Vec3 destination) {
        this.isHidden = true;
        this.delayTillIdle = -1;
        this.animationTimeBetweenHiding = 20;
        this.setRootminPose(RootminState.ENTITY_TO_BLOCK);
        this.getNavigation().stop();
        if (destination != null && this.position().subtract(destination).length() < 1.0) {
            this.moveTo(destination);
        } else {
            this.moveTo(Vec3.atCenterOf((Vec3i)this.blockPosition()));
        }
        this.setDeltaMovement(Vec3.ZERO);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new RootminAntiGoal(this));
        this.goalSelector.addGoal(2, (Goal)new RootminAngryGoal(this));
        this.goalSelector.addGoal(3, (Goal)new RootminEmbarrassedCurseGoal(this));
        this.goalSelector.addGoal(4, (Goal)new RootminCuriosityGoal(this));
        this.goalSelector.addGoal(5, (Goal)new RootminHiddenGoal(this));
        this.goalSelector.addGoal(6, (Goal)new RootminAvoidEntityGoal(this, BzTags.ROOTMIN_PANIC_AVOID, 24.0f, 1.75, 2.5));
        this.goalSelector.addGoal(7, (Goal)new RootminHideGoal(this));
        this.goalSelector.addGoal(8, (Goal)new RootminRangedAttackGoal(this, 1.25, 20, 15, 30.0f));
        this.targetSelector.addGoal(9, (Goal)new RootminHurtByTargetGoal(this));
        this.targetSelector.addGoal(10, (Goal)new RootminNearestAttackableTargetGoal((Mob)this, true));
    }

    public static AttributeSupplier.Builder getAttributeBuilder() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 10.0).add(Attributes.MOVEMENT_SPEED, 0.18).add(Attributes.ATTACK_DAMAGE, 3.0).add(Attributes.FOLLOW_RANGE, 30.0).add(Attributes.STEP_HEIGHT, 1.0);
    }

    public void addAdditionalSaveData(CompoundTag compoundTag) {
        super.addAdditionalSaveData(compoundTag);
        BlockState blockState = this.getFlowerBlock();
        if (blockState != null) {
            compoundTag.put("flowerBlock", (Tag)NbtUtils.writeBlockState((BlockState)blockState));
        }
        compoundTag.putBoolean("hidden", this.isHidden);
        compoundTag.putInt("delayTillIdle", this.delayTillIdle);
        compoundTag.putString("animationState", this.getRootminPose().name());
        if (this.superHatedPlayer != null) {
            compoundTag.putUUID("superHatedPlayer", this.superHatedPlayer);
        }
        if (this.getEssenceController() != null) {
            compoundTag.putUUID("essenceController", this.getEssenceController());
        }
        if (this.getEssenceControllerBlockPos() != null) {
            compoundTag.put("essenceControllerBlockPos", NbtUtils.writeBlockPos((BlockPos)this.getEssenceControllerBlockPos()));
        }
        if (this.getEssenceControllerDimension() != null) {
            compoundTag.putString("essenceControllerDimension", this.getEssenceControllerDimension().location().toString());
        }
        if (this.getOwnerUUID() != null) {
            compoundTag.putUUID("Owner", this.getOwnerUUID());
        }
    }

    public void readAdditionalSaveData(CompoundTag compoundTag) {
        UUID uUID;
        super.readAdditionalSaveData(compoundTag);
        BlockState blockState = null;
        if (compoundTag.contains("flowerBlock", 10) && (blockState = NbtUtils.readBlockState((HolderGetter)this.level().holderLookup(Registries.BLOCK), (CompoundTag)compoundTag.getCompound("flowerBlock"))).isAir()) {
            blockState = null;
        }
        if (blockState == null) {
            this.getFlowerBlock();
        } else {
            this.setFlowerBlock(blockState);
        }
        this.isHidden = compoundTag.getBoolean("hidden");
        this.delayTillIdle = compoundTag.getInt("delayTillIdle");
        if (compoundTag.contains("superHatedPlayer")) {
            this.superHatedPlayer = compoundTag.getUUID("superHatedPlayer");
        }
        if (this.isHidden) {
            this.setRootminPose(RootminState.ENTITY_TO_BLOCK);
        } else if (compoundTag.contains("animationState")) {
            this.setRootminPose(RootminState.valueOf(compoundTag.getString("animationState")));
        }
        if (compoundTag.contains("essenceController")) {
            this.setEssenceController(compoundTag.getUUID("essenceController"));
        }
        if (compoundTag.contains("essenceControllerBlockPos")) {
            NbtUtils.readBlockPos((CompoundTag)compoundTag, (String)"essenceControllerBlockPos").ifPresent(this::setEssenceControllerBlockPos);
        }
        if (compoundTag.contains("essenceControllerDimension")) {
            this.setEssenceControllerDimension((ResourceKey<Level>)ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)ResourceLocation.tryParse((String)compoundTag.getString("essenceControllerDimension"))));
        }
        if (compoundTag.hasUUID("Owner")) {
            uUID = compoundTag.getUUID("Owner");
        } else {
            String string = compoundTag.getString("Owner");
            uUID = OldUsersConverter.convertMobOwnerIfNecessary((MinecraftServer)this.getServer(), (String)string);
        }
        if (uUID != null) {
            this.setOwnerUUID(uUID);
        }
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType reason, SpawnGroupData spawnData) {
        spawnData = super.finalizeSpawn(level, difficulty, reason, spawnData);
        BlockState state = this.getFlowerBlock();
        this.getFlowerOrSetIfMissing((LevelAccessor)level, state);
        return spawnData;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(FLOWER_BLOCK_STATE, Optional.empty());
        builder.define(ROOTMIN_POSE, (Object)RootminState.NONE);
        builder.define(ROOTMIN_SHIELD, (Object)false);
        builder.define(OWNER_UUID, Optional.empty());
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> entityDataAccessor) {
        if (ROOTMIN_POSE.equals(entityDataAccessor)) {
            RootminState pose = this.getRootminPose();
            if (pose == RootminState.BLOCK_TO_ENTITY || pose == RootminState.ENTITY_TO_BLOCK) {
                this.animationTimeBetweenHiding = 20;
            }
            this.setAnimationState(pose, RootminState.NONE, this.idleAnimationState, this.tickCount - 27);
            this.setAnimationState(pose, RootminState.ANGRY, this.angryAnimationState, (ParticleOptions)BzParticles.ANGRY_PARTICLE.get(), 75, 1.0);
            this.setAnimationState(pose, RootminState.CURIOUS, this.curiousAnimationState, (ParticleOptions)BzParticles.CURIOUS_PARTICLE.get(), 23, 1.0);
            this.setAnimationState(pose, RootminState.CURSE, this.curseAnimationState, (ParticleOptions)BzParticles.CURSING_PARTICLE.get(), 35, 1.0);
            this.setAnimationState(pose, RootminState.EMBARRASSED, this.embarassedAnimationState, (ParticleOptions)BzParticles.EMBARRASSED_PARTICLE.get(), 55, 1.0);
            this.setAnimationState(pose, RootminState.SHOCK, this.shockAnimationState);
            this.setAnimationState(pose, RootminState.SHOOT, this.shootAnimationState);
            this.setAnimationState(pose, RootminState.RUN, this.runAnimationState);
            this.setAnimationState(pose, RootminState.WALK, this.walkAnimationState);
            this.setAnimationState(pose, RootminState.BLOCK_TO_ENTITY, this.blockToEntityAnimationState);
            this.setAnimationState(pose, RootminState.ENTITY_TO_BLOCK, this.entityToBlockAnimationState, this.tickCount <= 2 ? -100000 : this.tickCount);
        }
        super.onSyncedDataUpdated(entityDataAccessor);
    }

    private void setAnimationState(RootminState pose, RootminState poseToCheckFor, AnimationState animationState) {
        this.setAnimationState(pose, poseToCheckFor, animationState, null, 0, 0.0);
    }

    private void setAnimationState(RootminState pose, RootminState poseToCheckFor, AnimationState animationState, int tickCount) {
        this.setAnimationState(pose, poseToCheckFor, animationState, tickCount, null, 0, 0.0);
    }

    private void setAnimationState(RootminState pose, RootminState poseToCheckFor, AnimationState animationState, ParticleOptions particleType, int particleLifeSpan, double yOffset) {
        this.setAnimationState(pose, poseToCheckFor, animationState, this.tickCount, particleType, particleLifeSpan, yOffset);
    }

    private void setAnimationState(RootminState pose, RootminState poseToCheckFor, AnimationState animationState, int tickCount, ParticleOptions particleType, int particleLifeSpan, double yOffset) {
        if (pose == poseToCheckFor) {
            if (!animationState.isStarted()) {
                Level level;
                animationState.start(tickCount);
                if (particleType != null && (level = this.level()) instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    serverLevel.sendParticles(particleType, this.getX(), this.getBoundingBox().maxY + yOffset, this.getZ(), 0, 1.0, 1.0, 1.0, (double)particleLifeSpan);
                }
            }
        } else {
            animationState.stop();
        }
    }

    public boolean checkSpawnRules(LevelAccessor world, MobSpawnType spawnReason) {
        return true;
    }

    public void remove(Entity.RemovalReason removalReason) {
        super.remove(removalReason);
    }

    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        if (hand != InteractionHand.MAIN_HAND) {
            return InteractionResult.PASS;
        }
        ItemStack itemstack = player.getItemInHand(hand);
        boolean instantBuild = player.getAbilities().instabuild;
        Item item = itemstack.getItem();
        if (item instanceof BlockItem) {
            BlockState blockState;
            ServerPlayer serverPlayer;
            BlockItem blockItem = (BlockItem)item;
            if ((instantBuild || player instanceof ServerPlayer && EssenceOfTheBees.hasEssence(serverPlayer = (ServerPlayer)player) || BeeArmor.getBeeThemedWearablesCount((Entity)player) > 0 || !FlowerHeadwearHelmet.getFlowerHeadwear((LivingEntity)player).isEmpty()) && (blockState = blockItem.getBlock().defaultBlockState()).is(BzTags.ROOTMIN_ALLOWED_FLOWERS) && !blockState.is(BzTags.ROOTMIN_FORCED_DISALLOWED_FLOWERS) && (this.getFlowerBlock() == null || this.getFlowerBlock() != blockState)) {
                if (!this.level().isClientSide()) {
                    if (!instantBuild && this.getFlowerBlock() != null) {
                        ItemStack itemStack = new ItemStack((ItemLike)Items.DIAMOND_PICKAXE);
                        itemStack.enchant(EnchantmentUtils.getEnchantmentHolder((ResourceKey<Enchantment>)Enchantments.SILK_TOUCH, this.level()), 1);
                        LootParams.Builder builder = new LootParams.Builder((ServerLevel)this.level()).withParameter(LootContextParams.ORIGIN, (Object)this.position()).withParameter(LootContextParams.TOOL, (Object)itemStack).withOptionalParameter(LootContextParams.THIS_ENTITY, (Object)this);
                        List flowerDrops = this.getFlowerBlock().getDrops(builder);
                        for (ItemStack flowerDrop : flowerDrops) {
                            this.spawnAtLocation(flowerDrop, 1.0f);
                        }
                    }
                    if (blockState.getBlock() instanceof DoublePlantBlock) {
                        blockState.setValue((Property)DoublePlantBlock.HALF, (Comparable)DoubleBlockHalf.LOWER);
                    }
                    int shrinkAmount = 1;
                    if (blockState.hasProperty((Property)BlockStateProperties.FLOWER_AMOUNT)) {
                        shrinkAmount = Math.min(Math.max(1, itemstack.getCount()), 4);
                        blockState = (BlockState)blockState.setValue((Property)BlockStateProperties.FLOWER_AMOUNT, (Comparable)Integer.valueOf(shrinkAmount));
                    }
                    this.setFlowerBlock(blockState);
                    player.awardStat(Stats.ITEM_USED.get((Object)itemstack.getItem()));
                    if (!instantBuild) {
                        itemstack.shrink(shrinkAmount);
                    }
                    if (player instanceof ServerPlayer) {
                        ServerPlayer serverPlayer2 = (ServerPlayer)player;
                        ((GenericTrigger)((Object)BzCriterias.ROOTMIN_FLOWER_SWAP_TRIGGER.get())).trigger(serverPlayer2);
                    }
                }
                return InteractionResult.SUCCESS;
            }
        }
        return super.mobInteract(player, hand);
    }

    public void shootHomingDirt(LivingEntity livingEntity, float speedMultiplier) {
        if (!this.level().isClientSide()) {
            DirtPelletEntity pelletEntity = new DirtPelletEntity(this.level(), (LivingEntity)this);
            if (this.getEssenceController() != null) {
                pelletEntity.setEventBased(true);
            }
            pelletEntity.setHoming(true);
            pelletEntity.setHomingTargetUUID(livingEntity.getUUID());
            double x = livingEntity.getX() - this.getX();
            double heightBasedOffset = 1.6 + 0.2 * ((double)livingEntity.getBbHeight() / 1.8);
            double y = livingEntity.getY() + heightBasedOffset * (1.333333 - (double)speedMultiplier) - pelletEntity.getY();
            double z = livingEntity.getZ() - this.getZ();
            double archOffset = Math.sqrt(x * x + z * z);
            Vec3 lookAngle = this.getLookAngle();
            pelletEntity.shoot(lookAngle.x(), y + archOffset * 0.01, lookAngle.z(), 1.5f * speedMultiplier, 1.0f);
            this.playSound((SoundEvent)BzSounds.ROOTMIN_SHOOT.get(), 1.0f, this.getRandom().nextFloat() * 0.2f + 0.8f);
            this.level().addFreshEntity((Entity)pelletEntity);
        }
    }

    public void shootDirt(@Nullable LivingEntity livingEntity) {
        this.shootDirt(livingEntity, 1.0f);
    }

    public void shootDirt(@Nullable LivingEntity livingEntity, float speedMultiplier) {
        this.shootDirt(livingEntity, speedMultiplier, 1);
    }

    public void shootDirt(@Nullable LivingEntity livingEntity, float speedMultiplier, int totalProjectiles) {
        if (!this.level().isClientSide()) {
            for (int currentProjectile = 0; currentProjectile < totalProjectiles; ++currentProjectile) {
                Vec3 shootAngle;
                Vec3 viewVector = this.getViewVector(1.0f);
                DirtPelletEntity pelletEntity = new DirtPelletEntity(this.level(), (LivingEntity)this);
                pelletEntity.setPos(pelletEntity.position().add(viewVector.x(), 0.0, viewVector.z()));
                if (this.getEssenceController() != null) {
                    pelletEntity.setEventBased(true);
                }
                if (livingEntity != null) {
                    double x = livingEntity.getX() - this.getX();
                    double y = livingEntity.getY(1.1 - (double)(speedMultiplier * speedMultiplier) * 0.975) - pelletEntity.getY() - (1.5 - (double)livingEntity.getBbHeight());
                    double z = livingEntity.getZ() - this.getZ();
                    shootAngle = new Vec3(x, y, z);
                } else {
                    double defaultSpeed = 5.0;
                    double x = viewVector.x() * defaultSpeed;
                    double y = 0.3333333333333333;
                    double z = viewVector.z() * defaultSpeed;
                    shootAngle = new Vec3(x, y, z);
                }
                double archOffset = Math.sqrt(shootAngle.x() * shootAngle.x() + shootAngle.z() * shootAngle.z());
                Vec3 vec3 = this.getUpVector(1.0f);
                int angle = (currentProjectile - (int)((float)totalProjectiles / 2.0f)) * 3;
                Quaternionf quaternionf = new Quaternionf().setAngleAxis((double)((float)angle * ((float)Math.PI / 180)), vec3.x, vec3.y, vec3.z);
                Vector3f rotatedShootAngle = shootAngle.toVector3f().rotate((Quaternionfc)quaternionf);
                pelletEntity.shoot(rotatedShootAngle.x(), (double)rotatedShootAngle.y() + archOffset * 0.2 * (double)(currentProjectile != 1 ? 1.4f : 1.0f), rotatedShootAngle.z(), 1.5f * speedMultiplier * (currentProjectile != 1 ? 0.75f : 1.0f), 1.0f);
                this.playSound((SoundEvent)BzSounds.ROOTMIN_SHOOT.get(), 1.0f, this.getRandom().nextFloat() * 0.2f + 0.8f);
                this.level().addFreshEntity((Entity)pelletEntity);
            }
        }
    }

    public boolean isInvulnerableTo(DamageSource damageSource) {
        if (this.getRootminShield()) {
            return true;
        }
        if (this.getEssenceController() != null) {
            Entity entity = damageSource.getDirectEntity();
            if (entity instanceof DirtPelletEntity) {
                ServerPlayer serverPlayer;
                DirtPelletEntity dirtPelletEntity = (DirtPelletEntity)entity;
                if (dirtPelletEntity.isEventBased()) {
                    return super.isInvulnerableTo(damageSource);
                }
                Entity entity2 = dirtPelletEntity.getOwner();
                if (entity2 instanceof ServerPlayer && EssenceOfTheBees.hasEssence(serverPlayer = (ServerPlayer)entity2) && this.getRootminPose() != RootminState.ANGRY && this.getRootminPose() != RootminState.CURSE && this.getRootminPose() != RootminState.SHOCK && this.hurtTime == 0) {
                    return super.isInvulnerableTo(damageSource);
                }
            }
            return true;
        }
        return super.isInvulnerableTo(damageSource);
    }

    public void tick() {
        Level level;
        BlockState state = this.getFlowerBlock();
        this.getFlowerOrSetIfMissing((LevelAccessor)this.level(), state);
        super.tick();
        if (this.hurtTime == 9 && !this.level().isClientSide()) {
            this.isHidden = false;
            if (this.getRootminPose() != RootminState.CURSE && this.getRootminPose() != RootminState.SHOCK) {
                this.runShock();
            }
        }
        if (!this.level().isClientSide()) {
            double horizontalSpeed = this.getDeltaMovement().horizontalDistance();
            if (!POSES_THAT_CANT_BE_MOTION_INTERRUPTED.contains((Object)this.getRootminPose())) {
                if (horizontalSpeed > 0.2 || this.hurtTime > 0) {
                    this.setRootminPose(RootminState.RUN);
                } else if (horizontalSpeed > 0.01) {
                    this.setRootminPose(RootminState.WALK);
                }
            }
            if (this.getRootminPose() == RootminState.ENTITY_TO_BLOCK && this.curiosityCooldown >= 0) {
                --this.curiosityCooldown;
            }
            if (this.delayTillIdle >= 0) {
                if (this.delayTillIdle == 0) {
                    this.setRootminPose(RootminState.NONE);
                }
                --this.delayTillIdle;
            } else if (!this.isHidden && this.getRootminPose() != RootminState.NONE && this.isAlive() && horizontalSpeed <= 0.01) {
                this.setRootminPose(RootminState.NONE);
            }
        }
        if (this.animationTimeBetweenHiding > 0) {
            --this.animationTimeBetweenHiding;
            if (this.getRootminPose() == RootminState.BLOCK_TO_ENTITY || this.getRootminPose() == RootminState.ENTITY_TO_BLOCK) {
                this.refreshDimensions();
            }
        }
        if ((level = this.level()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (this.getRootminPose() == RootminState.SHOCK && this.delayTillIdle == 8) {
                serverLevel.sendParticles((ParticleOptions)((SimpleParticleType)BzParticles.SHOCK_PARTICLE.get()), this.getX(), this.getBoundingBox().maxY + 1.5, this.getZ(), 0, 1.0, 1.0, 1.0, 8.0);
            }
        } else if (this.getRootminPose() == RootminState.ENTITY_TO_BLOCK && this.animationTimeBetweenHiding == 0 && this.yHeadRotO % 90.0f != 0.0f && this.yHeadRot % 90.0f != 0.0f && this.yBodyRotO % 90.0f != 0.0f && this.yBodyRot % 90.0f != 0.0f && !this.isPassenger()) {
            float closestDir;
            Vec3 lookDirection = this.getLookAngle();
            this.yHeadRotO = closestDir = Direction.getNearest((double)lookDirection.x(), (double)lookDirection.y(), (double)lookDirection.z()).toYRot();
            this.yHeadRot = closestDir;
            this.yBodyRotO = closestDir;
            this.yBodyRot = closestDir;
        }
    }

    public void aiStep() {
        super.aiStep();
        if (this.isAlive() && (this.getRootminPose() == RootminState.WALK || this.getRootminPose() == RootminState.RUN)) {
            Vec3 frontPos = this.position().add(Vec3.atLowerCornerOf((Vec3i)this.getDirection().getNormal()));
            List list = this.level().getEntitiesOfClass(RootminEntity.class, this.getBoundingBox().inflate(0.3), rootmin -> rootmin != this && rootmin.getRootminPose() == RootminState.ENTITY_TO_BLOCK && rootmin.position().closerThan((Position)frontPos, 1.3) && rootmin.getY() - this.position().y() >= -0.5);
            if (!list.isEmpty() && this.onGround()) {
                this.jumpFromGround();
            }
        }
    }

    protected void customServerAiStep() {
        if (this.exposedTimer > 0) {
            --this.exposedTimer;
        }
    }

    protected void dropAllDeathLoot(ServerLevel level, DamageSource damageSource) {
        RootminEntity sourceEntity;
        BlockState flower = this.getFlowerBlock();
        RootminEntity rootminEntity = sourceEntity = damageSource.getEntity() == null ? this : damageSource.getEntity();
        if (flower != null) {
            ItemStack itemStack = new ItemStack((ItemLike)Items.DIAMOND_PICKAXE);
            itemStack.enchant(EnchantmentUtils.getEnchantmentHolder((ResourceKey<Enchantment>)Enchantments.SILK_TOUCH, (Level)level), 1);
            LootParams.Builder builder = new LootParams.Builder((ServerLevel)this.level()).withParameter(LootContextParams.ORIGIN, (Object)this.position()).withParameter(LootContextParams.TOOL, (Object)itemStack).withOptionalParameter(LootContextParams.THIS_ENTITY, (Object)sourceEntity);
            List flowerDrops = flower.getDrops(builder);
            for (ItemStack flowerDrop : flowerDrops) {
                this.spawnAtLocation(flowerDrop, 0.5f);
            }
        }
        super.dropAllDeathLoot(level, damageSource);
    }

    public boolean canBeCollidedWith() {
        return this.getRootminPose() == RootminState.ENTITY_TO_BLOCK && !this.isDeadOrDying();
    }

    protected AABB makeBoundingBox() {
        if (this.getRootminPose() == RootminState.BLOCK_TO_ENTITY || this.getRootminPose() == RootminState.ENTITY_TO_BLOCK) {
            AABB currentAABB = super.makeBoundingBox();
            float target = this.getRootminPose() == RootminState.BLOCK_TO_ENTITY ? 1.56f : 1.0f;
            float from = this.getRootminPose() == RootminState.BLOCK_TO_ENTITY ? 1.0f : 1.56f;
            float percentage = (20.0f - (float)this.animationTimeBetweenHiding) / 20.0f;
            currentAABB = currentAABB.setMaxY(Mth.lerp((double)percentage, (double)((double)from + currentAABB.minY), (double)((double)target + currentAABB.minY)));
            return currentAABB;
        }
        return super.makeBoundingBox();
    }

    protected EntityDimensions getDefaultDimensions(Pose pose) {
        EntityDimensions defaultDimensions = super.getDefaultDimensions(pose);
        return defaultDimensions.withEyeHeight(defaultDimensions.height() - 0.575f).scale(this.getScale());
    }

    public void refreshDimensions() {
        double x = this.getX();
        double y = this.getY();
        double z = this.getZ();
        super.refreshDimensions();
        this.absMoveTo(x, y, z);
    }

    public boolean canChangeDimensions(Level fromLevel, Level toLevel) {
        return super.canChangeDimensions(fromLevel, toLevel) && this.getEssenceController() == null;
    }

    public Entity changeDimension(DimensionTransition dimensionTransition) {
        if (this.getEssenceController() != null) {
            return this;
        }
        return super.changeDimension(dimensionTransition);
    }

    public int getPortalCooldown() {
        return this.getEssenceController() == null ? super.getPortalCooldown() : Integer.MAX_VALUE;
    }

    protected boolean shouldDropLoot() {
        return this.getEssenceController() == null || this.getLastDamageSource() != null && this.getLastDamageSource().getDirectEntity() instanceof DirtPelletEntity;
    }

    public boolean canBeLeashed() {
        return false;
    }

    public float getSoundVolume() {
        return 0.4f * (float)(this.isBaby() ? 1 : 2);
    }

    public int getMaxHeadXRot() {
        return 0;
    }

    protected SoundEvent getHurtSound(DamageSource damageSourceIn) {
        return (SoundEvent)BzSounds.ROOTMIN_SHOCK.get();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)BzSounds.ROOTMIN_SHOCK.get();
    }

    public SoundSource getSoundSource() {
        return SoundSource.HOSTILE;
    }

    public static boolean isFacingMob(RootminEntity rootminEntity, LivingEntity target) {
        Vec3 targetView = target.getLookAngle().normalize();
        Vec3 currentDirection = rootminEntity.position().subtract(target.position()).normalize();
        double dotProduct = currentDirection.x() * targetView.x() + currentDirection.y() * targetView.y() + currentDirection.z() * targetView.z();
        return dotProduct >= 0.0;
    }

    public boolean canTarget(LivingEntity livingEntity) {
        boolean canTarget;
        block10: {
            block11: {
                if (livingEntity.getType().is(BzTags.ROOTMIN_FORCED_DO_NOT_TARGET)) {
                    return false;
                }
                if (this.getOwnerUUID() == null || livingEntity.getType().getCategory() != MobCategory.MONSTER) break block10;
                if (!(livingEntity instanceof OwnableEntity)) break block11;
                OwnableEntity ownableEntity = (OwnableEntity)livingEntity;
                if (this.getOwnerUUID().equals(ownableEntity.getOwnerUUID())) break block10;
            }
            return true;
        }
        boolean bl = canTarget = BeeAggression.doesBeesHateEntity((Entity)livingEntity) || livingEntity.getType().is(BzTags.ROOTMIN_TARGETS);
        if (canTarget && livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (this.isOwnedBy((LivingEntity)player)) {
                return false;
            }
            if (player.isCreative() || player.isSpectator() || player.isDeadOrDying()) {
                if (player.getUUID().equals(this.superHatedPlayer)) {
                    this.superHatedPlayer = null;
                }
                return false;
            }
            if (player.getUUID().equals(this.superHatedPlayer)) {
                this.stayHidingTimer = 0;
                return true;
            }
            if (BeeArmor.getBeeThemedWearablesCount((Entity)player) > 0 || !FlowerHeadwearHelmet.getFlowerHeadwear((LivingEntity)player).isEmpty()) {
                return false;
            }
        }
        return canTarget;
    }

    public boolean isOwnedBy(LivingEntity livingEntity) {
        return livingEntity == this.getOwner();
    }

    public PlayerTeam getTeam() {
        LivingEntity livingEntity;
        if (this.getOwner() != null && (livingEntity = this.getOwner()) != null) {
            return livingEntity.getTeam();
        }
        return super.getTeam();
    }

    public boolean isAlliedTo(Entity entity) {
        if (this.getOwner() != null) {
            LivingEntity livingEntity = this.getOwner();
            if (entity == livingEntity) {
                return true;
            }
            if (livingEntity != null) {
                return livingEntity.isAlliedTo(entity);
            }
        }
        return super.isAlliedTo(entity);
    }

    public static void considerHiddenRootminsInPath(Path path, RootminEntity mob) {
        if (path != null && !path.isDone() && path.getNodeCount() > 0 && path.getNodeCount() > path.getNextNodeIndex()) {
            BlockPos targetPos = path.getNodePos(path.getNextNodeIndex());
            AABB aabb = new AABB((double)targetPos.getX() - 0.2, (double)targetPos.getY() - 0.2, (double)targetPos.getZ() - 0.2, (double)targetPos.getX() + 1.2, (double)targetPos.getY() + 1.2, (double)targetPos.getZ() + 1.2);
            List list = mob.level().getEntitiesOfClass(RootminEntity.class, aabb, rootmin2 -> rootmin2 != mob && rootmin2.getRootminPose() == RootminState.ENTITY_TO_BLOCK);
            if (!list.isEmpty()) {
                path.advance();
            }
        }
    }

    public static void jumpFix(Path path, RootminEntity mob) {
        BlockPos targetPos;
        if (!mob.jumping && path != null && !path.isDone() && path.getNodeCount() > 0 && path.getNodeCount() > path.getNextNodeIndex() && (targetPos = path.getNodePos(path.getNextNodeIndex())).getY() > mob.blockPosition().getY()) {
            BlockPos frontPos = mob.blockPosition().relative(mob.getDirection());
            BlockState frontState = mob.level().getBlockState(frontPos);
            if (frontState.isCollisionShapeFullBlock((BlockGetter)mob.level(), frontPos)) {
                mob.jumpFromGround();
            }
        }
    }
}

