/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.entities.datamanagers.queentrades;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.random.Weight;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class WeightedTradeResult
implements WeightedEntry {
    public static final Codec<WeightedTradeResult> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)TagKey.codec((ResourceKey)Registries.ITEM).optionalFieldOf("t").forGetter(e -> e.tagKey), (App)ItemStack.CODEC.listOf().optionalFieldOf("w").forGetter(e -> e.items), (App)Codec.intRange((int)1, (int)64).fieldOf("c").forGetter(e -> e.count), (App)ExtraCodecs.NON_NEGATIVE_INT.fieldOf("xp").forGetter(e -> e.xpReward), (App)ExtraCodecs.POSITIVE_INT.fieldOf("w8").forGetter(e -> e.weight), (App)ExtraCodecs.POSITIVE_INT.fieldOf("tgw").forGetter(e -> e.totalGroupWeight)).apply((Applicative)instance, instance.stable(WeightedTradeResult::new)));
    public final Optional<TagKey<Item>> tagKey;
    private final Optional<List<ItemStack>> items;
    public final int count;
    public final int xpReward;
    public final int weight;
    private int totalGroupWeight;

    public WeightedTradeResult(Optional<TagKey<Item>> tagKey, Optional<List<ItemStack>> items, int count, int xpReward, int weight, int totalGroupWeight) {
        this.tagKey = tagKey;
        this.items = tagKey != null && tagKey.isPresent() ? Optional.empty() : items;
        this.count = count;
        this.xpReward = xpReward;
        this.weight = weight;
        this.totalGroupWeight = totalGroupWeight;
    }

    public WeightedTradeResult(Optional<TagKey<Item>> tagKey, Optional<List<ItemStack>> items, int count, int xpReward, int weight) {
        this.tagKey = tagKey;
        this.items = tagKey != null && tagKey.isPresent() ? Optional.empty() : items;
        this.count = count;
        this.xpReward = xpReward;
        this.weight = weight;
    }

    public Weight getWeight() {
        return Weight.of((int)this.weight);
    }

    public int getTotalWeight() {
        return this.totalGroupWeight;
    }

    public void setTotalWeight(int totalGroupWeight) {
        this.totalGroupWeight = totalGroupWeight;
    }

    public List<ItemStack> getItems() {
        List<ItemStack> itemsToReturn = new ArrayList<ItemStack>();
        if (this.tagKey != null && this.tagKey.isPresent()) {
            itemsToReturn = this.tagKey.map(arg_0 -> ((DefaultedRegistry)BuiltInRegistries.ITEM).getOrCreateTag(arg_0)).get().stream().map(v -> {
                ItemStack stack = ((Item)v.value()).getDefaultInstance();
                stack.grow(this.count);
                return stack;
            }).toList();
        } else if (this.items.isPresent()) {
            itemsToReturn = this.items.get();
        }
        return itemsToReturn;
    }
}

