/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.client.rendering.rootmin;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.telepathicgrunt.the_bumblezone.client.rendering.rootmin.RootminModel;
import com.telepathicgrunt.the_bumblezone.entities.mobs.RootminEntity;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;

public class RootminShieldRenderer
extends RenderLayer<RootminEntity, RootminModel> {
    private static final ResourceLocation SHIELD_LOCATION = ResourceLocation.fromNamespaceAndPath((String)"the_bumblezone", (String)"textures/entity/rootmin_shield.png");
    private final RootminModel model;

    public RootminShieldRenderer(RenderLayerParent<RootminEntity, RootminModel> renderLayerParent, EntityModelSet entityModelSet) {
        super(renderLayerParent);
        this.model = new RootminModel(entityModelSet.bakeLayer(RootminModel.LAYER_LOCATION));
    }

    public void render(PoseStack poseStack, MultiBufferSource multiBufferSource, int i, RootminEntity entity, float f, float g, float h, float j, float k, float l) {
        if (entity.getRootminShield()) {
            float m = (float)entity.tickCount + h;
            EntityModel<RootminEntity> entityModel = this.model();
            entityModel.prepareMobModel((Entity)entity, f, g, h);
            ((RootminModel)this.getParentModel()).copyPropertiesTo(entityModel);
            VertexConsumer vertexConsumer = multiBufferSource.getBuffer(RenderType.energySwirl((ResourceLocation)this.getTextureLocation(), (float)(this.xOffset(m) % 1.0f), (float)(m * 0.01f % 1.0f)));
            entityModel.setupAnim((Entity)entity, f, g, j, k, l);
            entityModel.renderToBuffer(poseStack, vertexConsumer, i, OverlayTexture.NO_OVERLAY, -8355712);
        }
    }

    protected float xOffset(float f) {
        return f * 0.02f;
    }

    protected ResourceLocation getTextureLocation() {
        return SHIELD_LOCATION;
    }

    protected EntityModel<RootminEntity> model() {
        return this.model;
    }
}

