/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.client.rendering.beehemoth;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.telepathicgrunt.the_bumblezone.entities.mobs.BeehemothEntity;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class BeehemothModel
extends EntityModel<BeehemothEntity> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"the_bumblezone", (String)"beehemoth"), "main");
    private final ModelPart ROOT;
    protected final ModelPart SADDLE;
    protected final ModelPart CROWN;
    protected final ModelPart WING_RIGHT;
    protected final ModelPart WING_LEFT;
    protected final ModelPart LEG_FRONTLEFT;
    protected final ModelPart LEG_FRONTRIGHT;
    protected final ModelPart LEG_MIDLEFT;
    protected final ModelPart LEG_MIDRIGHT;
    protected final ModelPart LEG_REARLEFT;
    protected final ModelPart LEG_REARRIGHT;
    protected final ModelPart KneeFrontRightCube_r1;
    protected final ModelPart KneeMidRightCube_r1;
    protected final ModelPart KneeRearRightCube_r1;
    protected final ModelPart KneeFrontLeftCube_r1;
    protected final ModelPart KneeMidLeftCube_r1;
    protected final ModelPart KneeRearLeftCube_r1;
    protected final ModelPart ANTENNA_LEFT;
    protected final ModelPart ANTENNA_RIGHT;
    protected final ModelPart THORAX;
    protected final ModelPart FACE;
    protected final ModelPart ABDOMEN;

    public BeehemothModel(ModelPart modelPart) {
        this.ROOT = modelPart.getChild("ROOT");
        this.FACE = this.ROOT.getChild("FACE");
        this.CROWN = this.FACE.getChild("CROWN");
        this.ANTENNA_LEFT = this.FACE.getChild("ANTENNA_LEFT");
        this.ANTENNA_RIGHT = this.FACE.getChild("ANTENNA_RIGHT");
        this.THORAX = this.ROOT.getChild("THORAX");
        this.LEG_FRONTLEFT = this.THORAX.getChild("LEG_FRONTLEFT");
        this.KneeFrontLeftCube_r1 = this.LEG_FRONTLEFT.getChild("KNEE_FRONTLEFT").getChild("KneeFrontLeftCube_r1");
        this.LEG_MIDLEFT = this.THORAX.getChild("LEG_MIDLEFT");
        this.KneeMidLeftCube_r1 = this.LEG_MIDLEFT.getChild("KNEE_MIDLEFT").getChild("KneeMidLeftCube_r1");
        this.LEG_REARLEFT = this.THORAX.getChild("LEG_REARLEFT");
        this.KneeRearLeftCube_r1 = this.LEG_REARLEFT.getChild("KNEE_REARLEFT").getChild("KneeRearLeftCube_r1");
        this.LEG_FRONTRIGHT = this.THORAX.getChild("LEG_FRONTRIGHT");
        this.KneeFrontRightCube_r1 = this.LEG_FRONTRIGHT.getChild("KNEE_FRONTRIGHT").getChild("KneeFrontRightCube_r1");
        this.LEG_MIDRIGHT = this.THORAX.getChild("LEG_MIDRIGHT");
        this.KneeMidRightCube_r1 = this.LEG_MIDRIGHT.getChild("KNEE_MIDRIGHT").getChild("KneeMidRightCube_r1");
        this.LEG_REARRIGHT = this.THORAX.getChild("LEG_REARRIGHT");
        this.KneeRearRightCube_r1 = this.LEG_REARRIGHT.getChild("KNEE_REARRIGHT").getChild("KneeRearRightCube_r1");
        this.WING_LEFT = this.THORAX.getChild("WING_LEFT");
        this.WING_RIGHT = this.THORAX.getChild("WING_RIGHT");
        this.ABDOMEN = this.ROOT.getChild("ABDOMEN");
        this.SADDLE = this.ROOT.getChild("SADDLE");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition ROOT = partdefinition.addOrReplaceChild("ROOT", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition FACE = ROOT.addOrReplaceChild("FACE", CubeListBuilder.create().texOffs(0, 0).addBox(-3.5f, 0.0f, -6.0f, 7.0f, 7.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-8.0f, (float)-6.0f, (float)0.3927f, (float)0.0f, (float)0.0f));
        PartDefinition CROWN = FACE.addOrReplaceChild("CROWN", CubeListBuilder.create().texOffs(40, 26).addBox(-2.5f, -3.0f, -5.0f, 5.0f, 3.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition ANTENNA_LEFT = FACE.addOrReplaceChild("ANTENNA_LEFT", CubeListBuilder.create().texOffs(57, 1).addBox(-1.5f, 0.0f, -9.0f, 0.0f, 2.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition ANTENNA_RIGHT = FACE.addOrReplaceChild("ANTENNA_RIGHT", CubeListBuilder.create().texOffs(57, 1).addBox(1.5f, 0.0f, -9.0f, 0.0f, 2.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition THORAX = ROOT.addOrReplaceChild("THORAX", CubeListBuilder.create().texOffs(0, 14).addBox(-4.5f, -9.0f, -6.0f, 9.0f, 9.0f, 11.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition LEG_FRONTLEFT = THORAX.addOrReplaceChild("LEG_FRONTLEFT", CubeListBuilder.create().texOffs(21, 0).addBox(-1.0f, 0.0f, -1.5f, 5.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)4.5f, (float)-2.0f, (float)-4.0f, (float)0.0f, (float)0.0873f, (float)1.309f));
        PartDefinition KNEE_FRONTLEFT = LEG_FRONTLEFT.addOrReplaceChild("KNEE_FRONTLEFT", CubeListBuilder.create(), PartPose.offset((float)4.0f, (float)1.5f, (float)4.5f));
        PartDefinition KneeFrontLeftCube_r1 = KNEE_FRONTLEFT.addOrReplaceChild("KneeFrontLeftCube_r1", CubeListBuilder.create().texOffs(37, 2).addBox(0.0f, -1.0f, 0.0f, 5.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)-6.0f, (float)0.0f, (float)-0.6981f, (float)0.0f));
        PartDefinition LEG_MIDLEFT = THORAX.addOrReplaceChild("LEG_MIDLEFT", CubeListBuilder.create().texOffs(21, 0).addBox(-1.0f, 0.0f, -1.5f, 5.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)4.5f, (float)-2.0f, (float)-0.5f, (float)0.0f, (float)0.0f, (float)1.1345f));
        PartDefinition KNEE_MIDLEFT = LEG_MIDLEFT.addOrReplaceChild("KNEE_MIDLEFT", CubeListBuilder.create(), PartPose.offset((float)4.0f, (float)1.5f, (float)4.5f));
        PartDefinition KneeMidLeftCube_r1 = KNEE_MIDLEFT.addOrReplaceChild("KneeMidLeftCube_r1", CubeListBuilder.create().texOffs(37, 2).addBox(0.0f, -1.0f, 0.0f, 5.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)-6.0f, (float)0.0f, (float)-0.8727f, (float)0.0f));
        PartDefinition LEG_REARLEFT = THORAX.addOrReplaceChild("LEG_REARLEFT", CubeListBuilder.create().texOffs(21, 0).addBox(-1.0f, 0.0f, -1.5f, 5.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)4.5f, (float)-2.0f, (float)3.0f, (float)0.0f, (float)-0.2182f, (float)0.9599f));
        PartDefinition KNEE_REARLEFT = LEG_REARLEFT.addOrReplaceChild("KNEE_REARLEFT", CubeListBuilder.create(), PartPose.offset((float)4.0f, (float)1.5f, (float)4.5f));
        PartDefinition KneeRearLeftCube_r1 = KNEE_REARLEFT.addOrReplaceChild("KneeRearLeftCube_r1", CubeListBuilder.create().texOffs(37, 2).addBox(0.0f, -1.0f, 0.0f, 5.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)-6.0f, (float)0.0f, (float)-1.0472f, (float)0.0f));
        PartDefinition LEG_FRONTRIGHT = THORAX.addOrReplaceChild("LEG_FRONTRIGHT", CubeListBuilder.create().texOffs(21, 0).mirror().addBox(-4.0f, 0.0f, -1.5f, 5.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)-4.5f, (float)-2.0f, (float)-4.0f, (float)0.0f, (float)-0.0873f, (float)-1.309f));
        PartDefinition KNEE_FRONTRIGHT = LEG_FRONTRIGHT.addOrReplaceChild("KNEE_FRONTRIGHT", CubeListBuilder.create(), PartPose.offset((float)-4.0f, (float)1.5f, (float)4.5f));
        PartDefinition KneeFrontRightCube_r1 = KNEE_FRONTRIGHT.addOrReplaceChild("KneeFrontRightCube_r1", CubeListBuilder.create().texOffs(37, 2).mirror().addBox(-5.0f, -1.0f, 0.0f, 5.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)-6.0f, (float)0.0f, (float)0.6981f, (float)0.0f));
        PartDefinition LEG_MIDRIGHT = THORAX.addOrReplaceChild("LEG_MIDRIGHT", CubeListBuilder.create().texOffs(21, 0).mirror().addBox(-4.0f, 0.0f, -1.5f, 5.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)-4.5f, (float)-2.0f, (float)-0.5f, (float)0.0f, (float)0.0f, (float)-1.1345f));
        PartDefinition KNEE_MIDRIGHT = LEG_MIDRIGHT.addOrReplaceChild("KNEE_MIDRIGHT", CubeListBuilder.create(), PartPose.offset((float)-4.0f, (float)1.5f, (float)4.5f));
        PartDefinition KneeMidRightCube_r1 = KNEE_MIDRIGHT.addOrReplaceChild("KneeMidRightCube_r1", CubeListBuilder.create().texOffs(37, 2).mirror().addBox(-5.0f, -1.0f, 0.0f, 5.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)-6.0f, (float)0.0f, (float)0.8727f, (float)0.0f));
        PartDefinition LEG_REARRIGHT = THORAX.addOrReplaceChild("LEG_REARRIGHT", CubeListBuilder.create().texOffs(21, 0).mirror().addBox(-4.0f, 0.0f, -1.5f, 5.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)-4.5f, (float)-2.0f, (float)3.0f, (float)0.0f, (float)0.2182f, (float)-0.9599f));
        PartDefinition KNEE_REARRIGHT = LEG_REARRIGHT.addOrReplaceChild("KNEE_REARRIGHT", CubeListBuilder.create(), PartPose.offset((float)-4.0f, (float)1.5f, (float)4.5f));
        PartDefinition KneeRearRightCube_r1 = KNEE_REARRIGHT.addOrReplaceChild("KneeRearRightCube_r1", CubeListBuilder.create().texOffs(37, 2).mirror().addBox(-5.0f, -1.0f, 0.0f, 5.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)-6.0f, (float)0.0f, (float)1.0472f, (float)0.0f));
        PartDefinition WING_LEFT = THORAX.addOrReplaceChild("WING_LEFT", CubeListBuilder.create(), PartPose.offset((float)3.5f, (float)-9.0f, (float)-5.0f));
        PartDefinition WingLeftPlane_r1 = WING_LEFT.addOrReplaceChild("WingLeftPlane_r1", CubeListBuilder.create().texOffs(5, 34).addBox(0.0f, 0.0f, -1.0f, 7.0f, 0.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)1.0f, (float)0.0f, (float)0.2182f, (float)-0.1745f));
        PartDefinition WING_RIGHT = THORAX.addOrReplaceChild("WING_RIGHT", CubeListBuilder.create(), PartPose.offset((float)-3.5f, (float)-9.0f, (float)-5.0f));
        PartDefinition WingRightPlane_r1 = WING_RIGHT.addOrReplaceChild("WingRightPlane_r1", CubeListBuilder.create().texOffs(5, 34).mirror().addBox(-7.0f, 0.0f, -1.0f, 7.0f, 0.0f, 8.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)1.0f, (float)0.0f, (float)-0.2182f, (float)0.1745f));
        PartDefinition ABDOMEN = ROOT.addOrReplaceChild("ABDOMEN", CubeListBuilder.create().texOffs(29, 8).addBox(-3.5f, 0.0f, -1.0f, 7.0f, 7.0f, 10.0f, new CubeDeformation(0.0f)).texOffs(51, 3).addBox(-0.5f, 3.0f, 9.0f, 1.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-8.0f, (float)5.0f, (float)-0.3927f, (float)0.0f, (float)0.0f));
        PartDefinition SADDLE = ROOT.addOrReplaceChild("SADDLE", CubeListBuilder.create().texOffs(0, 42).addBox(-5.5f, -9.25f, -4.0f, 11.0f, 5.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    private float getSine(float time, float max, float min) {
        float so = Mth.sin((float)(time * 0.25f));
        float range = max - min;
        return so * range + min;
    }

    private float getCos(float time, float max, float min) {
        float so = Mth.cos((float)(time * 0.25f));
        float range = max - min;
        return so * range + min;
    }

    public void setupAnim(BeehemothEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.SADDLE.visible = entity.isSaddled();
        this.CROWN.visible = entity.isQueen();
        this.WING_RIGHT.xRot = 0.0f;
        this.ROOT.xRot = 0.0f;
        this.ROOT.y = 19.0f;
        boolean onGround = entity.onGround() || entity.isPassenger();
        boolean isSitting = entity.isInSittingPose();
        double xzSpeed = Math.abs(entity.getDeltaMovement().x()) + Math.abs(entity.getDeltaMovement().z());
        if (onGround) {
            this.WING_RIGHT.yRot = -0.2618f;
            this.WING_RIGHT.zRot = 0.0f;
            this.WING_LEFT.xRot = 0.0f;
            this.WING_LEFT.yRot = 0.2618f;
            this.WING_LEFT.zRot = 0.0f;
            this.LEG_FRONTLEFT.xRot = 0.0f;
            this.LEG_FRONTRIGHT.xRot = 0.0f;
            this.LEG_MIDLEFT.xRot = 0.0f;
            this.LEG_MIDRIGHT.xRot = 0.0f;
            this.LEG_REARLEFT.xRot = 0.0f;
            this.LEG_REARRIGHT.xRot = 0.0f;
            if (xzSpeed > 8.0E-7) {
                this.KneeFrontRightCube_r1.yRot = this.getSine(ageInTicks + entity.offset1, 0.2f, 0.475f);
                this.KneeMidRightCube_r1.yRot = this.getCos(ageInTicks + entity.offset2, 0.375f, 0.525f);
                this.KneeRearRightCube_r1.yRot = this.getSine(ageInTicks + entity.offset3, 0.45f, 0.625f);
                this.KneeFrontLeftCube_r1.yRot = this.getSine(ageInTicks + entity.offset4, -0.2f, -0.475f);
                this.KneeMidLeftCube_r1.yRot = this.getCos(ageInTicks + entity.offset5, -0.375f, -0.525f);
                this.KneeRearLeftCube_r1.yRot = this.getSine(ageInTicks + entity.offset6, -0.45f, -0.625f);
            } else {
                this.KneeFrontRightCube_r1.yRot = this.getSine(entity.offset1, 0.2f, 0.475f);
                this.KneeMidRightCube_r1.yRot = this.getCos(entity.offset2, 0.375f, 0.525f);
                this.KneeRearRightCube_r1.yRot = this.getSine(entity.offset3, 0.45f, 0.625f);
                this.KneeFrontLeftCube_r1.yRot = this.getSine(entity.offset4, -0.2f, -0.475f);
                this.KneeMidLeftCube_r1.yRot = this.getCos(entity.offset5, -0.375f, -0.525f);
                this.KneeRearLeftCube_r1.yRot = this.getSine(entity.offset6, -0.45f, -0.625f);
            }
            if (xzSpeed > 0.03) {
                this.WING_RIGHT.yRot = 0.0f;
                wingSpeed = 0.75f;
                this.WING_LEFT.zRot = (float)((double)Mth.cos((float)((limbSwing + ageInTicks) * 2.1f * wingSpeed)) * Math.PI * (double)0.15f);
                this.WING_LEFT.xRot = this.WING_RIGHT.xRot;
                this.WING_LEFT.yRot = this.WING_RIGHT.yRot;
                this.WING_RIGHT.zRot = -this.WING_LEFT.zRot;
            }
        } else {
            this.WING_RIGHT.yRot = 0.0f;
            wingSpeed = isSitting ? 0.75f : 1.0f;
            this.WING_LEFT.zRot = (float)((double)Mth.cos((float)((limbSwing + ageInTicks) * 2.1f * wingSpeed)) * Math.PI * (double)0.15f);
            this.WING_LEFT.xRot = this.WING_RIGHT.xRot;
            this.WING_LEFT.yRot = this.WING_RIGHT.yRot;
            this.WING_RIGHT.zRot = -this.WING_LEFT.zRot;
            this.LEG_FRONTLEFT.xRot = 0.7853982f;
            this.LEG_FRONTRIGHT.xRot = 0.7853982f;
            this.LEG_MIDLEFT.xRot = 0.7853982f;
            this.LEG_MIDRIGHT.xRot = 0.7853982f;
            this.LEG_REARLEFT.xRot = 0.7853982f;
            this.LEG_REARRIGHT.xRot = 0.7853982f;
            this.ROOT.xRot = 0.0f;
            this.ROOT.yRot = 0.0f;
            this.ROOT.zRot = 0.0f;
            this.KneeFrontRightCube_r1.yRot = this.getSine(ageInTicks + entity.offset1, 0.2f, 0.475f);
            this.KneeMidRightCube_r1.yRot = this.getSine(ageInTicks + entity.offset2, 0.375f, 0.525f);
            this.KneeRearRightCube_r1.yRot = this.getSine(ageInTicks + entity.offset3, 0.45f, 0.625f);
            this.KneeFrontLeftCube_r1.yRot = this.getSine(ageInTicks + entity.offset4, -0.2f, -0.475f);
            this.KneeMidLeftCube_r1.yRot = this.getSine(ageInTicks + entity.offset5, -0.375f, -0.525f);
            this.KneeRearLeftCube_r1.yRot = this.getSine(ageInTicks + entity.offset6, -0.45f, -0.625f);
        }
        this.ROOT.xRot = 0.0f;
        this.ROOT.yRot = 0.0f;
        this.ROOT.zRot = 0.0f;
        float swayingMotion = Mth.sin((float)(ageInTicks * 0.18f));
        if (isSitting) {
            this.ANTENNA_LEFT.xRot = swayingMotion * (float)Math.PI * 0.002f;
            this.ANTENNA_RIGHT.xRot = swayingMotion * (float)Math.PI * 0.002f;
            this.ANTENNA_LEFT.z = -0.3f;
            this.ANTENNA_RIGHT.z = -0.3f;
            this.ANTENNA_LEFT.y = -1.1f;
            this.ANTENNA_RIGHT.y = -1.1f;
            this.ANTENNA_LEFT.xRot += 0.2f;
            this.ANTENNA_RIGHT.xRot += 0.2f;
        } else {
            this.ANTENNA_LEFT.xRot = swayingMotion * (float)Math.PI * 0.005f;
            this.ANTENNA_RIGHT.xRot = swayingMotion * (float)Math.PI * 0.005f;
            this.ANTENNA_LEFT.z = 0.1f;
            this.ANTENNA_RIGHT.z = 0.1f;
            this.ANTENNA_LEFT.y = -1.0f;
            this.ANTENNA_RIGHT.y = -1.0f;
        }
        if (!onGround) {
            this.ROOT.xRot = 0.1f + swayingMotion * (float)Math.PI * 0.015f;
            this.ROOT.y = 19.0f - Mth.cos((float)(ageInTicks * 0.18f)) * 0.9f;
        }
        this.THORAX.xRot = 0.0f;
        float swayingMotion2 = Mth.sin((float)(ageInTicks * 0.18f));
        this.FACE.xRot = (swayingMotion2 + 40.0f) * (float)Math.PI * 0.0025f;
        this.ABDOMEN.xRot = (swayingMotion2 - 40.0f) * (float)Math.PI * 0.0025f;
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, int packedColor) {
        float scale = 1.6f;
        poseStack.scale(scale, scale, scale);
        poseStack.translate(0.0, -0.5, 0.0);
        this.ROOT.render(poseStack, buffer, packedLight, packedOverlay);
    }
}

