/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.client.particles;

import com.telepathicgrunt.the_bumblezone.modinit.BzTags;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.SuspendedParticle;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;

public class RoyalJellyParticle
extends SuspendedParticle {
    private RoyalJellyParticle(ClientLevel clientWorld, SpriteSet spriteProvider, double xPos, double yPos, double zPos) {
        super(clientWorld, spriteProvider, xPos, yPos, zPos);
        this.rCol = 0.25f;
        this.gCol = 0.0f;
        this.bCol = 0.45f;
        this.quadSize *= this.random.nextFloat() * 8.5f + 0.5f;
        this.age = (int)(440.0 * (Math.random() * 0.55 + 0.45));
    }

    public void tick() {
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        if (this.age-- <= 0) {
            this.remove();
        } else {
            BlockState blockState = this.level.getBlockState(BlockPos.containing((double)this.x, (double)this.y, (double)this.z));
            FluidState fluidState = blockState.getFluidState();
            if (fluidState.is(BzTags.ROYAL_JELLY_FLUID)) {
                if (fluidState.isSource()) {
                    this.move(this.xd, this.yd + 0.001, this.zd);
                } else {
                    this.move(this.xd, this.yd - 0.001, this.zd);
                }
            } else if (blockState.isAir()) {
                this.move(this.xd, this.yd - 0.35, this.zd);
            } else {
                this.remove();
            }
        }
    }

    public static class Factory
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprites;

        public Factory(SpriteSet sprite) {
            this.sprites = sprite;
        }

        public Particle createParticle(SimpleParticleType particleType, ClientLevel clientWorld, double xPos, double yPos, double zPos, double xSpeed, double ySpeed, double zSpeed) {
            RoyalJellyParticle royalJellyParticle = new RoyalJellyParticle(clientWorld, this.sprites, xPos, yPos, zPos);
            royalJellyParticle.pickSprite(this.sprites);
            return royalJellyParticle;
        }
    }
}

