/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.tesseract.neoforge.helper;

import com.google.common.collect.Lists;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import net.neoforged.neoforge.items.wrapper.PlayerInvWrapper;
import org.slf4j.Logger;

public final class TransferHelper {
    private static final Logger LOGGER = LogUtils.getLogger();

    public static List<ItemStack> moveAll(IItemHandler source, IItemHandler target, boolean stackInTarget) {
        ArrayList moved = Lists.newArrayList();
        int srcSlots = source.getSlots();
        for (int i = 0; i < srcSlots; ++i) {
            ItemStack leftover;
            ItemStack extracted = source.extractItem(i, Integer.MAX_VALUE, true);
            if (extracted.isEmpty()) continue;
            int extractedCount = extracted.getCount();
            int insertedCount = extractedCount - (leftover = stackInTarget ? ItemHandlerHelper.insertItemStacked((IItemHandler)target, (ItemStack)extracted, (boolean)true) : ItemHandlerHelper.insertItem((IItemHandler)target, (ItemStack)extracted, (boolean)true)).getCount();
            if (insertedCount <= 0 || (extracted = source.extractItem(i, insertedCount, false)).isEmpty()) continue;
            leftover = stackInTarget ? ItemHandlerHelper.insertItemStacked((IItemHandler)target, (ItemStack)extracted, (boolean)false) : ItemHandlerHelper.insertItem((IItemHandler)target, (ItemStack)extracted, (boolean)false);
            moved.add(extracted.copy());
            if (leftover.isEmpty() || (leftover = source.insertItem(i, leftover, false)).isEmpty()) continue;
            LOGGER.warn("Item handler {} rejected {}, discarding.", (Object)target, (Object)leftover);
        }
        return moved;
    }

    public static int insert(IItemHandler target, ItemStack toInsert, boolean simulate) {
        ItemStack remaining;
        int amountToInsert;
        ItemStack stack;
        int amountInserted = 0;
        for (int slot = 0; !(slot >= target.getSlots() || target.isItemValid(slot, toInsert) && ((stack = target.getStackInSlot(slot)).isEmpty() || ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)toInsert)) && (amountInserted += (amountToInsert = Math.min(toInsert.getCount() - amountInserted, target.getSlotLimit(slot))) - (remaining = target.insertItem(slot, toInsert.copyWithCount(amountToInsert), simulate)).getCount()) >= toInsert.getCount()); ++slot) {
        }
        return amountInserted;
    }

    public static int insert(IItemHandler target, ItemStack toInsert) {
        return TransferHelper.insert(target, toInsert, false);
    }

    public static ItemStack extractMatching(Inventory inventory, Predicate<ItemStack> predicate, int maxAmount, boolean containers, boolean simulate) {
        int sourceSlots = inventory.getContainerSize();
        ItemStack ret = TransferHelper.extractMatching((IItemHandler)new PlayerInvWrapper(inventory), predicate, maxAmount, simulate);
        if (containers) {
            if (!ret.isEmpty()) {
                ItemStack finalRet = ret;
                predicate = other -> ItemStack.isSameItemSameComponents((ItemStack)finalRet, (ItemStack)other);
            }
            for (int slot = 0; slot < sourceSlots && maxAmount > ret.getCount(); ++slot) {
                IItemHandler capability;
                ItemStack stack = inventory.getItem(slot);
                if (stack.getCount() != 1 || (capability = (IItemHandler)stack.getCapability(Capabilities.ItemHandler.ITEM)) == null) continue;
                ItemStack extracted = TransferHelper.extractMatching(capability, predicate, maxAmount - ret.getCount(), simulate);
                if (ret.isEmpty()) {
                    ret = extracted;
                    continue;
                }
                ret.grow(extracted.getCount());
            }
        }
        return ret;
    }

    public static ItemStack extractMatching(Inventory inventory, Predicate<ItemStack> predicate, int maxAmount, boolean containers) {
        return TransferHelper.extractMatching(inventory, predicate, maxAmount, containers, false);
    }

    public static ItemStack extractMatching(IItemHandler source, Predicate<ItemStack> predicate, int maxAmount, boolean simulate) {
        ItemStack stack;
        int slot;
        int sourceSlots = source.getSlots();
        ItemStack ret = ItemStack.EMPTY;
        for (slot = 0; slot < sourceSlots && ret.isEmpty(); ++slot) {
            stack = source.getStackInSlot(slot);
            if (predicate != null && !predicate.test(stack)) continue;
            ret = source.extractItem(slot, Math.min(stack.getCount(), maxAmount), simulate);
        }
        if (ret.isEmpty()) {
            return ItemStack.EMPTY;
        }
        while (slot < sourceSlots && maxAmount > ret.getCount()) {
            stack = source.getStackInSlot(slot);
            if (ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)ret)) {
                ItemStack extracted = source.extractItem(slot, Math.min(stack.getCount(), maxAmount - ret.getCount()), simulate);
                ret.grow(extracted.getCount());
            }
            ++slot;
        }
        return ret;
    }

    public static ItemStack extractMatching(IItemHandler source, Predicate<ItemStack> predicate, int maxAmount) {
        return TransferHelper.extractMatching(source, predicate, maxAmount, false);
    }

    public static ItemStack extractFirst(IItemHandler source, int maxAmount, boolean simulate) {
        return TransferHelper.extractMatching(source, null, maxAmount, simulate);
    }

    public static ItemStack extractFirst(IItemHandler source, int maxAmount) {
        return TransferHelper.extractFirst(source, maxAmount, false);
    }

    public static int extractAny(Inventory inventory, Predicate<ItemStack> predicate, int maxAmount, boolean containers, boolean simulate) {
        int count = TransferHelper.extractAny((IItemHandler)new PlayerInvWrapper(inventory), predicate, maxAmount, simulate);
        if (containers) {
            for (int slot = 0; slot < inventory.getContainerSize() && maxAmount > count; ++slot) {
                IItemHandler capability;
                ItemStack stack = inventory.getItem(slot);
                if (stack.getCount() != 1 || (capability = (IItemHandler)stack.getCapability(Capabilities.ItemHandler.ITEM)) == null) continue;
                count += TransferHelper.extractAny(capability, predicate, maxAmount - count, simulate);
            }
        }
        return count;
    }

    public static int extractAny(Inventory inventory, Predicate<ItemStack> predicate, int maxAmount, boolean containers) {
        return TransferHelper.extractAny(inventory, predicate, maxAmount, containers, false);
    }

    public static int extractAny(IItemHandler source, Predicate<ItemStack> predicate, int maxAmount, boolean simulate) {
        int count = 0;
        for (int slot = 0; slot < source.getSlots(); ++slot) {
            ItemStack stack = source.getStackInSlot(slot);
            if (predicate != null && !predicate.test(stack)) continue;
            count += source.extractItem(slot, Math.min(stack.getCount(), maxAmount - count), simulate).getCount();
        }
        return count;
    }

    public static int extractAny(IItemHandler source, Predicate<ItemStack> predicate, int maxAmount) {
        return TransferHelper.extractAny(source, predicate, maxAmount, false);
    }

    public static int move(IEnergyStorage source, IEnergyStorage target, int maxAmount) {
        int leftover;
        int simulatedExtract = source.extractEnergy(maxAmount, true);
        int simulatedInsert = target.receiveEnergy(simulatedExtract, true);
        int extractedAmount = source.extractEnergy(simulatedInsert, false);
        int insertedAmount = target.receiveEnergy(extractedAmount, false);
        if (insertedAmount < extractedAmount && (leftover = source.receiveEnergy(extractedAmount - insertedAmount, false)) > 0) {
            LOGGER.error("Energy storage {} did not accept {} leftover energy from {}! Voiding it.", new Object[]{source, leftover, target});
        }
        return insertedAmount;
    }
}

