/*
 * Decompiled with CFR 0.152.
 */
package net.swedz.tesseract.neoforge.compat.mi.component;

import aztech.modern_industrialization.inventory.MIFluidStorage;
import aztech.modern_industrialization.machines.IComponent;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.fluid.FluidVariant;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.storage.StorageView;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.storage.TransferVariant;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.transaction.Transaction;
import aztech.modern_industrialization.thirdparty.fabrictransfer.api.transaction.TransactionContext;
import it.unimi.dsi.fastutil.objects.Reference2LongMap;
import it.unimi.dsi.fastutil.objects.Reference2LongOpenHashMap;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;

public final class SteamProductionComponent
implements IComponent.ServerOnly {
    private final MIFluidStorage fluidStorage;
    private final List<Fluid> waterTypes;
    private final FluidVariant steamKey;
    private final Supplier<Long> maxEuProduction;
    private final Supplier<Integer> waterToSteam;
    private final Reference2LongMap<Fluid> steamBuffer = new Reference2LongOpenHashMap();

    public SteamProductionComponent(MIFluidStorage fluidStorage, List<Fluid> waterTypes, FluidVariant steamKey, Supplier<Long> maxEuProduction, Supplier<Integer> waterToSteam) {
        this.fluidStorage = fluidStorage;
        this.waterTypes = waterTypes;
        this.steamKey = steamKey;
        this.maxEuProduction = maxEuProduction;
        this.waterToSteam = waterToSteam;
    }

    public FluidVariant findWater() {
        for (StorageView fluidStorage : this.fluidStorage) {
            if (fluidStorage.isResourceBlank()) continue;
            FluidVariant fluid = (FluidVariant)fluidStorage.getResource();
            for (Fluid waterType : this.waterTypes) {
                if (!fluid.isOf((Object)waterType)) continue;
                return fluid;
            }
        }
        return FluidVariant.blank();
    }

    public FluidVariant tryMakeSteam() {
        int waterToSteamRate = this.waterToSteam.get();
        FluidVariant waterFluid = this.findWater();
        if (waterFluid.isBlank()) {
            return waterFluid;
        }
        long steamToProduce = this.maxEuProduction.get();
        try (Transaction transaction = Transaction.openOuter();){
            long steamProducedSimulation;
            try (Transaction simulation = Transaction.openNested((TransactionContext)transaction);){
                steamProducedSimulation = this.fluidStorage.insertAllSlot((TransferVariant)this.steamKey, steamToProduce, (TransactionContext)simulation);
            }
            if (steamProducedSimulation > 0L) {
                long waterToConsume = (steamProducedSimulation - this.steamBuffer.getLong((Object)this.steamKey.getFluid()) + (long)waterToSteamRate - 1L) / (long)waterToSteamRate;
                long waterConsumed = this.fluidStorage.extractAllSlot((TransferVariant)waterFluid, waterToConsume, (TransactionContext)transaction);
                this.steamBuffer.mergeLong((Object)this.steamKey.getFluid(), waterConsumed * (long)waterToSteamRate, Long::sum);
                long steamProduced = this.fluidStorage.insertAllSlot((TransferVariant)FluidVariant.of((Fluid)this.steamKey.getFluid()), Math.min(steamToProduce, this.steamBuffer.getLong((Object)this.steamKey.getFluid())), (TransactionContext)transaction);
                this.steamBuffer.mergeLong((Object)this.steamKey.getFluid(), -steamProduced, Long::sum);
                transaction.commit();
            }
        }
        return waterFluid;
    }

    public void writeNbt(CompoundTag tag, HolderLookup.Provider registries) {
        CompoundTag buffer = new CompoundTag();
        for (Reference2LongMap.Entry entry : this.steamBuffer.reference2LongEntrySet()) {
            if (entry.getLongValue() == 0L) continue;
            buffer.putLong(((Fluid)entry.getKey()).toString(), entry.getLongValue());
        }
        tag.put("steamBuffer", (Tag)buffer);
    }

    public void readNbt(CompoundTag tag, HolderLookup.Provider registries, boolean isUpgradingMachine) {
        CompoundTag buffer = tag.getCompound("steamBuffer");
        for (String key : buffer.getAllKeys()) {
            Fluid fluid = (Fluid)BuiltInRegistries.FLUID.get(ResourceLocation.tryParse((String)key));
            if (fluid == Fluids.EMPTY) continue;
            this.steamBuffer.put((Object)fluid, buffer.getLong(key));
        }
    }
}

