/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.tempad.common.items;

import earth.terrarium.tempad.api.locations.DirectLocation;
import earth.terrarium.tempad.api.locations.IndirectLocation;
import earth.terrarium.tempad.api.locations.LocationGetter;
import earth.terrarium.tempad.common.items.WalletInventory;
import earth.terrarium.tempad.common.items.WalletItemKt;
import earth.terrarium.tempad.common.menu.WalletMenu;
import earth.terrarium.tempad.common.registries.ModComponentsKt;
import earth.terrarium.tempad.common.registries.ModItems;
import earth.terrarium.tempad.common.utils.ExtensionsKt;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.MutableDataComponentHolder;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J(\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\t\u001a\u00020\nH\u0016J8\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J0\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\u001b2\u000e\u0010\u001c\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001e0\u001d2\u0006\u0010\u001f\u001a\u00020 H\u0016\u00a8\u0006!"}, d2={"Learth/terrarium/tempad/common/items/WalletItem;", "Lnet/minecraft/world/item/Item;", "<init>", "()V", "use", "Lnet/minecraft/world/InteractionResultHolder;", "Lnet/minecraft/world/item/ItemStack;", "level", "Lnet/minecraft/world/level/Level;", "player", "Lnet/minecraft/world/entity/player/Player;", "usedHand", "Lnet/minecraft/world/InteractionHand;", "overrideStackedOnOther", "", "stack", "slot", "Lnet/minecraft/world/inventory/Slot;", "action", "Lnet/minecraft/world/inventory/ClickAction;", "overrideOtherStackedOnMe", "other", "access", "Lnet/minecraft/world/entity/SlotAccess;", "appendHoverText", "", "context", "Lnet/minecraft/world/item/Item$TooltipContext;", "tooltipComponents", "", "Lnet/minecraft/network/chat/Component;", "tooltipFlag", "Lnet/minecraft/world/item/TooltipFlag;", "tempad-1.21.1"})
public final class WalletItem
extends Item {
    public WalletItem() {
        super(new Item.Properties().stacksTo(1));
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level level, @NotNull Player player, @NotNull InteractionHand usedHand) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)usedHand, (String)"usedHand");
        ItemStack stack = player.getItemInHand(usedHand);
        Intrinsics.checkNotNull((Object)stack);
        player.openMenu((MenuProvider)WalletItemKt.getItems(stack));
        InteractionResultHolder interactionResultHolder = InteractionResultHolder.success((Object)stack);
        Intrinsics.checkNotNullExpressionValue((Object)interactionResultHolder, (String)"success(...)");
        return interactionResultHolder;
    }

    public boolean overrideStackedOnOther(@NotNull ItemStack stack, @NotNull Slot slot, @NotNull ClickAction action, @NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)slot, (String)"slot");
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        if (action != ClickAction.SECONDARY) {
            return false;
        }
        WalletInventory items = WalletItemKt.getItems(stack);
        if (!items.isFull() && ExtensionsKt.getContents(slot).getItem() == ModItems.INSTANCE.getLocationCard()) {
            ItemStack itemStack = ExtensionsKt.getContents(slot);
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"<get-contents>(...)");
            if (ModComponentsKt.getPortalTarget((MutableDataComponentHolder)itemStack) != null) {
                ItemStack itemStack2 = ExtensionsKt.getContents(slot);
                Intrinsics.checkNotNullExpressionValue((Object)itemStack2, (String)"<get-contents>(...)");
                ExtensionsKt.setContents(slot, items.insertItem(itemStack2, false));
                return true;
            }
        }
        return false;
    }

    public boolean overrideOtherStackedOnMe(@NotNull ItemStack stack, @NotNull ItemStack other, @NotNull Slot slot, @NotNull ClickAction action, @NotNull Player player, @NotNull SlotAccess access) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        Intrinsics.checkNotNullParameter((Object)slot, (String)"slot");
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)access, (String)"access");
        WalletInventory items = WalletItemKt.getItems(stack);
        if (!items.isFull() && other.getItem() == ModItems.INSTANCE.getLocationCard() && ModComponentsKt.getPortalTarget((MutableDataComponentHolder)other) != null && !(player.containerMenu instanceof WalletMenu)) {
            access.set(items.insertItem(other, false));
            return true;
        }
        return false;
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltipComponents, @NotNull TooltipFlag tooltipFlag) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(tooltipComponents, (String)"tooltipComponents");
        Intrinsics.checkNotNullParameter((Object)tooltipFlag, (String)"tooltipFlag");
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
        Stream stream = ModComponentsKt.getWalletContents((MutableDataComponentHolder)stack).stream();
        boolean empty = true;
        tooltipComponents.add((Component)Component.translatable((String)"item.tempad.card_wallet.prefix").withStyle(ChatFormatting.GRAY));
        Iterator iterator = stream.iterator();
        while (iterator.hasNext()) {
            ItemStack stack2 = (ItemStack)iterator.next();
            Intrinsics.checkNotNull((Object)stack2);
            LocationGetter portalTarget = ModComponentsKt.getPortalTarget((MutableDataComponentHolder)stack2);
            if (portalTarget instanceof IndirectLocation) {
                tooltipComponents.add(((IndirectLocation)portalTarget).getInfo());
            } else if (portalTarget instanceof DirectLocation) {
                tooltipComponents.add((Component)MutableComponent.create((ComponentContents)((DirectLocation)portalTarget).getLocation().getName().getContents()).withColor(((DirectLocation)portalTarget).getLocation().getColor().getValue()));
            }
            empty = false;
        }
        if (empty) {
            tooltipComponents.add((Component)Component.translatable((String)"item.tempad.card_wallet.empty").withStyle(ChatFormatting.DARK_GRAY).withStyle(ChatFormatting.ITALIC));
        }
    }
}

