/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.tempad.common.items;

import earth.terrarium.tempad.Tempad;
import earth.terrarium.tempad.api.context.ContextRegistry;
import earth.terrarium.tempad.api.context.ItemContextKt;
import earth.terrarium.tempad.api.context.SyncableContext;
import earth.terrarium.tempad.api.locations.LocationGetter;
import earth.terrarium.tempad.common.items.WalletInventory;
import earth.terrarium.tempad.common.items.WalletItemKt;
import earth.terrarium.tempad.common.registries.ModComponentsKt;
import earth.terrarium.tempad.common.registries.ModItems;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.MutableDataComponentHolder;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u0006H\u0016\u00a8\u0006\u0011"}, d2={"Learth/terrarium/tempad/common/items/LocationCardItem;", "Lnet/minecraft/world/item/Item;", "<init>", "()V", "use", "Lnet/minecraft/world/InteractionResultHolder;", "Lnet/minecraft/world/item/ItemStack;", "level", "Lnet/minecraft/world/level/Level;", "player", "Lnet/minecraft/world/entity/player/Player;", "usedHand", "Lnet/minecraft/world/InteractionHand;", "getTooltipImage", "Ljava/util/Optional;", "Lnet/minecraft/world/inventory/tooltip/TooltipComponent;", "stack", "tempad-1.21.1"})
public final class LocationCardItem
extends Item {
    public LocationCardItem() {
        super(new Item.Properties().stacksTo(16));
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level level, @NotNull Player player, @NotNull InteractionHand usedHand) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)usedHand, (String)"usedHand");
        ItemStack cardStack = player.getItemInHand(usedHand);
        if (!level.isClientSide) {
            Intrinsics.checkNotNull((Object)cardStack);
            LocationGetter locationGetter = ModComponentsKt.getPortalTarget((MutableDataComponentHolder)cardStack);
            if (locationGetter != null) {
                SyncableContext<?> ctx2;
                LocationGetter pos = locationGetter;
                boolean bl = false;
                SyncableContext<?> syncableContext = ctx2 = ContextRegistry.INSTANCE.locate(player, (Function1<? super ItemStack, Boolean>)((Function1)arg_0 -> LocationCardItem.use$lambda$2$lambda$0(cardStack, arg_0)));
                if (syncableContext != null) {
                    ItemContextKt.modify(syncableContext, (Function1<? super ItemStack, Unit>)((Function1)arg_0 -> LocationCardItem.use$lambda$2$lambda$1(cardStack, player, usedHand, arg_0)));
                } else {
                    player.displayClientMessage((Component)Component.translatable((String)"item.tempad.card_wallet.insert_fail").withColor(Tempad.Companion.getHIGHLIGHTED_ORANGE().getValue()), true);
                }
            }
        }
        InteractionResultHolder interactionResultHolder = InteractionResultHolder.success((Object)cardStack);
        Intrinsics.checkNotNullExpressionValue((Object)interactionResultHolder, (String)"success(...)");
        return interactionResultHolder;
    }

    @NotNull
    public Optional<TooltipComponent> getTooltipImage(@NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        LocationGetter locationGetter = ModComponentsKt.getPortalTarget((MutableDataComponentHolder)stack);
        Optional<TooltipComponent> optional = Optional.ofNullable(locationGetter instanceof TooltipComponent ? (TooltipComponent)locationGetter : null);
        Intrinsics.checkNotNullExpressionValue(optional, (String)"ofNullable(...)");
        return optional;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean use$lambda$2$lambda$0(ItemStack $cardStack, ItemStack it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (!Intrinsics.areEqual((Object)it.getItem(), (Object)ModItems.INSTANCE.getCardWallet())) return false;
        WalletInventory walletInventory = WalletItemKt.getItems(it);
        Intrinsics.checkNotNull((Object)$cardStack);
        if (walletInventory.insertItem($cardStack, true).getCount() >= $cardStack.getCount()) return false;
        return true;
    }

    private static final Unit use$lambda$2$lambda$1(ItemStack $cardStack, Player $player, InteractionHand $usedHand, ItemStack it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        WalletInventory walletInventory = WalletItemKt.getItems(it);
        Intrinsics.checkNotNull((Object)$cardStack);
        ItemStack leftOver = walletInventory.insertItem($cardStack, false);
        $player.setItemInHand($usedHand, leftOver);
        $player.displayClientMessage((Component)Component.translatable((String)"item.tempad.card_wallet.inserted").withColor(Tempad.Companion.getORANGE().getValue()), true);
        return Unit.INSTANCE;
    }
}

