/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.tempad.common.items;

import earth.terrarium.tempad.api.ActionType;
import earth.terrarium.tempad.api.context.ContextRegistry;
import earth.terrarium.tempad.api.context.SyncableContext;
import earth.terrarium.tempad.api.tva_device.ChrononHandler;
import earth.terrarium.tempad.api.tva_device.ChrononHandlerKt;
import earth.terrarium.tempad.client.tooltip.ChrononData;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0016J0\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016\u00a8\u0006\u0017"}, d2={"Learth/terrarium/tempad/common/items/CreativeChronometerItem;", "Lnet/minecraft/world/item/Item;", "<init>", "()V", "getTooltipImage", "Ljava/util/Optional;", "Lnet/minecraft/world/inventory/tooltip/TooltipComponent;", "stack", "Lnet/minecraft/world/item/ItemStack;", "inventoryTick", "", "level", "Lnet/minecraft/world/level/Level;", "entity", "Lnet/minecraft/world/entity/Entity;", "slot", "", "selected", "", "useOn", "Lnet/minecraft/world/InteractionResult;", "context", "Lnet/minecraft/world/item/context/UseOnContext;", "tempad-1.21.1"})
public final class CreativeChronometerItem
extends Item {
    public CreativeChronometerItem() {
        super(new Item.Properties().stacksTo(1));
    }

    @NotNull
    public Optional<TooltipComponent> getTooltipImage(@NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Optional<TooltipComponent> optional = Optional.of(ChrononData.Companion.getInfinite());
        Intrinsics.checkNotNullExpressionValue(optional, (String)"of(...)");
        return optional;
    }

    public void inventoryTick(@NotNull ItemStack stack, @NotNull Level level, @NotNull Entity entity, int slot, boolean selected) {
        block3: {
            Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
            Intrinsics.checkNotNullParameter((Object)level, (String)"level");
            Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
            super.inventoryTick(stack, level, entity, slot, selected);
            if (level.isClientSide || entity.tickCount % 10 != 0) {
                return;
            }
            if (!(entity instanceof Player)) {
                return;
            }
            SyncableContext<?> syncableContext = ContextRegistry.INSTANCE.locate((Player)entity, (Function1<? super ItemStack, Boolean>)((Function1)arg_0 -> CreativeChronometerItem.inventoryTick$lambda$0(stack, arg_0)));
            if (syncableContext == null) break block3;
            SyncableContext<?> it = syncableContext;
            boolean bl = false;
            ChrononHandler chrononHandler = ChrononHandlerKt.getChronons(it.getStack());
            if (chrononHandler != null) {
                chrononHandler.insert(Integer.MAX_VALUE, ActionType.Execute);
            }
        }
    }

    @NotNull
    public InteractionResult useOn(@NotNull UseOnContext context) {
        block2: {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Object object = context.getLevel().getBlockEntity(context.getClickedPos());
            if (object == null || (object = ChrononHandlerKt.getChronons(object)) == null) {
                InteractionResult interactionResult = super.useOn(context);
                Intrinsics.checkNotNullExpressionValue((Object)interactionResult, (String)"useOn(...)");
                return interactionResult;
            }
            Object to = object;
            if (context.getLevel().isClientSide) break block2;
            ItemStack itemStack = context.getItemInHand();
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"getItemInHand(...)");
            ChrononHandler chrononHandler = ChrononHandlerKt.getChronons(itemStack);
            if (chrononHandler != null) {
                ChrononHandler it = chrononHandler;
                boolean bl = false;
                ChrononHandlerKt.move(it, (ChrononHandler)to, Integer.MAX_VALUE);
            }
        }
        return InteractionResult.SUCCESS;
    }

    private static final boolean inventoryTick$lambda$0(ItemStack $stack, ItemStack it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        ChrononHandler chrononHandler = ChrononHandlerKt.getChronons(it);
        return (chrononHandler != null ? ChrononHandlerKt.getHasRoom(chrononHandler) : false) && it != $stack;
    }
}

