/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.tempad.common.apps;

import earth.terrarium.tempad.api.app.TempadApp;
import earth.terrarium.tempad.api.context.SyncableContext;
import earth.terrarium.tempad.api.locations.TempadLocations;
import earth.terrarium.tempad.common.apps.SettingsData;
import earth.terrarium.tempad.common.registries.ModMenus;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001b\u0012\n\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ \u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00022\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u0013H\u0016J\r\u0010\u001a\u001a\u0006\u0012\u0002\b\u00030\u0004H\u00c6\u0003J\t\u0010\u001b\u001a\u00020\u0006H\u00c6\u0003J!\u0010\u001c\u001a\u00020\u00002\f\b\u0002\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u001d\u001a\u00020\u00062\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u00d6\u0003J\t\u0010 \u001a\u00020\u000fH\u00d6\u0001J\t\u0010!\u001a\u00020\"H\u00d6\u0001R\u0015\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u000b\u00a8\u0006#"}, d2={"Learth/terrarium/tempad/common/apps/SettingsApp;", "Learth/terrarium/tempad/api/app/TempadApp;", "Learth/terrarium/tempad/common/apps/SettingsData;", "ctx", "Learth/terrarium/tempad/api/context/SyncableContext;", "isStationary", "", "<init>", "(Learth/terrarium/tempad/api/context/SyncableContext;Z)V", "getCtx", "()Learth/terrarium/tempad/api/context/SyncableContext;", "()Z", "createMenu", "Lnet/minecraft/world/inventory/AbstractContainerMenu;", "pContainerId", "", "pPlayerInventory", "Lnet/minecraft/world/entity/player/Inventory;", "pPlayer", "Lnet/minecraft/world/entity/player/Player;", "getDisplayName", "Lnet/minecraft/network/chat/Component;", "createContent", "player", "Lnet/minecraft/server/level/ServerPlayer;", "isEnabled", "component1", "component2", "copy", "equals", "other", "", "hashCode", "toString", "", "tempad-1.21.1"})
public final class SettingsApp
implements TempadApp<SettingsData> {
    @NotNull
    private final SyncableContext<?> ctx;
    private final boolean isStationary;

    public SettingsApp(@NotNull SyncableContext<?> ctx2, boolean isStationary) {
        Intrinsics.checkNotNullParameter(ctx2, (String)"ctx");
        this.ctx = ctx2;
        this.isStationary = isStationary;
    }

    @NotNull
    public final SyncableContext<?> getCtx() {
        return this.ctx;
    }

    public final boolean isStationary() {
        return this.isStationary;
    }

    @NotNull
    public AbstractContainerMenu createMenu(int pContainerId, @NotNull Inventory pPlayerInventory, @NotNull Player pPlayer) {
        Intrinsics.checkNotNullParameter((Object)pPlayerInventory, (String)"pPlayerInventory");
        Intrinsics.checkNotNullParameter((Object)pPlayer, (String)"pPlayer");
        Optional<SettingsData> optional = Optional.of(new SettingsData(TempadLocations.INSTANCE.getRegistry().keySet(), this.isStationary, this.ctx.getHolder()));
        Intrinsics.checkNotNullExpressionValue(optional, (String)"of(...)");
        return new ModMenus.SettingsMenu(pContainerId, pPlayerInventory, optional);
    }

    @NotNull
    public Component getDisplayName() {
        MutableComponent mutableComponent = Component.translatable((String)"app.tempad.settings");
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"translatable(...)");
        return (Component)mutableComponent;
    }

    @NotNull
    public SettingsData createContent(@NotNull ServerPlayer player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        return new SettingsData(TempadLocations.INSTANCE.getRegistry().keySet(), this.isStationary, this.ctx.getHolder());
    }

    @Override
    public boolean isEnabled(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        return true;
    }

    @NotNull
    public final SyncableContext<?> component1() {
        return this.ctx;
    }

    public final boolean component2() {
        return this.isStationary;
    }

    @NotNull
    public final SettingsApp copy(@NotNull SyncableContext<?> ctx2, boolean isStationary) {
        Intrinsics.checkNotNullParameter(ctx2, (String)"ctx");
        return new SettingsApp(ctx2, isStationary);
    }

    public static /* synthetic */ SettingsApp copy$default(SettingsApp settingsApp, SyncableContext syncableContext, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            syncableContext = settingsApp.ctx;
        }
        if ((n & 2) != 0) {
            bl = settingsApp.isStationary;
        }
        return settingsApp.copy(syncableContext, bl);
    }

    @NotNull
    public String toString() {
        return "SettingsApp(ctx=" + this.ctx + ", isStationary=" + this.isStationary + ")";
    }

    public int hashCode() {
        int result = this.ctx.hashCode();
        result = result * 31 + Boolean.hashCode(this.isStationary);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SettingsApp)) {
            return false;
        }
        SettingsApp settingsApp = (SettingsApp)other;
        if (!Intrinsics.areEqual(this.ctx, settingsApp.ctx)) {
            return false;
        }
        return this.isStationary == settingsApp.isStationary;
    }
}

