/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.mixins;

import net.mehvahdjukaar.moonlight.api.platform.ForgeHelper;
import net.mehvahdjukaar.supplementaries.common.block.IConvertableHorse;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.animal.horse.SkeletonHorse;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={SkeletonHorse.class})
public abstract class SkellyHorseMixin
extends AbstractHorse
implements IConvertableHorse {
    @Unique
    private int supplementaries$fleshCount = 0;
    @Unique
    private int supplementaries$conversionTime = -1;

    protected SkellyHorseMixin(EntityType<? extends AbstractHorse> entityType, Level level) {
        super(entityType, level);
    }

    @Inject(method={"addAdditionalSaveData(Lnet/minecraft/nbt/CompoundTag;)V"}, at={@At(value="TAIL")})
    public void addAdditionalSaveData(CompoundTag compoundNBT, CallbackInfo ci) {
        compoundNBT.putInt("FleshCount", this.supplementaries$fleshCount);
        compoundNBT.putInt("ConversionTime", this.supplementaries$conversionTime);
    }

    @Inject(method={"readAdditionalSaveData(Lnet/minecraft/nbt/CompoundTag;)V"}, at={@At(value="TAIL")})
    public void readAdditionalSaveData(CompoundTag compoundNBT, CallbackInfo ci) {
        this.supplementaries$fleshCount = compoundNBT.getInt("FleshCount");
        this.supplementaries$conversionTime = compoundNBT.getInt("ConversionTime");
    }

    @Inject(method={"mobInteract(Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/InteractionHand;)Lnet/minecraft/world/InteractionResult;"}, at={@At(value="HEAD")}, cancellable=true)
    public void mobInteract(Player player, InteractionHand hand, CallbackInfoReturnable<InteractionResult> cir) {
        ItemStack stack;
        if (CommonConfigs.Tweaks.ZOMBIE_HORSE.get().booleanValue() && this.isTamed() && !this.isBaby() && (stack = player.getItemInHand(hand)).getItem() == Items.ROTTEN_FLESH && this.supplementaries$fleshCount < CommonConfigs.Tweaks.ZOMBIE_HORSE_COST.get()) {
            this.supp$feedRottenFlesh(player, hand, stack);
            cir.cancel();
            cir.setReturnValue((Object)InteractionResult.sidedSuccess((boolean)player.level().isClientSide));
        }
    }

    @Nullable
    protected SoundEvent getEatingSound() {
        return SoundEvents.HORSE_EAT;
    }

    @Unique
    public void supp$feedRottenFlesh(Player player, InteractionHand hand, ItemStack stack) {
        float heal = 0.5f;
        if (this.getHealth() < this.getMaxHealth()) {
            this.heal(heal);
        }
        this.setEating(true);
        ++this.supplementaries$fleshCount;
        if (this.supplementaries$fleshCount >= CommonConfigs.Tweaks.ZOMBIE_HORSE_COST.get()) {
            this.supplementaries$conversionTime = 200;
            this.level().broadcastEntityEvent((Entity)this, (byte)16);
        }
        stack.consume(1, (LivingEntity)player);
    }

    @Override
    public boolean supp$isConverting() {
        return this.supplementaries$conversionTime > 0;
    }

    @Unique
    private void supp$doZombieConversion() {
        float yBodyRot = this.yBodyRot;
        float yHeadRot = this.yHeadRot;
        float yBodyRotO = this.yBodyRotO;
        float yHeadRotO = this.yHeadRotO;
        AbstractHorse newHorse = (AbstractHorse)this.convertTo(EntityType.ZOMBIE_HORSE, true);
        if (newHorse != null) {
            newHorse.yBodyRot = yBodyRot;
            newHorse.yHeadRot = yHeadRot;
            newHorse.yHeadRotO = yHeadRotO;
            newHorse.setOwnerUUID(this.getOwnerUUID());
            newHorse.setTamed(this.isTamed());
            newHorse.addEffect(new MobEffectInstance(MobEffects.CONFUSION, 200, 0));
            if (this.isSaddled()) {
                newHorse.equipSaddle(new ItemStack((ItemLike)Items.SADDLE), null);
            }
            for (EquipmentSlot slot : EquipmentSlot.values()) {
                ItemStack itemstack = this.getItemBySlot(slot);
                if (itemstack.isEmpty()) continue;
                if (EnchantmentHelper.has((ItemStack)itemstack, (DataComponentType)EnchantmentEffectComponents.PREVENT_ARMOR_CHANGE)) {
                    newHorse.getSlot(slot.getIndex() + 300).set(itemstack);
                    continue;
                }
                double d0 = this.getEquipmentDropChance(slot);
                if (!(d0 > 1.0)) continue;
                this.spawnAtLocation(itemstack);
            }
            ForgeHelper.fireOnLivingConvert((LivingEntity)this, (LivingEntity)newHorse);
        }
        if (!this.isSilent()) {
            this.level().levelEvent(null, 1027, this.blockPosition(), 0);
        }
    }

    public void handleEntityEvent(byte id) {
        if (id == 16) {
            if (!this.isSilent()) {
                this.level().playLocalSound(this.getX(), this.getEyeY(), this.getZ(), SoundEvents.ZOMBIE_VILLAGER_CURE, this.getSoundSource(), 1.0f + this.random.nextFloat(), this.random.nextFloat() * 0.7f + 0.3f, false);
            }
        } else {
            super.handleEntityEvent(id);
        }
    }

    public void tick() {
        super.tick();
        if (!this.level().isClientSide && this.isAlive() && !this.isNoAi() && this.supp$isConverting()) {
            --this.supplementaries$conversionTime;
            if (this.supplementaries$conversionTime <= 0 && ForgeHelper.canLivingConvert((LivingEntity)this, (EntityType)EntityType.ZOMBIE_HORSE, timer -> {
                this.supplementaries$conversionTime = timer;
            })) {
                this.supp$doZombieConversion();
            }
        }
    }
}

