/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.integration.neoforge;

import dan200.computercraft.api.ForgeComputerCraftAPI;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.shared.media.items.PrintoutData;
import dan200.computercraft.shared.media.items.PrintoutItem;
import java.util.Objects;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.common.block.tiles.SpeakerBlockTile;
import net.mehvahdjukaar.supplementaries.neoforge.SupplementariesForge;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponentHolder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CCCompatImpl {
    protected static BlockCapability<SpeakerPeripheral, Direction> CAP = BlockCapability.createSided((ResourceLocation)Supplementaries.res("speaker_block"), SpeakerPeripheral.class);

    public static void init() {
        ((IEventBus)SupplementariesForge.modBus.get()).addListener(CCCompatImpl::registerCap);
    }

    public static void setup() {
        ForgeComputerCraftAPI.registerGenericCapability(CAP);
    }

    public static void registerCap(RegisterCapabilitiesEvent event) {
        event.registerBlockEntity(CAP, ModRegistry.SPEAKER_BLOCK_TILE.get(), (tile, object2) -> new SpeakerPeripheral((SpeakerBlockTile)tile));
    }

    public static int getPages(ItemStack itemstack) {
        return PrintoutData.getOrEmpty((DataComponentHolder)itemstack).pages();
    }

    public static String[] getText(ItemStack itemstack) {
        return (String[])PrintoutData.getOrEmpty((DataComponentHolder)itemstack).lines().stream().map(PrintoutData.Line::text).toArray(String[]::new);
    }

    public static boolean isPrintedBook(Item item) {
        return item instanceof PrintoutItem;
    }

    public static final class SpeakerPeripheral
    implements IPeripheral {
        private final SpeakerBlockTile tile;

        public SpeakerPeripheral(SpeakerBlockTile tile) {
            this.tile = tile;
        }

        @LuaFunction
        public void setNarrator(SpeakerBlockTile.Mode mode) {
            this.tile.setMode(mode);
            this.tile.setChanged();
        }

        @LuaFunction
        public SpeakerBlockTile.Mode getMode() {
            return this.tile.getMode();
        }

        @LuaFunction
        public void setMessage(String message) {
            this.tile.setMessage((Component)Component.literal((String)message));
            this.tile.setChanged();
        }

        @LuaFunction
        public String getMessage() {
            return this.tile.getMessage(false).getString();
        }

        @LuaFunction
        public void setName(String name) {
            this.tile.setCustomName((Component)Component.literal((String)name));
            this.tile.setChanged();
        }

        @LuaFunction
        public String getName() {
            return this.tile.getName().getString();
        }

        @LuaFunction
        public double getVolume() {
            return this.tile.getVolume();
        }

        @LuaFunction
        public void setVolume(double volume) {
            this.tile.setVolume(volume);
            this.tile.setChanged();
        }

        @LuaFunction
        public void activate() {
            this.tile.sendMessage();
        }

        @NotNull
        public String getType() {
            return "speaker_block";
        }

        public boolean equals(@Nullable IPeripheral other) {
            return Objects.equals(this, other);
        }

        public SpeakerBlockTile tile() {
            return this.tile;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            SpeakerPeripheral that = (SpeakerPeripheral)obj;
            return Objects.equals(this.tile, that.tile);
        }

        public int hashCode() {
            return Objects.hash(this.tile);
        }

        public String toString() {
            return "SpeakerPeripheral[tile=" + String.valueOf(this.tile) + "]";
        }
    }
}

