/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.worldgen;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Consumer;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.ChunkGeneratorStructureState;
import net.minecraft.world.level.chunk.StructureAccess;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureCheckResult;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.levelgen.structure.placement.ConcentricRingsStructurePlacement;
import net.minecraft.world.level.levelgen.structure.placement.RandomSpreadStructurePlacement;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector2i;

public class StructureLocator {
    private static final Comparator<Vector2i> COMPARATOR = (o1, o2) -> Float.compare(o1.lengthSquared(), o2.lengthSquared());

    @Nullable
    public static LocatedStruct findNearestRandomMapFeature(ServerLevel level, @NotNull HolderSet<Structure> targets, BlockPos pos, int maximumChunkDistance, boolean newlyGenerated) {
        boolean rand;
        List<LocatedStruct> found = StructureLocator.findNearestMapFeatures(level, targets, pos, maximumChunkDistance, newlyGenerated, 1, rand, !(rand = CommonConfigs.Tweaks.RANDOM_ADVENTURER_MAPS_RANDOM.get().booleanValue()));
        if (!found.isEmpty()) {
            return found.get(0);
        }
        return null;
    }

    public static List<LocatedStruct> findNearestMapFeatures(ServerLevel level, @NotNull TagKey<Structure> tagKey, BlockPos pos, int maximumChunkDistance, boolean newlyGenerated, int requiredCount, int maxSearches) {
        HolderSet targets = level.registryAccess().registryOrThrow(Registries.STRUCTURE).getTag(tagKey).orElse(null);
        if (targets == null) {
            return List.of();
        }
        if (targets.size() > maxSearches) {
            ArrayList list = new ArrayList(targets.stream().toList());
            Collections.shuffle(list);
            targets = HolderSet.direct(list.subList(0, maxSearches));
        }
        return StructureLocator.findNearestMapFeatures(level, (HolderSet<Structure>)targets, pos, maximumChunkDistance, newlyGenerated, requiredCount, false, false);
    }

    public static List<LocatedStruct> findNearestMapFeatures(ServerLevel level, HolderSet<Structure> taggedStructures, BlockPos pos, int maximumChunkDistance, boolean newlyGenerated, int requiredCount, boolean selectRandom, boolean exitEarly) {
        int n;
        List<LocatedStruct> foundStructures = new ArrayList<LocatedStruct>();
        if (!level.getServer().getWorldData().worldGenOptions().generateStructures()) {
            return foundStructures;
        }
        if (taggedStructures.size() == 0) {
            Supplementaries.LOGGER.error("Found empty target structures for structure map. Its likely some mod broke some vanilla tag. Check your logs!");
            return foundStructures;
        }
        List<Object> selectedTargets = taggedStructures.stream().toList();
        ChunkGenerator chunkGenerator = level.getChunkSource().getGenerator();
        double maxDist = Double.MAX_VALUE;
        if (selectRandom) {
            Holder selected = (Holder)selectedTargets.get(level.random.nextInt(selectedTargets.size()));
            selectedTargets = List.of(selected);
            Supplementaries.LOGGER.info("Searching for structure {} from pos {}", selected.unwrapKey().get(), (Object)pos);
        } else {
            selectedTargets = new ArrayList(selectedTargets);
            Collections.shuffle(selectedTargets);
            Supplementaries.LOGGER.info("Searching for closest structure among {} from pos {}", (Object)Arrays.toString(selectedTargets.stream().map(e -> (ResourceKey)e.unwrapKey().get()).toArray()), (Object)pos);
        }
        Object2ObjectArrayMap reachableTargetsMap = new Object2ObjectArrayMap();
        ChunkGeneratorStructureState structureState = level.getChunkSource().getGeneratorState();
        for (Holder holder : selectedTargets) {
            for (Object structureplacement : structureState.getPlacementsForStructure(holder)) {
                reachableTargetsMap.computeIfAbsent(structureplacement, placement -> new ObjectArraySet()).add(holder);
            }
        }
        if (reachableTargetsMap.isEmpty()) {
            return foundStructures;
        }
        ArrayList<Pair> list = new ArrayList<Pair>(reachableTargetsMap.size());
        boolean bl = true;
        StructureManager structuremanager = level.structureManager();
        for (Map.Entry entry : reachableTargetsMap.entrySet()) {
            StructurePlacement placement2 = (StructurePlacement)entry.getKey();
            if (placement2 instanceof ConcentricRingsStructurePlacement) {
                double d1;
                ConcentricRingsStructurePlacement concentricringsstructureplacement = (ConcentricRingsStructurePlacement)placement2;
                Pair foundPair = chunkGenerator.getNearestGeneratedStructure((Set)entry.getValue(), level, structuremanager, pos, newlyGenerated, concentricringsstructureplacement);
                if (foundPair == null || !((d1 = pos.distSqr((Vec3i)foundPair.getFirst())) < maxDist)) continue;
                maxDist = d1;
                foundStructures.add(new LocatedStruct((Pair<BlockPos, Holder<Structure>>)foundPair));
                continue;
            }
            if (!(placement2 instanceof RandomSpreadStructurePlacement)) continue;
            RandomSpreadStructurePlacement randomPlacement = (RandomSpreadStructurePlacement)placement2;
            list.add(Pair.of((Object)randomPlacement, (Object)((Set)entry.getValue())));
            n = Math.max(n, randomPlacement.spacing());
        }
        if (!list.isEmpty()) {
            int chunkX = SectionPos.blockToSectionCoord((int)pos.getX());
            int n2 = SectionPos.blockToSectionCoord((int)pos.getZ());
            long seed = level.getSeed();
            StructureManager manager = level.structureManager();
            block3: for (int k = 0; k <= maximumChunkDistance / n; ++k) {
                int outerRing = (k + 1) * n;
                int innerRing = k * n;
                boolean lessPrecision = innerRing * 16 > 2000;
                TreeMap possiblePositions = new TreeMap(COMPARATOR);
                for (Pair pair : list) {
                    RandomSpreadStructurePlacement placement3 = (RandomSpreadStructurePlacement)pair.getFirst();
                    int spacing = placement3.spacing();
                    for (int r = innerRing; r < outerRing; r += spacing) {
                        StructureLocator.addAllPossibleFeatureChunksAtDistance(chunkX, n2, r, seed, placement3, c -> {
                            List ll;
                            Vector2i v = new Vector2i(c.x - chunkX, c.z - chunkZ);
                            if (possiblePositions.containsKey(v)) {
                                boolean bl = true;
                            }
                            if ((ll = possiblePositions.computeIfAbsent(v, o -> new ArrayList())).contains(p)) {
                                boolean bl = true;
                            } else {
                                ll.add(p);
                            }
                        });
                    }
                }
                for (Map.Entry entry : possiblePositions.entrySet()) {
                    Vector2i vec2i = (Vector2i)entry.getKey();
                    ChunkPos chunkPos = new ChunkPos(vec2i.x() + chunkX, vec2i.y() + n2);
                    List structuresThatCanSpawnAtChunkPos = (List)entry.getValue();
                    for (Pair pp : structuresThatCanSpawnAtChunkPos) {
                        foundStructures.addAll(StructureLocator.getStructuresAtChunkPos((Set)pp.getSecond(), (LevelReader)level, manager, newlyGenerated, (RandomSpreadStructurePlacement)pp.getFirst(), chunkPos));
                    }
                    if (foundStructures.size() < requiredCount) continue;
                    break block3;
                }
            }
        }
        foundStructures.sort(Comparator.comparingDouble(f -> pos.distSqr((Vec3i)f.pos)));
        if (foundStructures.size() >= requiredCount) {
            foundStructures = (List)Lists.partition(foundStructures, (int)requiredCount).get(0);
        }
        if (newlyGenerated) {
            for (LocatedStruct locatedStruct : foundStructures) {
                if (locatedStruct.start == null || !locatedStruct.start.canBeReferenced()) continue;
                structuremanager.addReference(locatedStruct.start);
            }
        }
        return foundStructures;
    }

    private static void addAllPossibleFeatureChunksAtDistance(int chunkX, int chunkZ, int radius, long seed, RandomSpreadStructurePlacement placement, Consumer<ChunkPos> positionConsumer) {
        for (int j = -radius; j <= radius; ++j) {
            boolean flag = j == -radius || j == radius;
            for (int k = -radius; k <= radius; ++k) {
                boolean flag1;
                boolean bl = flag1 = k == -radius || k == radius;
                if (!flag && !flag1) continue;
                int px = chunkX + j;
                int pz = chunkZ + k;
                ChunkPos chunkpos = placement.getPotentialStructureChunk(seed, px, pz);
                positionConsumer.accept(chunkpos);
            }
        }
    }

    private static Set<LocatedStruct> getStructuresAtChunkPos(Set<Holder<Structure>> targets, LevelReader level, StructureManager structureManager, boolean skipKnown, RandomSpreadStructurePlacement placement, ChunkPos chunkpos) {
        HashSet<LocatedStruct> foundStructures = new HashSet<LocatedStruct>();
        for (Holder<Structure> holder : targets) {
            StructureCheckResult structurecheckresult = structureManager.checkStructurePresence(chunkpos, (Structure)holder.value(), (StructurePlacement)placement, skipKnown);
            if (structurecheckresult == StructureCheckResult.START_NOT_PRESENT) continue;
            if (!skipKnown && structurecheckresult == StructureCheckResult.START_PRESENT) {
                foundStructures.add(new LocatedStruct(placement.getLocatePos(chunkpos), holder, null));
                continue;
            }
            ChunkAccess chunkaccess = level.getChunk(chunkpos.x, chunkpos.z, ChunkStatus.STRUCTURE_STARTS);
            StructureStart structurestart = structureManager.getStartForStructure(SectionPos.bottomOf((ChunkAccess)chunkaccess), (Structure)holder.value(), (StructureAccess)chunkaccess);
            if (structurestart == null || !structurestart.isValid() || skipKnown && !structurestart.canBeReferenced()) continue;
            foundStructures.add(new LocatedStruct(placement.getLocatePos(structurestart.getChunkPos()), holder, structurestart));
        }
        return foundStructures;
    }

    @Nullable
    private static Set<LocatedStruct> getNearestGeneratedStructureAtDistance(Set<Holder<Structure>> targets, LevelReader level, StructureManager featureManager, int x, int z, int distance, boolean newChunk, long seed, RandomSpreadStructurePlacement placement) {
        int i = placement.spacing();
        for (int j = -distance; j <= distance; ++j) {
            boolean flag = j == -distance || j == distance;
            for (int k = -distance; k <= distance; ++k) {
                boolean flag1;
                boolean bl = flag1 = k == -distance || k == distance;
                if (!flag && !flag1) continue;
                int px = x + i * j;
                int pz = z + i * k;
                ChunkPos chunkpos = placement.getPotentialStructureChunk(seed, px, pz);
                return StructureLocator.getStructuresAtChunkPos(targets, level, featureManager, newChunk, placement, chunkpos);
            }
        }
        return null;
    }

    @Nullable
    public BlockPos findRandomMapFeature(TagKey<Structure> tagKey, BlockPos pos, int radius, boolean unexplored, ServerLevel level) {
        if (!level.getServer().getWorldData().worldGenOptions().generateStructures()) {
            return null;
        }
        Optional optional = level.registryAccess().registryOrThrow(Registries.STRUCTURE).getTag(tagKey);
        if (optional.isEmpty()) {
            return null;
        }
        HolderSet.Named set = (HolderSet.Named)optional.get();
        List list = set.stream().toList();
        Holder chosen = (Holder)list.get(level.random.nextInt(list.size()));
        Pair pair = level.getChunkSource().getGenerator().findNearestMapStructure(level, (HolderSet)HolderSet.direct((Holder[])new Holder[]{chosen}), pos, radius, unexplored);
        return pair != null ? (BlockPos)pair.getFirst() : null;
    }

    public record LocatedStruct(BlockPos pos, Holder<Structure> structure, @Nullable StructureStart start) {
        public LocatedStruct(Pair<BlockPos, Holder<Structure>> pair) {
            this((BlockPos)pair.getFirst(), (Holder<Structure>)((Holder)pair.getSecond()), null);
        }
    }
}

