/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.network;

import net.mehvahdjukaar.moonlight.api.platform.network.Message;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.common.block.tiles.CannonBlockTile;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public record ServerBoundSyncCannonPacket(float yaw, float pitch, byte firePower, boolean fire, BlockPos pos, boolean stopControlling) implements Message
{
    public static final CustomPacketPayload.TypeAndCodec<RegistryFriendlyByteBuf, ServerBoundSyncCannonPacket> CODEC = Message.makeType((ResourceLocation)Supplementaries.res("c2s_sync_cannon"), ServerBoundSyncCannonPacket::new);

    public ServerBoundSyncCannonPacket(FriendlyByteBuf buf) {
        this(buf.readFloat(), buf.readFloat(), buf.readByte(), buf.readBoolean(), buf.readBlockPos(), buf.readBoolean());
    }

    public void write(RegistryFriendlyByteBuf buf) {
        buf.writeFloat(this.yaw);
        buf.writeFloat(this.pitch);
        buf.writeByte((int)this.firePower);
        buf.writeBoolean(this.fire);
        buf.writeBlockPos(this.pos);
        buf.writeBoolean(this.stopControlling);
    }

    public void handle(Message.Context context) {
        CannonBlockTile cannon;
        ServerPlayer player;
        Level level;
        BlockEntity blockEntity;
        Player player2 = context.getPlayer();
        if (player2 instanceof ServerPlayer && (blockEntity = (level = (player = (ServerPlayer)player2).level()).getBlockEntity(this.pos)) instanceof CannonBlockTile && (cannon = (CannonBlockTile)blockEntity).isEditingPlayer((Player)player)) {
            cannon.setAttributes(this.yaw, this.pitch, this.firePower, this.fire, (Player)player);
            cannon.setChanged();
            if (this.stopControlling) {
                cannon.setPlayerWhoMayEdit(null);
            }
            level.sendBlockUpdated(this.pos, cannon.getBlockState(), cannon.getBlockState(), 3);
            return;
        }
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return CODEC.type();
    }
}

