/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.entities;

import com.mojang.authlib.GameProfile;
import java.util.UUID;
import net.mehvahdjukaar.moonlight.api.entity.ImprovedProjectileEntity;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.util.FakePlayerManager;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.supplementaries.common.block.fire_behaviors.ProjectileStats;
import net.mehvahdjukaar.supplementaries.integration.CompatHandler;
import net.mehvahdjukaar.supplementaries.integration.FlanCompat;
import net.mehvahdjukaar.supplementaries.reg.ModEntities;
import net.mehvahdjukaar.supplementaries.reg.ModTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class ThrowableBrickEntity
extends ImprovedProjectileEntity {
    private static final GameProfile BRICK_PLAYER = new GameProfile(UUID.randomUUID(), "Throwable Brick Fake Player");

    public ThrowableBrickEntity(EntityType<? extends ThrowableBrickEntity> type, Level world) {
        super(type, world);
    }

    public ThrowableBrickEntity(LivingEntity throwerIn) {
        super(ModEntities.THROWABLE_BRICK.get(), throwerIn, throwerIn.level());
    }

    public ThrowableBrickEntity(Level worldIn, double x, double y, double z) {
        super(ModEntities.THROWABLE_BRICK.get(), x, y, z, worldIn);
    }

    protected Component getTypeName() {
        return this.getItem().getDisplayName();
    }

    protected Item getDefaultItem() {
        return Items.BRICK;
    }

    private ParticleOptions makeParticle() {
        ItemStack itemstack = this.getItem();
        return itemstack.isEmpty() ? new ItemParticleOption(ParticleTypes.ITEM, new ItemStack((ItemLike)this.getDefaultItem())) : new ItemParticleOption(ParticleTypes.ITEM, itemstack);
    }

    public void handleEntityEvent(byte id) {
        if (id == 3) {
            ParticleOptions particle = this.makeParticle();
            for (int i = 0; i < 8; ++i) {
                this.level().addParticle(particle, this.getX(), this.getY(), this.getZ(), 0.0, 0.0, 0.0);
            }
        }
    }

    protected void onHitBlock(BlockHitResult rayTraceResult) {
        super.onHitBlock(rayTraceResult);
        Level level = this.level();
        if (!level.isClientSide) {
            Entity entity = this.getOwner();
            BlockPos pos = rayTraceResult.getBlockPos();
            if (entity instanceof Player) {
                Player player = (Player)entity;
                if (CompatHandler.FLAN && !FlanCompat.canBreak(player, pos)) {
                    return;
                }
                if (!Utils.mayPerformBlockAction((Player)player, (BlockPos)pos, (ItemStack)this.getItem())) {
                    return;
                }
            }
            if (!(entity instanceof Mob) || level.getGameRules().getBoolean(GameRules.RULE_MOBGRIEFING) || PlatHelper.isMobGriefingOn((Level)level, (Entity)this)) {
                Player p = FakePlayerManager.get((GameProfile)BRICK_PLAYER, (Level)level);
                p.setItemInHand(InteractionHand.MAIN_HAND, Items.IRON_PICKAXE.getDefaultInstance());
                if (level.getBlockState(pos).is(ModTags.BRICK_BREAKABLE_POTS)) {
                    level.destroyBlock(pos, true, (Entity)p);
                } else {
                    this.breakGlass(pos, 6, p);
                }
            }
        }
    }

    private void breakGlass(BlockPos pos, int chance, Player p) {
        int c = chance - 1 - this.random.nextInt(4);
        BlockState state = this.level().getBlockState(pos);
        if (state.getBlock().getExplosionResistance() > 3.0f) {
            return;
        }
        if (c < 0 || !state.is(ModTags.BRICK_BREAKABLE_GLASS)) {
            return;
        }
        this.level().destroyBlock(pos, true, (Entity)p);
        this.breakGlass(pos.above(), c, p);
        this.breakGlass(pos.below(), c, p);
        this.breakGlass(pos.east(), c, p);
        this.breakGlass(pos.west(), c, p);
        this.breakGlass(pos.north(), c, p);
        this.breakGlass(pos.south(), c, p);
    }

    protected void onHitEntity(EntityHitResult entityHitResult) {
        super.onHitEntity(entityHitResult);
        Entity entity = entityHitResult.getEntity();
        boolean i = true;
        entity.hurt(this.level().damageSources().thrown((Entity)this, this.getOwner()), (float)i);
    }

    protected void onHit(HitResult result) {
        super.onHit(result);
        if (!this.level().isClientSide) {
            Vec3 v = result.getLocation();
            this.level().playSound(null, v.x, v.y, v.z, SoundEvents.NETHER_BRICKS_BREAK, SoundSource.NEUTRAL, 0.75f, 1.0f);
            this.level().broadcastEntityEvent((Entity)this, (byte)3);
            this.remove(Entity.RemovalReason.DISCARDED);
        }
    }

    protected void updateRotation() {
    }

    public float getDefaultShootVelocity() {
        return ProjectileStats.BRICKS_SPEED;
    }

    protected double getDefaultGravity() {
        return ProjectileStats.BRICKS_GRAVITY;
    }
}

