/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.tiles;

import net.mehvahdjukaar.moonlight.api.platform.ForgeHelper;
import net.mehvahdjukaar.supplementaries.common.block.blocks.TurnTableBlock;
import net.mehvahdjukaar.supplementaries.common.utils.BlockUtil;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.mehvahdjukaar.supplementaries.reg.ModSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RailShape;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class TurnTableBlockTile
extends BlockEntity {
    private int cooldown = 5;
    private boolean canRotate = true;
    private int catTimer = 0;

    public TurnTableBlockTile(BlockPos pos, BlockState state) {
        super(ModRegistry.TURN_TABLE_TILE.get(), pos, state);
    }

    public void tryRotate() {
        this.canRotate = true;
        this.cooldown = TurnTableBlock.getPeriod(this.getBlockState());
    }

    public int getCatTimer() {
        return this.catTimer;
    }

    public void setCat() {
        this.catTimer = 400;
    }

    public static void tick(Level level, BlockPos pos, BlockState state, TurnTableBlockTile tile) {
        tile.catTimer = Math.max(tile.catTimer - 1, 0);
        if (tile.cooldown == 0) {
            BlockPos targetPos;
            boolean ccw;
            Direction dir = (Direction)state.getValue((Property)TurnTableBlock.FACING);
            boolean success = BlockUtil.tryRotatingBlock(dir, ccw = (Boolean)state.getValue((Property)TurnTableBlock.INVERTED) ^ state.getValue((Property)TurnTableBlock.FACING) == Direction.DOWN, targetPos = pos.relative(dir), level, null).isPresent();
            if (success) {
                level.blockEvent(pos, state.getBlock(), 0, 0);
                level.gameEvent(null, (Holder)GameEvent.BLOCK_CHANGE, targetPos);
                level.playSound(null, targetPos, ModSounds.BLOCK_ROTATE.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                if (dir == Direction.UP) {
                    tile.tryRotatingMinecartsAbove(level, pos, ccw);
                }
            }
            tile.cooldown = TurnTableBlock.getPeriod(state);
            int power = (Integer)state.getValue((Property)TurnTableBlock.POWER);
            boolean bl = tile.canRotate = success && power != 0;
            if (power == 0) {
                level.setBlock(pos, (BlockState)state.setValue((Property)TurnTableBlock.ROTATING, (Comparable)Boolean.valueOf(false)), 3);
            }
        } else if (tile.canRotate) {
            --tile.cooldown;
        }
    }

    private void tryRotatingMinecartsAbove(Level level, BlockPos pos, boolean ccw) {
        BlockPos above = pos.above();
        BlockState state = level.getBlockState(above);
        Block block = state.getBlock();
        if (block instanceof BaseRailBlock) {
            BaseRailBlock rb = (BaseRailBlock)block;
            for (AbstractMinecart c : level.getEntitiesOfClass(AbstractMinecart.class, new AABB(above))) {
                RailShape shape = ForgeHelper.getRailDirection((BaseRailBlock)rb, (BlockState)state, (Level)level, (BlockPos)above, (AbstractMinecart)c);
                Direction.Axis axis = TurnTableBlockTile.getRailAxis(shape);
                if (axis == Direction.Axis.Y) continue;
                c.setYRot(c.getYRot() + (float)(ccw ? 90 : -90));
                c.yRotO = c.getYRot();
                c.setPos(new Vec3((double)((float)pos.getX() + 0.5f), c.getY(), (double)pos.getZ() + 0.5));
                c.xOld = c.getX();
                c.zOld = c.getZ();
                Vec3 movement = c.getDeltaMovement();
                c.setDeltaMovement(movement.yRot(ccw ? 1.5707964f : -1.5707964f));
            }
        }
    }

    private static Direction.Axis getMinecartMovementAxis(AbstractMinecart m) {
        Vec3 dir = Vec3.directionFromRotation((float)0.0f, (float)m.getYRot());
        return Direction.getNearest((double)dir.x, (double)dir.y, (double)dir.z).getAxis();
    }

    private static Direction.Axis getRailAxis(RailShape rail) {
        return switch (rail) {
            case RailShape.EAST_WEST, RailShape.ASCENDING_WEST, RailShape.ASCENDING_EAST -> Direction.Axis.X;
            case RailShape.NORTH_SOUTH, RailShape.ASCENDING_SOUTH, RailShape.ASCENDING_NORTH -> Direction.Axis.Z;
            default -> Direction.Axis.Y;
        };
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.cooldown = tag.getInt("Cooldown");
        this.canRotate = tag.getBoolean("CanRotate");
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.putInt("Cooldown", this.cooldown);
        tag.putBoolean("CanRotate", this.canRotate);
    }
}

