/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.tiles;

import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.supplementaries.common.block.blocks.PresentBlock;
import net.mehvahdjukaar.supplementaries.common.block.tiles.AbstractPresentBlockTile;
import net.mehvahdjukaar.supplementaries.common.inventories.PresentContainerMenu;
import net.mehvahdjukaar.supplementaries.common.items.components.PresentAddress;
import net.mehvahdjukaar.supplementaries.reg.ModComponents;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.mehvahdjukaar.supplementaries.reg.ModSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.monster.piglin.PiglinAi;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import org.jetbrains.annotations.Nullable;

public class PresentBlockTile
extends AbstractPresentBlockTile {
    public static final String PUBLIC_KEY = "@e";
    private String recipient = "";
    private String sender = "";
    private String description = "";

    public PresentBlockTile(BlockPos pos, BlockState state) {
        super(ModRegistry.PRESENT_TILE.get(), pos, state);
    }

    @Override
    public boolean canHoldItems() {
        return this.isPacked();
    }

    public boolean isPacked() {
        return (Boolean)this.getBlockState().getValue((Property)PresentBlock.PACKED);
    }

    public String getSender() {
        return this.sender;
    }

    public String getDescription() {
        return this.description;
    }

    public String getRecipient() {
        if (this.recipient.equalsIgnoreCase(PUBLIC_KEY)) {
            return "";
        }
        return this.recipient;
    }

    public void setSender(String sender) {
        this.sender = sender.trim();
    }

    public void setRecipient(String recipient) {
        this.recipient = recipient.trim();
    }

    public void setPublic() {
        this.setRecipient(PUBLIC_KEY);
    }

    public void updateState(boolean shouldPack, String newRecipient, String sender, String description, Player playerWhoChanged) {
        if (shouldPack) {
            if (newRecipient.isEmpty()) {
                newRecipient = PUBLIC_KEY;
            }
            this.recipient = newRecipient;
            this.sender = sender;
            this.description = description;
        } else {
            this.recipient = "";
            this.sender = "";
            this.description = "";
        }
        if (!this.level.isClientSide && this.isPacked() != shouldPack) {
            if (shouldPack) {
                this.level.playSound(null, this.worldPosition, ModSounds.PRESENT_PACK.get(), SoundSource.BLOCKS, 1.0f, this.level.random.nextFloat() * 0.1f + 0.95f);
            } else {
                this.level.playSound(null, this.worldPosition, ModSounds.PRESENT_OPEN.get(), SoundSource.BLOCKS, 1.0f, this.level.random.nextFloat() * 0.1f + 1.2f);
            }
            this.level.gameEvent((Entity)playerWhoChanged, (Holder)GameEvent.BLOCK_CHANGE, this.worldPosition);
            this.level.setBlock(this.getBlockPos(), (BlockState)this.getBlockState().setValue((Property)PresentBlock.PACKED, (Comparable)Boolean.valueOf(shouldPack)), 3);
        }
    }

    @Override
    public boolean canPlaceItem(int index, ItemStack stack) {
        return super.canPlaceItem(index, stack) && !this.isPacked();
    }

    public boolean canOpen(Player player) {
        if (!super.canOpen(player)) {
            return false;
        }
        if (!this.isUnused()) {
            return false;
        }
        if (player.isCreative()) {
            return true;
        }
        return this.recipient.isEmpty() || this.recipient.equalsIgnoreCase(PUBLIC_KEY) || this.recipient.equalsIgnoreCase(player.getName().getString()) || this.sender.equalsIgnoreCase(player.getName().getString());
    }

    @Override
    public InteractionResult interact(Level level, BlockPos pos, BlockState state, Player player) {
        if (this.isUnused()) {
            if (this.canOpen(player)) {
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    PlatHelper.openCustomMenu((ServerPlayer)serverPlayer, (MenuProvider)this, (BlockPos)pos);
                    PiglinAi.angerNearbyPiglins((Player)player, (boolean)true);
                }
                return InteractionResult.sidedSuccess((boolean)level.isClientSide);
            }
            player.displayClientMessage((Component)Component.translatable((String)"message.supplementaries.present.info", (Object[])new Object[]{this.recipient}), true);
            return InteractionResult.FAIL;
        }
        return InteractionResult.PASS;
    }

    public Component getDefaultName() {
        return Component.translatable((String)"gui.supplementaries.present");
    }

    @Override
    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.recipient = "";
        this.sender = "";
        this.description = "";
        if (tag.contains("Recipient")) {
            this.recipient = tag.getString("Recipient");
        }
        if (tag.contains("Sender")) {
            this.sender = tag.getString("Sender");
        }
        if (tag.contains("Description")) {
            this.description = tag.getString("Description");
        }
        if (this.level != null && !this.level.isClientSide) {
            boolean empty = this.getItem(0).isEmpty();
            this.level.setBlock(this.getBlockPos(), (BlockState)this.getBlockState().setValue((Property)PresentBlock.PACKED, (Comparable)Boolean.valueOf(!empty)), 3);
        }
    }

    @Override
    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        if (!this.recipient.isEmpty()) {
            tag.putString("Recipient", this.recipient);
        }
        if (!this.sender.isEmpty()) {
            tag.putString("Sender", this.sender);
        }
        if (!this.description.isEmpty()) {
            tag.putString("Description", this.description);
        }
    }

    protected void collectImplicitComponents(DataComponentMap.Builder components) {
        super.collectImplicitComponents(components);
        PresentAddress address = PresentAddress.of(this.recipient, this.sender, this.description);
        if (address != null) {
            components.set(ModComponents.ADDRESS.get(), (Object)address);
        }
    }

    protected void applyImplicitComponents(BlockEntity.DataComponentInput componentInput) {
        super.applyImplicitComponents(componentInput);
        PresentAddress address = (PresentAddress)componentInput.get(ModComponents.ADDRESS.get());
        if (address != null) {
            this.recipient = address.recipient();
            this.sender = address.sender();
            this.description = address.description();
        }
    }

    public void removeComponentsFromTag(CompoundTag tag) {
        super.removeComponentsFromTag(tag);
        tag.remove("Recipient");
        tag.remove("Sender");
        tag.remove("Description");
    }

    public AbstractContainerMenu createMenu(int id, Inventory inv) {
        if (inv.player.isSpectator()) {
            return null;
        }
        return new PresentContainerMenu(id, inv, this);
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        return this.saveWithoutMetadata(registries);
    }
}

