/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.tiles;

import net.mehvahdjukaar.moonlight.api.block.MimicBlockTile;
import net.mehvahdjukaar.moonlight.api.platform.ForgeHelper;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.supplementaries.common.block.blocks.FeatherBlock;
import net.mehvahdjukaar.supplementaries.common.block.blocks.FrameBlock;
import net.mehvahdjukaar.supplementaries.common.block.blocks.IFrameBlock;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.mehvahdjukaar.supplementaries.reg.ModTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SoulSandBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class FrameBlockTile
extends MimicBlockTile {
    public FrameBlockTile(BlockPos pos, BlockState state) {
        super(ModRegistry.TIMBER_FRAME_TILE.get(), pos, state);
    }

    public boolean setHeldBlock(BlockState state) {
        this.mimic = state;
        if (this.level instanceof ServerLevel) {
            this.setChanged();
            int newLight = ForgeHelper.getLightEmission((BlockState)this.getHeldBlock(), (Level)this.level, (BlockPos)this.worldPosition);
            this.level.setBlock(this.worldPosition, (BlockState)((BlockState)((BlockState)this.getBlockState().setValue((Property)FrameBlock.HAS_BLOCK, (Comparable)Boolean.valueOf(true))).setValue((Property)FrameBlock.WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue((Property)FrameBlock.LIGHT_LEVEL, (Comparable)Integer.valueOf(newLight)), 3);
            this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 2);
        }
        return true;
    }

    public BlockState acceptBlock(BlockState state) {
        IFrameBlock fb;
        Block s;
        Block block;
        Block b = state.getBlock();
        if (b == ModRegistry.DAUB.get() && CommonConfigs.Building.REPLACE_DAUB.get().booleanValue() && this.level != null && !this.level.isClientSide && (block = this.getBlockState().getBlock()) instanceof IFrameBlock && (s = (fb = (IFrameBlock)block).getFilledBlock(state.getBlock())) != null) {
            state = s.withPropertiesOf(this.getBlockState());
            this.level.setBlock(this.worldPosition, state, 3);
            return state;
        }
        this.setHeldBlock(state);
        if (this.level != null && this.level.isClientSide) {
            this.requestModelReload();
        }
        return state;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ItemInteractionResult interactWithPlayer(Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult trace, ItemStack stack, boolean canStrip) {
        Item item = stack.getItem();
        if (!Utils.mayPerformBlockAction((Player)player, (BlockPos)pos, (ItemStack)stack) || trace.isInside()) return ItemInteractionResult.FAIL;
        if (item instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            if (this.getHeldBlock().isAir()) {
                BlockState toPlace;
                SelfPlacementContext context = new SelfPlacementContext(player, hand, stack, trace);
                if (!context.getClickedPos().equals((Object)pos) || !FrameBlockTile.isValidBlock(toPlace = blockItem.getBlock().getStateForPlacement((BlockPlaceContext)context), pos, level)) return ItemInteractionResult.FAIL;
                if (((BlockItem)item).getBlock() instanceof SlabBlock) {
                    boolean bl = true;
                }
                BlockState newState = this.acceptBlock(toPlace);
                SoundType s = newState.getSoundType();
                level.gameEvent((Entity)player, (Holder)GameEvent.BLOCK_CHANGE, pos);
                level.playSound(player, pos, s.getPlaceSound(), SoundSource.BLOCKS, (s.getVolume() + 1.0f) / 2.0f, s.getPitch() * 0.8f);
                if (player.getAbilities().instabuild || level.isClientSide()) return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
                stack.shrink(1);
                return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
            }
        }
        if (!canStrip || !(item instanceof AxeItem) || this.getHeldBlock().isAir() || !CommonConfigs.Building.AXE_TIMBER_FRAME_STRIP.get().booleanValue()) return ItemInteractionResult.FAIL;
        BlockState held = this.getHeldBlock();
        if (!level.isClientSide) {
            Block.popResourceFromFace((Level)level, (BlockPos)pos, (Direction)trace.getDirection(), (ItemStack)new ItemStack((ItemLike)this.getBlockState().getBlock()));
        }
        level.playSound(player, pos, this.getBlockState().getSoundType().getBreakSound(), SoundSource.BLOCKS, 1.0f, 1.0f);
        stack.hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)hand));
        level.setBlockAndUpdate(pos, held);
        return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
    }

    public static boolean isValidBlock(@Nullable BlockState state, BlockPos pos, Level world) {
        if (state == null) {
            return false;
        }
        Block b = state.getBlock();
        if (b.builtInRegistryHolder().is(ModTags.FRAME_BLOCK_BLACKLIST) || b instanceof EntityBlock) {
            return false;
        }
        if (b instanceof FeatherBlock || b instanceof SoulSandBlock) {
            return true;
        }
        return state.isSolidRender((BlockGetter)world, pos) && Block.isShapeFullBlock((VoxelShape)state.getCollisionShape((BlockGetter)world, pos));
    }

    public static class SelfPlacementContext
    extends BlockPlaceContext {
        public SelfPlacementContext(Player player, InteractionHand interactionHand, ItemStack itemStack, BlockHitResult blockHitResult) {
            super(player, interactionHand, itemStack, blockHitResult);
            this.replaceClicked = true;
        }
    }
}

