/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.placeable_book;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.mehvahdjukaar.moonlight.api.misc.MapRegistry;
import net.mehvahdjukaar.moonlight.api.platform.ClientHelper;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.common.block.placeable_book.BookModelVisuals;
import net.mehvahdjukaar.supplementaries.common.block.placeable_book.BookType;
import net.mehvahdjukaar.supplementaries.common.block.placeable_book.PlaceableBookManager;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.HolderLookup;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.world.item.ItemStack;

public class PlaceableBookManagerClient {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final MapRegistry<List<BookModelVisuals.VariantModelList>> bookVisuals = new MapRegistry("placeable_books_visuals");
    private static final BookModelVisuals missingModel = new BookModelVisuals(new ModelResourceLocation(Supplementaries.res("missing"), "missing"), -1, 0.0f, false);

    private static void reload(ResourceManager resourceManager) {
        HashMap js = new HashMap();
        SimpleJsonResourceReloadListener.scanDirectory((ResourceManager)resourceManager, (String)"placeable_books_visuals", (Gson)GSON, js);
        bookVisuals.clear();
        JsonOps ops = JsonOps.INSTANCE;
        for (Map.Entry entry : js.entrySet()) {
            List m = (List)BookModelVisuals.VariantModelList.LIST_CODEC.parse((DynamicOps)ops, (Object)((JsonElement)entry.getValue())).getOrThrow();
            bookVisuals.register((ResourceLocation)entry.getKey(), (Object)m);
        }
    }

    public static List<BookModelVisuals> getValidModelsForBookItem(HolderLookup.Provider level, ItemStack stack, boolean horizontal) {
        PlaceableBookManager instance = PlaceableBookManager.getInstance(level);
        BookType type = instance.get(stack.getItem(), horizontal);
        if (type == null) {
            Supplementaries.LOGGER.warn("No book type found for item: {}", (Object)stack.getItem());
            return List.of(missingModel);
        }
        List list = (List)bookVisuals.getValue(type.bookVisuals());
        if (list == null || list.isEmpty()) {
            Supplementaries.LOGGER.warn("No visuals found for book type: {}", (Object)type);
            return List.of(missingModel);
        }
        BookModelVisuals.VariantModelList modelsList = null;
        for (BookModelVisuals.VariantModelList m : list) {
            if (!m.matchesComponents(stack.getComponents())) continue;
            modelsList = m;
            break;
        }
        if (modelsList == null) {
            Supplementaries.LOGGER.warn("No visuals matched for book item: {}", (Object)stack);
            return List.of(missingModel);
        }
        return modelsList.models();
    }

    private static List<ModelResourceLocation> getExtraModels() {
        ArrayList<ModelResourceLocation> list = new ArrayList<ModelResourceLocation>();
        for (Map.Entry entry : bookVisuals.getEntries()) {
            for (BookModelVisuals.VariantModelList model : (List)entry.getValue()) {
                for (BookModelVisuals visuals : model.models()) {
                    list.add(visuals.model());
                }
            }
        }
        return list;
    }

    public static void registerExtraModels(ClientHelper.SpecialModelEvent event) {
        PlaceableBookManagerClient.reload(Minecraft.getInstance().getResourceManager());
        PlaceableBookManagerClient.getExtraModels().forEach(arg_0 -> ((ClientHelper.SpecialModelEvent)event).register(arg_0));
    }
}

