/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.blocks;

import net.mehvahdjukaar.moonlight.api.platform.network.NetworkHelper;
import net.mehvahdjukaar.supplementaries.common.block.tiles.MovingSlidyBlockEntity;
import net.mehvahdjukaar.supplementaries.common.network.ClientBoundSetSlidingBlockEntityPacket;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.mehvahdjukaar.supplementaries.reg.ModSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.piston.MovingPistonBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import org.jetbrains.annotations.Nullable;

public class MovingSlidyBlock
extends MovingPistonBlock {
    public MovingSlidyBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public static MovingSlidyBlockEntity newMovingBlockEntity(BlockPos pos, BlockState blockState, BlockState movedState, Direction direction) {
        return new MovingSlidyBlockEntity(pos, blockState, movedState, direction, true, false);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return MovingSlidyBlock.createTickerHelper(blockEntityType, ModRegistry.MOVING_SLIDY_BLOCK_TILE.get(), MovingSlidyBlockEntity::tick);
    }

    public static boolean maybeMove(BlockState state, Level level, BlockPos pos, Direction direction) {
        BlockPos neighborPos = pos.relative(direction);
        BlockState neighbor = level.getBlockState(neighborPos);
        if (!neighbor.isAir() && neighbor.getPistonPushReaction() != PushReaction.DESTROY) {
            return false;
        }
        level.destroyBlock(neighborPos, true);
        MovingSlidyBlock.move(state, level, pos, direction, neighborPos);
        if (!level.isClientSide) {
            level.playSound(null, pos, ModSounds.SLIDY_BLOCK_SLIDE.get(), SoundSource.BLOCKS, 1.0f, 1.1f + level.random.nextFloat() * 0.15f);
        }
        return true;
    }

    private static void move(BlockState state, Level level, BlockPos pos, Direction direction, BlockPos neighborPos) {
        BlockState newState = (BlockState)ModRegistry.MOVING_SLIDY_BLOCK.get().defaultBlockState().setValue((Property)FACING, (Comparable)direction);
        level.setBlock(neighborPos, newState, 3);
        MovingSlidyBlockEntity be = MovingSlidyBlock.newMovingBlockEntity(neighborPos, newState, state, direction);
        level.setBlockEntity((BlockEntity)be);
        if (!level.isClientSide) {
            NetworkHelper.sendToAllClientPlayersInDefaultRange((ServerLevel)((ServerLevel)level), (BlockPos)neighborPos, (CustomPacketPayload)new ClientBoundSetSlidingBlockEntityPacket(be));
        }
        level.removeBlock(pos, true);
        level.setBlock(pos, (BlockState)ModRegistry.MOVING_SLIDY_BLOCK_SOURCE.get().defaultBlockState().setValue((Property)BlockStateProperties.FACING, (Comparable)direction), 3);
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return null;
    }
}

