/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.blocks;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import net.mehvahdjukaar.supplementaries.common.block.blocks.StickBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class BlazeRodBlock
extends StickBlock {
    public BlazeRodBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)WATERLOGGED, (Comparable)Boolean.FALSE)).setValue((Property)AXIS_Y, (Comparable)Boolean.valueOf(true))).setValue((Property)AXIS_X, (Comparable)Boolean.valueOf(false))).setValue((Property)AXIS_Z, (Comparable)Boolean.valueOf(false)));
    }

    public void stepOn(Level world, BlockPos pos, BlockState state, Entity entity) {
        if (entity instanceof LivingEntity) {
            LivingEntity le = (LivingEntity)entity;
            le.hurt(le.damageSources().inFire(), 0.5f);
        }
        super.stepOn(world, pos, state, entity);
    }

    public void animateTick(BlockState state, Level world, BlockPos pos, RandomSource random) {
        int s;
        if ((double)random.nextFloat() > 0.3) {
            return;
        }
        IntArrayList list = new IntArrayList();
        if (((Boolean)state.getValue((Property)AXIS_Y)).booleanValue()) {
            list.add(0);
        }
        if (((Boolean)state.getValue((Property)AXIS_X)).booleanValue()) {
            list.add(1);
        }
        if (((Boolean)state.getValue((Property)AXIS_Z)).booleanValue()) {
            list.add(2);
        }
        if ((s = list.size()) > 0) {
            double z;
            double x;
            double y;
            SimpleParticleType particle = (Boolean)state.getValue((Property)WATERLOGGED) != false ? ParticleTypes.BUBBLE : ParticleTypes.SMOKE;
            int c = list.getInt(random.nextInt(s));
            switch (c) {
                case 1: {
                    y = (double)pos.getY() + 0.5 - 0.125 + (double)random.nextFloat() * 0.25;
                    x = (float)pos.getX() + random.nextFloat();
                    z = (double)pos.getZ() + 0.5 - 0.125 + (double)random.nextFloat() * 0.25;
                    break;
                }
                case 2: {
                    y = (double)pos.getY() + 0.5 - 0.125 + (double)random.nextFloat() * 0.25;
                    z = (float)pos.getZ() + random.nextFloat();
                    x = (double)pos.getX() + 0.5 - 0.125 + (double)random.nextFloat() * 0.25;
                    break;
                }
                default: {
                    x = (double)pos.getX() + 0.5 - 0.125 + (double)random.nextFloat() * 0.25;
                    y = (float)pos.getY() + random.nextFloat();
                    z = (double)pos.getZ() + 0.5 - 0.125 + (double)random.nextFloat() * 0.25;
                }
            }
            world.addParticle((ParticleOptions)particle, x, y, z, 0.0, 0.0, 0.0);
        }
    }
}

